/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.ErrorUml;
import net.sourceforge.plantuml.ErrorUmlType;
import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.PSystemError;
import net.sourceforge.plantuml.api.PSystemFactory;
import net.sourceforge.plantuml.core.DiagramType;
import net.sourceforge.plantuml.core.UmlSource;

public abstract class PSystemAbstractFactory
implements PSystemFactory {
    public static final String EMPTY_DESCRIPTION = "Empty description";
    private final DiagramType type;

    protected PSystemAbstractFactory(DiagramType type) {
        this.type = type;
    }

    protected final AbstractPSystem buildEmptyError(UmlSource source, LineLocation lineLocation) {
        ErrorUml err = new ErrorUml(ErrorUmlType.SYNTAX_ERROR, EMPTY_DESCRIPTION, lineLocation);
        PSystemError result = new PSystemError(source, err, null);
        result.setSource(source);
        return result;
    }

    protected final PSystemError buildExecutionError(UmlSource source, String stringError, LineLocation lineLocation) {
        ErrorUml err = new ErrorUml(ErrorUmlType.EXECUTION_ERROR, stringError, lineLocation);
        PSystemError result = new PSystemError(source, err, null);
        result.setSource(source);
        return result;
    }

    @Override
    public final DiagramType getDiagramType() {
        return this.type;
    }
}

