/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import net.sourceforge.plantuml.BlockUml;
import net.sourceforge.plantuml.ErrorStatus;
import net.sourceforge.plantuml.Option;
import net.sourceforge.plantuml.PSystemError;
import net.sourceforge.plantuml.SourceStringReader;
import net.sourceforge.plantuml.Stdrpt;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.preproc.Defines;

public class Pipe {
    private final Option option;
    private final InputStream is;
    private final PrintStream ps;
    private boolean closed = false;
    private final String charset;
    private final Stdrpt stdrpt;

    public Pipe(Option option, PrintStream ps, InputStream is, String charset) {
        this.option = option;
        this.is = is;
        this.ps = ps;
        this.charset = charset;
        this.stdrpt = option.getStdrpt();
    }

    public void managePipe(ErrorStatus error) throws IOException {
        boolean noStdErr = this.option.isPipeNoStdErr();
        int nb = 0;
        do {
            String source;
            if ((source = this.readOneDiagram()) == null) {
                this.ps.flush();
                if (nb == 0) {
                    // empty if block
                }
                return;
            }
            ++nb;
            Defines defines = this.option.getDefaultDefines();
            SourceStringReader sourceStringReader = new SourceStringReader(defines, source, this.option.getConfig());
            if (this.option.isComputeurl()) {
                for (BlockUml s : sourceStringReader.getBlocks()) {
                    this.ps.println(s.getEncodedUrl());
                }
            } else if (this.option.isSyntax()) {
                Diagram system = sourceStringReader.getBlocks().get(0).getDiagram();
                if (system instanceof UmlDiagram) {
                    error.goOk();
                    this.ps.println(((UmlDiagram)system).getUmlDiagramType().name());
                    this.ps.println(system.getDescription());
                } else if (system instanceof PSystemError) {
                    error.goWithError();
                    this.stdrpt.printInfo(this.ps, (PSystemError)system);
                } else {
                    error.goOk();
                    this.ps.println("OTHER");
                    this.ps.println(system.getDescription());
                }
            } else if (this.option.isPipeMap()) {
                String result = sourceStringReader.getCMapData(this.option.getImageIndex(), this.option.getFileFormatOption());
                if (result == null) {
                    this.ps.println();
                } else {
                    this.ps.println(result);
                }
            } else {
                OutputStream os = noStdErr ? new ByteArrayOutputStream() : this.ps;
                DiagramDescription result = sourceStringReader.outputImage(os, this.option.getImageIndex(), this.option.getFileFormatOption());
                this.printInfo(noStdErr ? this.ps : System.err, sourceStringReader);
                if (result != null && "(error)".equalsIgnoreCase(result.getDescription())) {
                    error.goWithError();
                } else {
                    error.goOk();
                    if (noStdErr) {
                        OutputStream baos = os;
                        ((ByteArrayOutputStream)baos).close();
                        this.ps.write(((ByteArrayOutputStream)baos).toByteArray());
                    }
                }
                if (this.option.getPipeDelimitor() != null) {
                    this.ps.println(this.option.getPipeDelimitor());
                }
            }
            this.ps.flush();
        } while (!this.closed);
        if (nb == 0) {
            // empty if block
        }
    }

    private void printInfo(PrintStream output, SourceStringReader sourceStringReader) {
        List<BlockUml> blocks = sourceStringReader.getBlocks();
        if (blocks.size() == 0) {
            this.stdrpt.printInfo(output, null);
        } else {
            this.stdrpt.printInfo(output, blocks.get(0).getDiagram());
        }
    }

    private boolean isFinished(String s) {
        return s == null || s.startsWith("@end");
    }

    private String readOneDiagram() throws IOException {
        String s;
        StringBuilder sb = new StringBuilder();
        do {
            if ((s = this.readOneLine()) == null) {
                this.closed = true;
                continue;
            }
            sb.append(s);
            sb.append("\n");
        } while (!this.isFinished(s));
        if (sb.length() == 0) {
            return null;
        }
        String source = sb.toString();
        if (!source.startsWith("@start")) {
            source = "@startuml\n" + source + "\n@enduml";
        }
        return source;
    }

    private String readOneLine() throws IOException {
        int read;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        do {
            if ((read = this.is.read()) == -1) {
                if (baos.size() == 0) {
                    return null;
                }
                break;
            }
            if (read == 13 || read == 10) continue;
            baos.write(read);
        } while (read != 10);
        if (this.charset == null) {
            return new String(baos.toByteArray());
        }
        return new String(baos.toByteArray(), this.charset);
    }
}

