/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.text.console;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import net.sourceforge.plantuml.text.AbstractDiagramTextProvider;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleListener;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.IPatternMatchListener;
import org.eclipse.ui.console.PatternMatchEvent;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.texteditor.ITextEditor;

public class ConsoleViewDiagramTextProvider
extends AbstractDiagramTextProvider
implements ISelectionProvider {
    private final IPatternMatchListener patternMatchListener = new IPatternMatchListener(){
        private final String qualifier;
        private final String pattern;
        {
            this.qualifier = ConsoleViewDiagramTextProvider.this.getStartPlantUml();
            this.pattern = String.valueOf(this.qualifier) + "((.|\\n)*)" + ConsoleViewDiagramTextProvider.this.getEndPlantUml();
        }

        public void connect(TextConsole console) {
        }

        public void matchFound(PatternMatchEvent matchEvent) {
            try {
                IDocument contents = ((TextConsole)matchEvent.getSource()).getDocument();
                String match = contents.get(matchEvent.getOffset(), matchEvent.getLength());
                ConsoleViewDiagramTextProvider.this.setSelection(ConsoleViewDiagramTextProvider.this.getDiagramText(match));
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        public void disconnect() {
            ConsoleViewDiagramTextProvider.this.setSelection((ISelection)StructuredSelection.EMPTY);
        }

        public String getPattern() {
            return this.pattern;
        }

        public String getLineQualifier() {
            return this.qualifier;
        }

        public int getCompilerFlags() {
            return 8;
        }
    };
    private final boolean startIsRegexp = true;
    private final boolean endIsRegexp = true;
    private final boolean includeStart = true;
    private final boolean includeEnd = true;
    private static final String newline = "\n";
    private ISelection selection = StructuredSelection.EMPTY;
    private final Collection<ISelectionChangedListener> selectionListeners = new ArrayList<ISelectionChangedListener>();

    public ConsoleViewDiagramTextProvider() {
        this.setEditorType(IConsoleView.class);
        ConsolePlugin.getDefault().getConsoleManager().addConsoleListener(new IConsoleListener(){

            public void consolesRemoved(IConsole[] consoles) {
                int i = 0;
                while (i < consoles.length) {
                    if (consoles[i] instanceof TextConsole) {
                        ((TextConsole)consoles[i]).removePatternMatchListener(ConsoleViewDiagramTextProvider.this.patternMatchListener);
                    }
                    ++i;
                }
            }

            public void consolesAdded(IConsole[] consoles) {
                int i = 0;
                while (i < consoles.length) {
                    if (consoles[i] instanceof TextConsole) {
                        ((TextConsole)consoles[i]).addPatternMatchListener(ConsoleViewDiagramTextProvider.this.patternMatchListener);
                    }
                    ++i;
                }
            }
        });
    }

    public boolean supportsSelection(ISelection selection) {
        return selection instanceof ITextSelection;
    }

    @Override
    protected String getDiagramText(IEditorPart editorPart, IEditorInput editorInput, ISelection selection, Map<String, Object> markerAttributes) {
        StringBuilder lines = this.getDiagramTextLines(editorPart, editorInput, selection, markerAttributes);
        return lines != null ? this.getDiagramText(lines) : null;
    }

    protected String getStartPlantUml() {
        return "@startuml";
    }

    protected String getEndPlantUml() {
        return "@enduml";
    }

    protected StringBuilder getDiagramTextLines(IEditorPart editorPart, IEditorInput editorInput, ISelection selection, Map<String, Object> markerAttributes) {
        ITextEditor textEditor = (ITextEditor)editorPart;
        IDocument document = textEditor.getDocumentProvider().getDocument((Object)editorInput);
        int selectionStart = ((ITextSelection)(selection != null ? selection : textEditor.getSelectionProvider().getSelection())).getOffset();
        FindReplaceDocumentAdapter finder = new FindReplaceDocumentAdapter(document);
        try {
            String startPlantUml = this.getStartPlantUml();
            String entPlantUml = this.getEndPlantUml();
            IRegion start = finder.find(selectionStart, startPlantUml, true, true, false, true);
            IRegion end = finder.find(selectionStart, entPlantUml, true, true, false, true);
            if (start == null || end != null && end.getOffset() < start.getOffset()) {
                start = finder.find(Math.min(selectionStart + startPlantUml.length(), document.getLength()), startPlantUml, false, true, false, true);
            }
            if (start != null) {
                int startOffset = start.getOffset();
                int startLine = document.getLineOfOffset(startOffset);
                end = finder.find(startOffset, entPlantUml, true, true, false, true);
                if (end != null) {
                    int endOffset = end.getOffset() + end.getLength();
                    StringBuilder result = new StringBuilder();
                    int maxLine = Math.min(document.getLineOfOffset(endOffset) + 1, document.getNumberOfLines());
                    int lineNum = startLine + 0;
                    while (lineNum < maxLine) {
                        String line = document.get(document.getLineOffset(lineNum), document.getLineLength(lineNum)).trim();
                        result.append(line);
                        if (!line.endsWith(newline)) {
                            result.append(newline);
                        }
                        ++lineNum;
                    }
                    markerAttributes.put("charStart", start.getOffset());
                    return result;
                }
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return null;
    }

    public String getDiagramText(CharSequence lines) {
        return this.getDiagramText(new StringBuilder(lines.toString()));
    }

    protected String getDiagramText(StringBuilder lines) {
        String startPlantUml = this.getStartPlantUml();
        String entPlantUml = this.getEndPlantUml();
        int start = Math.max(lines.indexOf(startPlantUml), 0);
        int end = Math.min(lines.lastIndexOf(entPlantUml) + entPlantUml.length(), lines.length());
        String linePrefix = lines.substring(0, start).trim();
        StringBuilder result = new StringBuilder(lines.length());
        while (start < end) {
            String line;
            int lineEnd = lines.indexOf(newline, start);
            if (lineEnd > end) break;
            if (lineEnd < 0) {
                lineEnd = lines.length();
            }
            if ((line = lines.substring(start, lineEnd).trim()).startsWith(linePrefix)) {
                line = line.substring(linePrefix.length()).trim();
            }
            result.append(line);
            result.append(newline);
            start = lineEnd + 1;
        }
        return result.toString().trim();
    }

    public ISelection getSelection() {
        return this.selection;
    }

    protected void setSelection(String diagramText) {
        this.setSelection((ISelection)new StructuredSelection((Object)diagramText));
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
        if (this.selectionListeners != null && !this.selectionListeners.isEmpty()) {
            SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
            for (ISelectionChangedListener listener : this.selectionListeners) {
                listener.selectionChanged(event);
            }
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove(listener);
    }
}

