/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Scanner;
import net.sourceforge.plantuml.eclipse.utils.DiagramTextProvider2;
import net.sourceforge.plantuml.eclipse.utils.PlantumlUtil;
import net.sourceforge.plantuml.text.AbstractDiagramTextProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class TextEditorDiagramTextProvider
extends AbstractDiagramTextProvider
implements DiagramTextProvider2 {
    private boolean startIsRegexp = true;
    private boolean endIsRegexp = true;
    private boolean includeStart = true;
    private boolean includeEnd = true;
    private static final String newline = "\n";
    private Collection<String> supportedExtensions = new ArrayList<String>(Arrays.asList("txt", "puml", "plantuml"));

    public TextEditorDiagramTextProvider() {
        this.setEditorType(ITextEditor.class);
    }

    public boolean supportsSelection(ISelection selection) {
        return selection instanceof ITextSelection;
    }

    @Override
    protected String getDiagramText(IEditorPart editorPart, IEditorInput editorInput, ISelection selection, Map<String, Object> markerAttributes) {
        StringBuilder lines = this.getDiagramTextLines(editorPart, editorInput, selection, markerAttributes);
        return lines != null ? this.getDiagramText(lines) : null;
    }

    protected StringBuilder getDiagramTextLines(IEditorPart editorPart, IEditorInput editorInput, ISelection selection, Map<String, Object> markerAttributes) {
        ITextEditor textEditor = (ITextEditor)editorPart;
        IDocument document = textEditor.getDocumentProvider().getDocument((Object)editorInput);
        int selectionStart = ((ITextSelection)textEditor.getSelectionProvider().getSelection()).getOffset();
        FindReplaceDocumentAdapter finder = new FindReplaceDocumentAdapter(document);
        try {
            IRegion start = finder.find(selectionStart, "@startuml", true, true, !this.startIsRegexp, this.startIsRegexp);
            IRegion end = finder.find(selectionStart, "@enduml", true, true, !this.endIsRegexp, this.endIsRegexp);
            if (start == null || end != null && end.getOffset() < start.getOffset()) {
                start = finder.find(Math.min(selectionStart + "@startuml".length(), document.getLength()), "@startuml", false, true, !this.startIsRegexp, this.startIsRegexp);
            }
            if (start != null) {
                int startOffset = start.getOffset();
                int startLine = document.getLineOfOffset(startOffset);
                end = finder.find(startOffset, "@enduml", true, true, !this.endIsRegexp, this.endIsRegexp);
                if (end != null) {
                    int endOffset = end.getOffset() + end.getLength();
                    StringBuilder result = new StringBuilder();
                    int maxLine = Math.min(document.getLineOfOffset(endOffset) + (this.includeEnd ? 1 : 0), document.getNumberOfLines());
                    int lineNum = startLine + (this.includeStart ? 0 : 1);
                    while (lineNum < maxLine) {
                        String line = document.get(document.getLineOffset(lineNum), document.getLineLength(lineNum)).trim();
                        result.append(line);
                        if (!line.endsWith(newline)) {
                            result.append(newline);
                        }
                        ++lineNum;
                    }
                    markerAttributes.put("charStart", start.getOffset());
                    return result;
                }
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return null;
    }

    public String getDiagramText(CharSequence lines) {
        return this.getDiagramText(new StringBuilder(lines.toString()));
    }

    protected String getDiagramText(StringBuilder lines) {
        int start = Math.max(lines.indexOf("@startuml"), 0);
        int end = Math.min(lines.lastIndexOf("@enduml") + "@enduml".length(), lines.length());
        String linePrefix = lines.substring(0, start).trim();
        StringBuilder result = new StringBuilder(lines.length());
        while (start < end) {
            String line;
            int lineEnd = lines.indexOf(newline, start);
            if (lineEnd > end) break;
            if (lineEnd < 0) {
                lineEnd = lines.length();
            }
            if ((line = lines.substring(start, lineEnd).trim()).startsWith(linePrefix)) {
                line = line.substring(linePrefix.length()).trim();
            }
            result.append(line);
            result.append(newline);
            start = lineEnd + 1;
        }
        return result.toString().trim();
    }

    public boolean supportsPath(IPath path) {
        return this.supportedExtensions.contains(path.getFileExtension());
    }

    public String getDiagramText(IPath path) {
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        if (file != null && file.exists()) {
            IMarker marker = PlantumlUtil.getPlantUmlMarker((IFile)file, (boolean)false);
            int startOffset = marker.getAttribute("charStart", 0);
            StringBuilder builder = null;
            try {
                Scanner scanner = new Scanner(file.getContents());
                while (scanner.hasNextLine()) {
                    String nextLine = scanner.nextLine();
                    if (builder == null) {
                        if (startOffset <= nextLine.length()) {
                            if (nextLine.indexOf("@startuml", startOffset) >= 0) {
                                builder = new StringBuilder();
                            }
                            startOffset = 0;
                        } else {
                            startOffset = startOffset - nextLine.length() - 1;
                        }
                    }
                    if (builder == null) continue;
                    builder.append(nextLine);
                    builder.append(newline);
                    if (nextLine.contains("@enduml")) break;
                }
                scanner.close();
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            if (builder != null) {
                return this.getDiagramText(builder);
            }
        }
        return null;
    }
}

