/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.eclipse.views;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sourceforge.plantuml.eclipse.Activator;
import net.sourceforge.plantuml.eclipse.utils.DiagramTextIteratorProvider;
import net.sourceforge.plantuml.eclipse.utils.DiagramTextProvider;
import net.sourceforge.plantuml.eclipse.utils.DiagramTextProvider2;
import net.sourceforge.plantuml.eclipse.utils.PlantumlConstants;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public abstract class AbstractDiagramSourceView
extends ViewPart {
    private String pinnedToId = null;
    private IEditorPart pinnedTo = null;
    private String initialDiagramSource = null;
    private Control parent;
    private IAction toggleAction;
    private IAction pinToAction;
    private IAction spawnAction;
    private boolean visible = false;
    private final IPartListener2 partListener = new PartListener();
    private final DiagramTextChangedListener diagramTextChangedListener = new DiagramTextChangedListener();
    private IWorkbenchPart currentPart;

    public void saveState(IMemento memento) {
        super.saveState(memento);
        memento.putString("pinnedTo", this.pinnedTo != null ? this.getEditorInputId(this.pinnedTo.getEditorInput()) : null);
        memento.putString("initialDiagramSource", this.getDiagramText());
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        if (memento != null) {
            this.pinnedToId = memento.getString("pinnedTo");
            this.initialDiagramSource = memento.getString("initialDiagramSource");
        }
    }

    public boolean isLinkedToActivePart() {
        return true;
    }

    public boolean isLinkingActive() {
        return this.isLinkedToActivePart() && this.toggleAction == null || this.toggleAction.isChecked();
    }

    protected void asyncExec(Runnable runnable) {
        this.parent.getDisplay().asyncExec(runnable);
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        if (this.isLinkedToActivePart()) {
            this.registerListeners();
            this.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (AbstractDiagramSourceView.this.pinnedTo != null || AbstractDiagramSourceView.this.initialDiagramSource == null) {
                        AbstractDiagramSourceView.this.updateDiagramText(true, (IWorkbenchPart)AbstractDiagramSourceView.this.pinnedTo, null);
                    } else if (AbstractDiagramSourceView.this.initialDiagramSource != null) {
                        AbstractDiagramSourceView.this.updateDiagramText(AbstractDiagramSourceView.this.initialDiagramSource, null, null);
                    }
                }
            });
        }
        this.makeActions();
        this.contributeToActionBars();
    }

    protected void contributeToActionBars() {
    }

    protected void makeActions() {
        this.pinToAction = new Action(){

            public boolean isEnabled() {
                return AbstractDiagramSourceView.this.isLinkedToActivePart();
            }

            public void run() {
                AbstractDiagramSourceView.this.pinnedTo = this.isChecked() && AbstractDiagramSourceView.this.currentPart instanceof IEditorPart ? (IEditorPart)AbstractDiagramSourceView.this.currentPart : null;
                if (AbstractDiagramSourceView.this.pinnedTo != null) {
                    this.setToolTipText("Pinned to " + AbstractDiagramSourceView.this.getEditorInputId(AbstractDiagramSourceView.this.pinnedTo.getEditorInput()));
                } else {
                    AbstractDiagramSourceView.this.updateDiagramText(true, null, null);
                    this.setToolTipText("Pin view to editor");
                }
            }
        };
        this.pinToAction.setToolTipText("Pin view to editor");
        this.pinToAction.setImageDescriptor(ImageDescriptor.createFromFile(PlantumlConstants.class, (String)"/icons/pin.png"));
        this.pinToAction.setChecked(this.pinnedTo != null || this.pinnedToId != null);
        this.spawnAction = new Action(){

            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                String id = AbstractDiagramSourceView.this.getViewSite().getId();
                try {
                    page.showView(id, String.valueOf(id) + "-" + System.currentTimeMillis(), 1);
                }
                catch (PartInitException partInitException) {
                    // empty catch block
                }
            }
        };
        this.spawnAction.setToolTipText("Open another view");
        this.spawnAction.setImageDescriptor(ImageDescriptor.createFromFile(PlantumlConstants.class, (String)"/icons/spawn.png"));
        this.toggleAction = new Action(){

            public void run() {
                if (this.isChecked()) {
                    AbstractDiagramSourceView.this.updateDiagramText(true, null, null);
                }
            }
        };
        this.toggleAction.setToolTipText("Link with editor");
        this.toggleAction.setImageDescriptor(ImageDescriptor.createFromFile(PlantumlConstants.class, (String)"/icons/link.gif"));
        this.toggleAction.setChecked(true);
    }

    protected void addActions(IContributionManager manager, IAction ... actions) {
        if (!manager.isEmpty()) {
            manager.add((IContributionItem)new Separator());
        }
        IAction[] iActionArray = actions;
        int n = actions.length;
        int n2 = 0;
        while (n2 < n) {
            IAction action = iActionArray[n2];
            manager.add(action);
            ++n2;
        }
    }

    protected void addViewActions(IContributionManager toolBarManager) {
        this.addActions(toolBarManager, this.spawnAction, this.pinToAction, this.toggleAction);
    }

    protected String getEditorInputId(IEditorInput editorInput) {
        if (editorInput instanceof IStorageEditorInput) {
            IPath path = null;
            try {
                path = ((IStorageEditorInput)editorInput).getStorage().getFullPath();
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            if (path != null) {
                return path.toString();
            }
        }
        if (editorInput instanceof IPathEditorInput) {
            return ((IPathEditorInput)editorInput).getPath().toString();
        }
        if (editorInput instanceof IURIEditorInput) {
            return ((IURIEditorInput)editorInput).getURI().toString();
        }
        return editorInput.getName();
    }

    protected boolean acceptPart(IWorkbenchPart part) {
        if (this.pinnedTo == null && this.pinnedToId == null) {
            return true;
        }
        if (this.pinnedTo != null && this.pinnedTo == part) {
            return true;
        }
        if (part instanceof IEditorPart && this.pinnedToId != null && this.acceptEditorInput(this.pinnedToId, ((IEditorPart)part).getEditorInput())) {
            this.pinnedTo = (IEditorPart)part;
            this.pinnedToId = null;
            return true;
        }
        return false;
    }

    protected boolean acceptEditorInput(String inputId, IEditorInput editorInput) {
        return this.pinnedToId.equals(this.getEditorInputId(editorInput));
    }

    protected void registerListeners() {
        this.getSite().getPage().addPartListener(this.partListener);
        this.getSite().getPage().addPostSelectionListener((ISelectionListener)this.diagramTextChangedListener);
        DiagramTextProvider[] diagramTextProviderArray = Activator.getDefault().getDiagramTextProviders(null);
        int n = diagramTextProviderArray.length;
        int n2 = 0;
        while (n2 < n) {
            DiagramTextProvider diagramTextProvider = diagramTextProviderArray[n2];
            if (diagramTextProvider instanceof ISelectionProvider) {
                ((ISelectionProvider)diagramTextProvider).addSelectionChangedListener((ISelectionChangedListener)this.diagramTextChangedListener);
            }
            ++n2;
        }
    }

    public void dispose() {
        if (this.currentPart != null) {
            this.currentPart.removePropertyListener((IPropertyListener)this.diagramTextChangedListener);
        }
        this.getSite().getPage().removePartListener(this.partListener);
        this.getSite().getPage().removePostSelectionListener((ISelectionListener)this.diagramTextChangedListener);
        DiagramTextProvider[] diagramTextProviderArray = Activator.getDefault().getDiagramTextProviders(null);
        int n = diagramTextProviderArray.length;
        int n2 = 0;
        while (n2 < n) {
            DiagramTextProvider diagramTextProvider = diagramTextProviderArray[n2];
            if (diagramTextProvider instanceof ISelectionProvider) {
                ((ISelectionProvider)diagramTextProvider).removeSelectionChangedListener((ISelectionChangedListener)this.diagramTextChangedListener);
            }
            ++n2;
        }
    }

    protected abstract void updateDiagramText(String var1, IPath var2, Map<String, Object> var3);

    public abstract String getDiagramText();

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    protected boolean isThisView(IWorkbenchPartReference partRef) {
        return this.getSite().getId().equals(partRef.getId());
    }

    private void handlePartChange(IWorkbenchPart part) {
        if (this.currentPart != null) {
            this.currentPart.removePropertyListener((IPropertyListener)this.diagramTextChangedListener);
        }
        this.currentPart = part;
        if (this.currentPart != null) {
            this.currentPart.addPropertyListener((IPropertyListener)this.diagramTextChangedListener);
        }
    }

    protected Collection<ActionContributionItem> getEditorSelectionActions(IMenuManager menu) {
        ArrayList<ActionContributionItem> actions = new ArrayList<ActionContributionItem>();
        DiagramTextProvider[] diagramTextProviders = Activator.getDefault().getDiagramTextProviders(true);
        IEditorPart editor = this.pinnedTo != null ? this.pinnedTo : this.getSite().getPage().getActiveEditor();
        ISelectionProvider selectionProvider = editor.getSite().getSelectionProvider();
        if (selectionProvider != null) {
            DiagramTextProvider[] diagramTextProviderArray = diagramTextProviders;
            int n = diagramTextProviders.length;
            int n2 = 0;
            while (n2 < n) {
                DiagramTextProvider diagramTextProvider = diagramTextProviderArray[n2];
                if (diagramTextProvider instanceof DiagramTextIteratorProvider && diagramTextProvider.supportsEditor(editor)) {
                    Iterator<ISelection> selections = ((DiagramTextIteratorProvider)diagramTextProvider).getDiagramText(editor);
                    while (selections.hasNext()) {
                        ISelection selection = selections.next();
                        ActionContributionItem action = new ActionContributionItem((IAction)this.createEditorSelectionAction(editor, selectionProvider, selection));
                        actions.add(action);
                    }
                }
                ++n2;
            }
        }
        return actions;
    }

    private Action createEditorSelectionAction(final IEditorPart editor, final ISelectionProvider selectionProvider, final ISelection selection) {
        return new Action(selection.toString()){

            public void run() {
                AbstractDiagramSourceView.this.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        AbstractDiagramSourceView.this.diagramTextChangedListener.diagramChanged((IWorkbenchPart)editor, selection);
                        selectionProvider.setSelection(selection);
                    }
                });
            }
        };
    }

    protected void updateDiagramText(boolean force, IWorkbenchPart part, ISelection selection) {
        IWorkbenchPart activePart;
        Object object = part != null ? part : (activePart = this.isLinkedToActivePart() ? this.getSite().getPage().getActivePart() : null);
        if ((force || activePart != this.currentPart) && (activePart == null || this.acceptPart(activePart))) {
            IPath path = null;
            this.handlePartChange(activePart);
            if (activePart != null) {
                ISelectionProvider selectionProvider;
                if (activePart instanceof IEditorPart && ((IEditorPart)activePart).getEditorInput() instanceof IFileEditorInput) {
                    path = ((IFileEditorInput)((IEditorPart)activePart).getEditorInput()).getFile().getFullPath();
                }
                if (selection == null && (selectionProvider = activePart.getSite().getSelectionProvider()) != null) {
                    selection = selectionProvider.getSelection();
                }
                if (this.updateDiagramText(activePart, selection, path)) {
                    return;
                }
                if (selection != null && this.updateDiagramText(activePart, null, path)) {
                    return;
                }
            }
            this.updateDiagramText((String)null, (IPath)null, (Map<String, Object>)null);
        }
    }

    protected boolean supportsPart(DiagramTextProvider diagramTextProvider, IWorkbenchPart part) {
        if (part instanceof IViewPart) {
            return diagramTextProvider.supportsView((IViewPart)part);
        }
        if (part instanceof IEditorPart) {
            return diagramTextProvider.supportsEditor((IEditorPart)part);
        }
        return false;
    }

    protected String getDiagramText(DiagramTextProvider diagramTextProvider, IWorkbenchPart part, ISelection selection) {
        if (part instanceof IViewPart) {
            return diagramTextProvider.getDiagramText((IViewPart)part, selection);
        }
        if (part instanceof IEditorPart) {
            return diagramTextProvider.getDiagramText((IEditorPart)part, selection);
        }
        return null;
    }

    private boolean updateDiagramText(IWorkbenchPart activePart, ISelection selection, IPath path) {
        if (activePart != null) {
            DiagramTextProvider[] diagramTextProviders = Activator.getDefault().getDiagramTextProviders(true);
            HashMap<String, Object> markerAttributes = new HashMap<String, Object>();
            int i = 0;
            while (i < diagramTextProviders.length) {
                DiagramTextProvider diagramTextProvider = diagramTextProviders[i];
                if (this.supportsPart(diagramTextProvider, activePart) && (selection == null || diagramTextProvider.supportsSelection(selection))) {
                    String diagramText = null;
                    if (activePart instanceof IEditorPart && diagramTextProvider instanceof DiagramTextProvider2) {
                        markerAttributes.clear();
                        diagramText = ((DiagramTextProvider2)diagramTextProvider).getDiagramText((IEditorPart)activePart, selection, markerAttributes);
                    } else {
                        diagramText = this.getDiagramText(diagramTextProvider, activePart, selection);
                    }
                    if (diagramText != null) {
                        this.updateDiagramText(diagramText, path, markerAttributes);
                        return true;
                    }
                }
                ++i;
            }
        }
        return false;
    }

    private class DiagramTextChangedListener
    implements IPropertyListener,
    ISelectionListener,
    ISelectionChangedListener {
        private DiagramTextChangedListener() {
        }

        public void propertyChanged(Object source, int propId) {
            if (source == AbstractDiagramSourceView.this.currentPart && propId == 257 && AbstractDiagramSourceView.this.currentPart instanceof IEditorPart && !((IEditorPart)AbstractDiagramSourceView.this.currentPart).isDirty()) {
                this.diagramChanged(AbstractDiagramSourceView.this.currentPart, null);
            }
        }

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (part == AbstractDiagramSourceView.this.currentPart) {
                this.diagramChanged(AbstractDiagramSourceView.this.currentPart, selection);
            }
        }

        protected void diagramChanged(IWorkbenchPart editor, ISelection selection) {
            if (AbstractDiagramSourceView.this.isLinkingActive()) {
                AbstractDiagramSourceView.this.updateDiagramText(true, editor, selection);
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection selection;
            if ((!(event.getSource() instanceof DiagramTextProvider) || Activator.getDefault().isEnabled((DiagramTextProvider)event.getSource())) && (selection = event.getSelection()) instanceof IStructuredSelection) {
                final Object o = ((IStructuredSelection)selection).getFirstElement();
                AbstractDiagramSourceView.this.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        AbstractDiagramSourceView.this.updateDiagramText(String.valueOf(o), null, null);
                    }
                });
            }
        }
    }

    private class PartListener
    implements IPartListener2 {
        private PartListener() {
        }

        protected void updateDiagramText(IWorkbenchPart part) {
            if (AbstractDiagramSourceView.this.isLinkingActive()) {
                AbstractDiagramSourceView.this.updateDiagramText(false, part, null);
            }
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partActivated(IWorkbenchPartReference partRef) {
            this.updateDiagramText(partRef.getPart(true));
        }

        public void partVisible(IWorkbenchPartReference partRef) {
            if (AbstractDiagramSourceView.this.isThisView(partRef)) {
                AbstractDiagramSourceView.this.setVisible(true);
            }
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
            if (AbstractDiagramSourceView.this.isThisView(partRef)) {
                AbstractDiagramSourceView.this.setVisible(false);
            }
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
        }
    }
}

