/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.eclipse.imagecontrol;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import net.sourceforge.plantuml.eclipse.imagecontrol.ILinkSupport;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ScrollBar;

public class ImageControl
extends Canvas {
    private Image sourceImage;
    private Image screenImage;
    private AffineTransform transform = new AffineTransform();
    private Cursor panCursor;
    private Cursor linkCursor;
    private Cursor unsupportedLinkCursor;
    private Point panPoint = null;
    private Point panDelta = null;
    private Collection<ILinkSupport> linkSupports = new ArrayList<ILinkSupport>();

    public ImageControl(Composite parent) {
        this(parent, 0);
    }

    public ImageControl(Composite parent, int style) {
        super(parent, style | 0x800 | 0x200 | 0x100 | 0x40000);
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                ImageControl.this.syncScrollBars();
            }
        });
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                ImageControl.this.paint(event.gc);
            }
        });
        this.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                int dx = 0;
                int dy = 0;
                switch (e.keyCode) {
                    case 0x1000002: {
                        dy = 10;
                        break;
                    }
                    case 0x1000001: {
                        dy = -10;
                        break;
                    }
                    case 0x1000006: {
                        dy = 100;
                        break;
                    }
                    case 0x1000005: {
                        dy = -100;
                        break;
                    }
                    case 0x1000003: {
                        dx = -10;
                        break;
                    }
                    case 0x1000004: {
                        dx = 10;
                        break;
                    }
                }
                if (dx != 0 || dy != 0) {
                    ImageControl.this.pan(new Point(dx, dy));
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        PanHandler panHandler = new PanHandler();
        this.addMouseListener(panHandler);
        this.addMouseMoveListener(panHandler);
        this.panCursor = new Cursor((Device)parent.getDisplay(), 0);
        this.linkCursor = new Cursor((Device)parent.getDisplay(), 21);
        this.unsupportedLinkCursor = new Cursor((Device)parent.getDisplay(), 20);
        this.setCursor(this.panCursor);
        this.initScrollBars();
    }

    private void dispose(Resource resource) {
        if (resource != null && !resource.isDisposed()) {
            resource.dispose();
        }
    }

    public void dispose() {
        this.dispose((Resource)this.sourceImage);
        this.dispose((Resource)this.screenImage);
        this.dispose((Resource)this.panCursor);
        this.dispose((Resource)this.linkCursor);
        this.dispose((Resource)this.unsupportedLinkCursor);
        super.dispose();
    }

    private void paint(GC gc) {
        Rectangle clientRect = this.getClientArea();
        if (this.sourceImage != null) {
            Rectangle imageRect = ImageControl.inverseTransformRect(this.transform, clientRect);
            int gap = 2;
            imageRect.x -= gap;
            imageRect.y -= gap;
            imageRect.width += 2 * gap;
            imageRect.height += 2 * gap;
            Rectangle imageBound = this.sourceImage.getBounds();
            imageRect = imageRect.intersection(imageBound);
            Rectangle destRect = ImageControl.transformRect(this.transform, imageRect);
            if (this.screenImage != null) {
                this.screenImage.dispose();
            }
            this.screenImage = new Image((Device)this.getDisplay(), clientRect.width, clientRect.height);
            GC newGC = new GC((Drawable)this.screenImage);
            newGC.setClipping(clientRect);
            newGC.drawImage(this.sourceImage, imageRect.x, imageRect.y, imageRect.width, imageRect.height, destRect.x, destRect.y, destRect.width, destRect.height);
            newGC.dispose();
            gc.drawImage(this.screenImage, 0, 0);
        } else {
            gc.setClipping(clientRect);
            gc.fillRectangle(clientRect);
            this.initScrollBars();
        }
    }

    private Object findLink(int canvasX, int canvasY, boolean open) {
        for (ILinkSupport linkSupport : this.linkSupports) {
            Object link;
            Point pt = null;
            if (pt == null) {
                pt = ImageControl.inverseTransformPoint(this.transform, new Point(canvasX, canvasY));
            }
            if ((link = linkSupport.getLink(pt.x, pt.y)) == null) continue;
            if (open) {
                linkSupport.openLink(link);
            }
            return link;
        }
        return null;
    }

    public void addLinkSupport(ILinkSupport linkSupport) {
        this.linkSupports.add(linkSupport);
    }

    public void removeLinkSupport(ILinkSupport linkSupport) {
        this.linkSupports.remove(linkSupport);
    }

    private void initScrollBars() {
        ScrollBar horizontal = this.getHorizontalBar();
        horizontal.setEnabled(false);
        horizontal.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageControl.this.scrollHorizontally((ScrollBar)event.widget);
            }
        });
        ScrollBar vertical = this.getVerticalBar();
        vertical.setEnabled(false);
        vertical.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageControl.this.scrollVertically((ScrollBar)event.widget);
            }
        });
    }

    private void scrollHorizontally(ScrollBar scrollBar) {
        if (this.sourceImage == null) {
            return;
        }
        AffineTransform af = this.transform;
        double tx = af.getTranslateX();
        double select = -scrollBar.getSelection();
        af.preConcatenate(AffineTransform.getTranslateInstance(select - tx, 0.0));
        this.transform = af;
        this.syncScrollBars();
    }

    private void scrollVertically(ScrollBar scrollBar) {
        if (this.sourceImage == null) {
            return;
        }
        AffineTransform af = this.transform;
        double ty = af.getTranslateY();
        double select = -scrollBar.getSelection();
        af.preConcatenate(AffineTransform.getTranslateInstance(0.0, select - ty));
        this.transform = af;
        this.syncScrollBars();
    }

    public void syncScrollBars() {
        if (this.isDisposed()) {
            return;
        }
        if (this.sourceImage == null) {
            this.redraw();
            return;
        }
        AffineTransform af = this.transform;
        double sx = af.getScaleX();
        double sy = af.getScaleY();
        double tx = af.getTranslateX();
        double ty = af.getTranslateY();
        if (tx > 0.0) {
            tx = 0.0;
        }
        if (ty > 0.0) {
            ty = 0.0;
        }
        ScrollBar horizontal = this.getHorizontalBar();
        horizontal.setIncrement(this.getClientArea().width / 20);
        horizontal.setPageIncrement(this.getClientArea().width);
        Rectangle imageBounds = this.sourceImage.getBounds();
        int caw = this.getClientArea().width;
        int cah = this.getClientArea().height;
        if ((double)imageBounds.width * sx > (double)caw) {
            horizontal.setMaximum((int)((double)imageBounds.width * sx));
            horizontal.setEnabled(true);
            if ((int)(-tx) > horizontal.getMaximum() - caw) {
                tx = -horizontal.getMaximum() + caw;
            }
        } else {
            horizontal.setEnabled(false);
            tx = ((double)caw - (double)imageBounds.width * sx) / 2.0;
        }
        horizontal.setSelection((int)(-tx));
        horizontal.setThumb(caw);
        ScrollBar vertical = this.getVerticalBar();
        vertical.setIncrement(cah / 20);
        vertical.setPageIncrement(cah);
        if ((double)imageBounds.height * sy > (double)cah) {
            vertical.setMaximum((int)((double)imageBounds.height * sy));
            vertical.setEnabled(true);
            if ((int)(-ty) > vertical.getMaximum() - cah) {
                ty = -vertical.getMaximum() + cah;
            }
        } else {
            vertical.setEnabled(false);
            ty = ((double)cah - (double)imageBounds.height * sy) / 2.0;
        }
        vertical.setSelection((int)(-ty));
        vertical.setThumb(cah);
        af = AffineTransform.getScaleInstance(sx, sy);
        af.preConcatenate(AffineTransform.getTranslateInstance(tx, ty));
        this.transform = af;
        this.redraw();
    }

    public void loadImage(ImageData imageData) {
        if (this.sourceImage != null && !this.sourceImage.isDisposed()) {
            this.sourceImage.dispose();
            this.sourceImage = null;
        }
        this.sourceImage = new Image((Device)this.getDisplay(), imageData);
        this.resetZoom();
    }

    public void showErrorMessage(Throwable t) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(os);
        t.printStackTrace(pw);
        pw.close();
        this.showErrorMessage(os.toString());
    }

    public void showErrorMessage(String s) {
        if (this.sourceImage != null && !this.sourceImage.isDisposed()) {
            this.sourceImage.dispose();
            this.sourceImage = null;
        }
        this.sourceImage = new Image((Device)this.getDisplay(), 500, 500);
        GC gc = new GC((Drawable)this.sourceImage);
        String[] ss = s.split("\n");
        int lineHeight = gc.getFontMetrics().getHeight();
        int i = 0;
        while (i < ss.length) {
            String line = ss[i];
            if (line.startsWith("\t")) {
                line = "    " + line.substring(1);
                gc.setForeground(this.getDisplay().getSystemColor(2));
            } else {
                gc.setForeground(this.getDisplay().getSystemColor(3));
            }
            gc.drawString(line, 10, i * lineHeight);
            ++i;
        }
        gc.dispose();
        this.resetZoom();
    }

    public void setImageData(ImageData data) {
        if (this.sourceImage != null) {
            this.sourceImage.dispose();
        }
        if (data != null) {
            this.sourceImage = new Image((Device)this.getDisplay(), data);
        }
        this.syncScrollBars();
    }

    public void fitZoom() {
        if (this.sourceImage == null) {
            return;
        }
        Rectangle imageBound = this.sourceImage.getBounds();
        Rectangle destRect = this.getClientArea();
        double sx = (double)destRect.width / (double)imageBound.width;
        double sy = (double)destRect.height / (double)imageBound.height;
        double s = Math.min(sx, sy);
        double dx = 0.5 * (double)destRect.width;
        double dy = 0.5 * (double)destRect.height;
        this.transform = new AffineTransform();
        this.zoom(dx, dy, s);
    }

    public void resetZoom() {
        if (this.sourceImage != null) {
            this.transform = new AffineTransform();
            this.syncScrollBars();
        }
    }

    public void zoom(double dx, double dy, double scale) {
        if (this.sourceImage == null) {
            return;
        }
        this.transform.preConcatenate(AffineTransform.getTranslateInstance(-dx, -dy));
        this.transform.preConcatenate(AffineTransform.getScaleInstance(scale, scale));
        this.transform.preConcatenate(AffineTransform.getTranslateInstance(dx, dy));
        this.syncScrollBars();
    }

    public void zoomCentered(double scale) {
        Rectangle rect = this.getClientArea();
        int w = rect.width;
        int h = rect.height;
        double dx = (double)w / 2.0;
        double dy = (double)h / 2.0;
        this.zoom(dx, dy, scale);
    }

    private void pan(Point p) {
        Rectangle bounds = this.screenImage.getBounds();
        ScrollBar hBar = this.getHorizontalBar();
        ScrollBar vBar = this.getVerticalBar();
        Rectangle barBounds = bounds;
        int sdx = p.x * barBounds.width / bounds.width;
        int sdy = p.y * barBounds.height / bounds.height;
        p.x -= sdx * bounds.width / barBounds.width;
        p.y -= sdy * bounds.height / barBounds.height;
        if (sdx != 0) {
            hBar.setSelection(hBar.getSelection() + sdx);
            this.scrollHorizontally(hBar);
        }
        if (sdy != 0) {
            vBar.setSelection(vBar.getSelection() + sdy);
            this.scrollVertically(vBar);
        }
    }

    private static Rectangle transformRect(AffineTransform af, Rectangle src) {
        Rectangle dest = new Rectangle(0, 0, 0, 0);
        src = ImageControl.absRect(src);
        Point p1 = new Point(src.x, src.y);
        p1 = ImageControl.transformPoint(af, p1);
        dest.x = p1.x;
        dest.y = p1.y;
        dest.width = (int)((double)src.width * af.getScaleX());
        dest.height = (int)((double)src.height * af.getScaleY());
        return dest;
    }

    private static Rectangle inverseTransformRect(AffineTransform af, Rectangle src) {
        Rectangle dest = new Rectangle(0, 0, 0, 0);
        src = ImageControl.absRect(src);
        Point p1 = new Point(src.x, src.y);
        p1 = ImageControl.inverseTransformPoint(af, p1);
        dest.x = p1.x;
        dest.y = p1.y;
        dest.width = (int)((double)src.width / af.getScaleX());
        dest.height = (int)((double)src.height / af.getScaleY());
        return dest;
    }

    private static Point transformPoint(AffineTransform af, Point pt) {
        Point2D.Float src = new Point2D.Float(pt.x, pt.y);
        Point2D dest = af.transform(src, null);
        Point point = new Point((int)Math.floor(dest.getX()), (int)Math.floor(dest.getY()));
        return point;
    }

    private static Point inverseTransformPoint(AffineTransform af, Point pt) {
        Point2D.Float src = new Point2D.Float(pt.x, pt.y);
        try {
            Point2D dest = af.inverseTransform(src, null);
            return new Point((int)Math.floor(dest.getX()), (int)Math.floor(dest.getY()));
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Point(0, 0);
        }
    }

    private static Rectangle absRect(Rectangle src) {
        Rectangle dest = new Rectangle(0, 0, 0, 0);
        if (src.width < 0) {
            dest.x = src.x + src.width + 1;
            dest.width = -src.width;
        } else {
            dest.x = src.x;
            dest.width = src.width;
        }
        if (src.height < 0) {
            dest.y = src.y + src.height + 1;
            dest.height = -src.height;
        } else {
            dest.y = src.y;
            dest.height = src.height;
        }
        return dest;
    }

    private class PanHandler
    implements MouseListener,
    MouseMoveListener {
        private PanHandler() {
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
            if (ImageControl.this.findLink(e.x, e.y, false) == null) {
                ImageControl.this.panPoint = new Point(e.x, e.y);
                ImageControl.this.panDelta = new Point(0, 0);
            }
        }

        public void mouseMove(MouseEvent e) {
            if (ImageControl.this.panPoint != null && ImageControl.this.panDelta != null) {
                ((ImageControl)ImageControl.this).panDelta.x += ((ImageControl)ImageControl.this).panPoint.x - e.x;
                ((ImageControl)ImageControl.this).panDelta.y += ((ImageControl)ImageControl.this).panPoint.y - e.y;
                ((ImageControl)ImageControl.this).panPoint.x = e.x;
                ((ImageControl)ImageControl.this).panPoint.y = e.y;
                ImageControl.this.pan(ImageControl.this.panDelta);
            } else {
                String oldToolTip;
                String toolTip;
                Cursor cursor;
                Object link = ImageControl.this.findLink(e.x, e.y, false);
                Cursor cursor2 = cursor = link != null ? ImageControl.this.linkCursor : ImageControl.this.panCursor;
                if (cursor != ImageControl.this.getCursor()) {
                    ImageControl.this.setCursor(cursor);
                }
                if (!((toolTip = link != null ? link.toString() : null) == (oldToolTip = ImageControl.this.getToolTipText()) || toolTip != null && toolTip.equals(oldToolTip))) {
                    ImageControl.this.setToolTipText(toolTip);
                }
            }
        }

        public void mouseUp(MouseEvent e) {
            if (ImageControl.this.panPoint != null && ImageControl.this.panDelta != null) {
                ImageControl.this.panPoint = null;
            } else {
                ImageControl.this.findLink(e.x, e.y, true);
            }
        }
    }
}

