/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.yamleditor.script.formatter;

import de.jcup.yamleditor.script.formatter.DefaultYamlSourceFormatterConfig;
import de.jcup.yamleditor.script.formatter.SnakeYamlConfig;
import de.jcup.yamleditor.script.formatter.TypeConversionPreventionSnakeYamlResolver;
import de.jcup.yamleditor.script.formatter.YamlSourceFormatterConfig;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.representer.Representer;
import org.yaml.snakeyaml.resolver.Resolver;

public class YamlSourceFormatter {
    private static final String START_BLOCK = "---";

    public String format(String source) {
        return this.format(source, null);
    }

    public String format(String source, YamlSourceFormatterConfig config) {
        if (config == null) {
            config = new DefaultYamlSourceFormatterConfig();
        }
        SnakeYamlConfig snakeConfig = new SnakeYamlConfig(config);
        boolean restoreCommentsEnabled = config.isRestoreCommentsEnabled();
        CommentsRescueContext rescueContext = null;
        if (restoreCommentsEnabled) {
            rescueContext = this.backupCommentsAndMetaData(source, snakeConfig);
        }
        Yaml yamlParser = this.createYaml(new DumperOptions(), snakeConfig);
        Iterable yamlDocuments = yamlParser.loadAll(source);
        String formatted = this.formatDocuments(yamlDocuments, snakeConfig);
        String result = this.dropFirstBlockIfNotDefinedBefore(formatted, snakeConfig);
        if (restoreCommentsEnabled) {
            result = this.restoreEndingCommentsBySearchForNewLine(result, rescueContext, snakeConfig);
            result = this.restoreEndingCommentsByLineNumbers(result, rescueContext, snakeConfig);
            result = this.restoreFullCommentsBySearchForNewLine(result, rescueContext, snakeConfig);
            result = this.restoreFullCommentsByLineNumbers(result, rescueContext, snakeConfig);
            result = this.appendOrphanedComments(result, rescueContext, snakeConfig);
        }
        return result.trim();
    }

    private String appendOrphanedComments(String result, CommentsRescueContext context, SnakeYamlConfig internalConfig) {
        if (context.commentMarkers.isEmpty()) {
            return result;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(result.trim());
        sb.append("\n");
        sb.append("# ----------------\n");
        sb.append("# Orphan comments:\n");
        sb.append("# ----------------\n");
        for (CommentMarker marker : context.commentMarkers) {
            if (marker.fullLine) {
                sb.append("# Was at begin of line:" + marker.lineNr + " :");
                sb.append(marker.comment);
            } else {
                sb.append("# Was at end of line:" + marker.lineNr + " :");
                sb.append(marker.comment);
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private CommentsRescueContext backupCommentsAndMetaData(String source, SnakeYamlConfig internalConfig) {
        CommentsRescueContext context = new CommentsRescueContext(source);
        int lineNr = 0;
        String[] stringArray = context.originSourceLines;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (++lineNr == 1 && line.equals(START_BLOCK)) {
                internalConfig.multiDocFileStartingWithSeparator = true;
            } else if (line.equals(START_BLOCK)) {
                internalConfig.setExplicitStart(true);
            } else if (line.equals("...")) {
                internalConfig.setExplicitEnd(true);
            }
            ++n2;
        }
        return context;
    }

    private String tryToResolveEndingComment(String line) {
        boolean insideSingleString = false;
        boolean insideDoubleString = false;
        boolean insideTickString = false;
        char[] chars = line.toCharArray();
        int index = 0;
        while (index < chars.length) {
            char c = chars[index];
            if (c == '\'') {
                insideSingleString = !insideSingleString;
            } else if (c == '\"') {
                insideSingleString = !insideSingleString;
            } else if (c == '`') {
                insideSingleString = !insideSingleString;
            } else if (!(c != '#' || insideDoubleString || insideSingleString || insideTickString)) {
                return line.substring(index);
            }
            ++index;
        }
        return null;
    }

    private String dropFirstBlockIfNotDefinedBefore(String formatted, SnakeYamlConfig config) {
        if (config.multiDocFileStartingWithSeparator) {
            return formatted;
        }
        String[] linesFormatted = formatted.split("\n");
        StringBuilder sb = new StringBuilder();
        int lineNr = 0;
        String[] stringArray = linesFormatted;
        int n = linesFormatted.length;
        int n2 = 0;
        while (n2 < n) {
            String lineFormatted = stringArray[n2];
            if (++lineNr != 1 || !lineFormatted.contentEquals(START_BLOCK)) {
                sb.append(lineFormatted);
                sb.append("\n");
            }
            ++n2;
        }
        return sb.toString();
    }

    private String restoreFullCommentsBySearchForNewLine(String formatted, CommentsRescueContext context, SnakeYamlConfig internalConfig) {
        String[] linesFormatted = formatted.split("\n");
        CommentMarker markerToDrop = null;
        StringBuilder sb = new StringBuilder();
        ArrayList<String> reducedComparableLineParts2 = new ArrayList<String>();
        this.addFirstFullCommentWhenNoFormerLine(context, sb);
        String[] stringArray = linesFormatted;
        int n = linesFormatted.length;
        int n2 = 0;
        while (n2 < n) {
            String lineFormatted = stringArray[n2];
            sb.append(lineFormatted);
            String reducedComparablePart = null;
            if (lineFormatted.startsWith("#")) {
                reducedComparablePart = context.reduceToComparablePart(lineFormatted);
            } else {
                String comment = this.tryToResolveEndingComment(lineFormatted);
                if (comment != null && !comment.isEmpty()) {
                    String justCode = lineFormatted.substring(0, lineFormatted.length() - comment.length());
                    reducedComparablePart = context.reduceToComparablePart(justCode);
                } else {
                    reducedComparablePart = context.reduceToComparablePart(lineFormatted);
                }
            }
            int currentReducedIndex = context.calculateReducedComparableIndex(reducedComparablePart, reducedComparableLineParts2);
            reducedComparableLineParts2.add(reducedComparablePart);
            for (CommentMarker marker : context.commentMarkers) {
                if (!marker.fullLine || !reducedComparablePart.equals(marker.lineBeforeAsReducedPart) || marker.lineBeforeAsReducedIndex != currentReducedIndex) continue;
                sb.append("\n");
                sb.append(marker.comment);
                markerToDrop = marker;
                break;
            }
            if (markerToDrop != null) {
                context.commentMarkers.remove(markerToDrop);
            }
            sb.append("\n");
            ++n2;
        }
        return sb.toString();
    }

    private void addFirstFullCommentWhenNoFormerLine(CommentsRescueContext context, StringBuilder sb) {
        CommentMarker dropFirst = null;
        for (CommentMarker marker : context.commentMarkers) {
            if (!marker.fullLine || marker.lineBeforeAsReducedPart != null) continue;
            sb.append(marker.comment);
            sb.append("\n");
            dropFirst = marker;
            break;
        }
        if (dropFirst != null) {
            context.commentMarkers.remove(dropFirst);
        }
    }

    private String restoreFullCommentsByLineNumbers(String formatted, CommentsRescueContext context, SnakeYamlConfig config) {
        String[] linesFormatted = formatted.split("\n");
        StringBuilder sb = new StringBuilder();
        int lineNr = 0;
        String[] stringArray = linesFormatted;
        int n = linesFormatted.length;
        int n2 = 0;
        while (n2 < n) {
            String lineFormatted = stringArray[n2];
            ++lineNr;
            while (this.restoreFullCommentsByLineNumber(context, lineNr, sb)) {
                ++lineNr;
            }
            sb.append(lineFormatted);
            sb.append("\n");
            ++n2;
        }
        return sb.toString();
    }

    private String restoreEndingCommentsBySearchForNewLine(String formatted, CommentsRescueContext context, SnakeYamlConfig internalConfig) {
        String[] linesFormatted = formatted.split("\n");
        CommentMarker markerToDrop = null;
        StringBuilder sb = new StringBuilder();
        ArrayList<String> reducedComparableLineParts2 = new ArrayList<String>();
        String[] stringArray = linesFormatted;
        int n = linesFormatted.length;
        int n2 = 0;
        while (n2 < n) {
            String lineFormatted = stringArray[n2];
            sb.append(lineFormatted);
            String reducedComparablePart = context.reduceToComparablePart(lineFormatted);
            int currentReducedIndex = context.calculateReducedComparableIndex(reducedComparablePart, reducedComparableLineParts2);
            reducedComparableLineParts2.add(reducedComparablePart);
            for (CommentMarker marker : context.commentMarkers) {
                if (marker.fullLine || !reducedComparablePart.equals(marker.reducedComparablePart) || marker.reducedComparableIndex != currentReducedIndex) continue;
                sb.append(" ");
                sb.append(marker.comment);
                markerToDrop = marker;
                break;
            }
            if (markerToDrop != null) {
                context.commentMarkers.remove(markerToDrop);
            }
            sb.append("\n");
            ++n2;
        }
        return sb.toString();
    }

    private String restoreEndingCommentsByLineNumbers(String formatted, CommentsRescueContext context, SnakeYamlConfig internalConfig) {
        String[] linesFormatted = formatted.split("\n");
        StringBuilder sb = new StringBuilder();
        int lineNr = 0;
        String[] stringArray = linesFormatted;
        int n = linesFormatted.length;
        int n2 = 0;
        while (n2 < n) {
            String lineFormatted = stringArray[n2];
            sb.append(lineFormatted);
            this.restoreEndingCommentsByLineNumber(context, ++lineNr, sb);
            sb.append("\n");
            ++n2;
        }
        return sb.toString();
    }

    private void restoreEndingCommentsByLineNumber(CommentsRescueContext context, int lineNr, StringBuilder sb) {
        CommentMarker markerToDrop = null;
        for (CommentMarker marker : context.commentMarkers) {
            if (marker.fullLine || marker.lineNr != lineNr) continue;
            sb.append(" ");
            sb.append(marker.comment);
            markerToDrop = marker;
            break;
        }
        if (markerToDrop != null) {
            context.commentMarkers.remove(markerToDrop);
        }
    }

    private boolean restoreFullCommentsByLineNumber(CommentsRescueContext context, int lineNr, StringBuilder sb) {
        boolean lineAdded = false;
        CommentMarker markerToDrop = null;
        for (CommentMarker marker : context.commentMarkers) {
            if (marker.lineNr != lineNr || !marker.fullLine) continue;
            sb.append(marker.comment);
            sb.append("\n");
            lineAdded = true;
            markerToDrop = marker;
            break;
        }
        if (markerToDrop != null) {
            context.commentMarkers.remove(markerToDrop);
        }
        return lineAdded;
    }

    private String formatDocuments(Iterable<Object> documents, SnakeYamlConfig config) {
        DumperOptions options = new DumperOptions();
        options.setExplicitStart(config.isExplicitStart());
        options.setExplicitEnd(config.isExplicitEnd());
        options.setIndent(config.getIndent());
        options.setWidth(config.getLineLength());
        options.setDefaultFlowStyle(config.getFlowStyle());
        options.setPrettyFlow(config.isPrettyFlow());
        options.setDefaultScalarStyle(config.getScalarStyle());
        Yaml yaml = this.createYaml(options, config);
        StringBuilder sb = new StringBuilder();
        Iterator<Object> it = documents.iterator();
        while (it.hasNext()) {
            Object document = it.next();
            String formattedDocument = yaml.dump(document).trim();
            sb.append(formattedDocument);
            if (!it.hasNext()) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    private Yaml createYaml(DumperOptions options, SnakeYamlConfig config) {
        Resolver resolver = null;
        resolver = config != null && config.isPreventingTypeConversionOnFormat() ? new TypeConversionPreventionSnakeYamlResolver() : new Resolver();
        return new Yaml((BaseConstructor)new Constructor(), new Representer(), options, new LoaderOptions(), resolver);
    }

    private class CommentMarker {
        public int lineBeforeAsReducedIndex;
        public String lineBeforeAsReducedPart;
        public int reducedComparableIndex;
        public String originLine;
        public String reducedComparablePart;
        public boolean fullLine;
        public String comment;
        public int lineNr;

        private CommentMarker() {
        }
    }

    private class CommentsRescueContext {
        private String[] originSourceLines;
        private List<String> reducedComparableLineParts = new ArrayList<String>();
        private List<CommentMarker> commentMarkers = new ArrayList<CommentMarker>();
        private String lastLineInspectedNotEmpty;

        public CommentsRescueContext(String originSource) {
            this.originSourceLines = originSource.split("\n");
            int lineNr = 0;
            String[] stringArray = this.originSourceLines;
            int n = this.originSourceLines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                ++lineNr;
                String lineTrimmed = line.trim();
                if (lineTrimmed.startsWith("#")) {
                    this.backupLineComment(lineNr, line);
                } else {
                    String comment = YamlSourceFormatter.this.tryToResolveEndingComment(line);
                    if (comment != null && !comment.isEmpty()) {
                        this.backupEndComment(lineNr, line, comment);
                    } else {
                        this.backupLineWithoutComment(line);
                    }
                }
                if (!lineTrimmed.isEmpty()) {
                    this.lastLineInspectedNotEmpty = line;
                }
                ++n2;
            }
        }

        private void backupLineWithoutComment(String line) {
            this.reducedComparableLineParts.add(this.reduceToComparablePart(line));
        }

        private void backupLineComment(int lineNr, String line) {
            CommentMarker marker = new CommentMarker();
            marker.originLine = line;
            marker.fullLine = true;
            marker.comment = line.trim();
            marker.lineNr = lineNr;
            if (this.lastLineInspectedNotEmpty != null) {
                marker.lineBeforeAsReducedPart = this.reduceToComparablePart(this.lastLineInspectedNotEmpty);
                marker.lineBeforeAsReducedIndex = this.calculateCurrentReducedComparableIndex(this.lastLineInspectedNotEmpty);
            }
            this.commentMarkers.add(marker);
            this.reducedComparableLineParts.add(this.reduceToComparablePart(marker.comment));
        }

        private void backupEndComment(int lineNr, String line, String comment) {
            CommentMarker marker = new CommentMarker();
            marker.originLine = line;
            marker.fullLine = false;
            marker.comment = comment;
            marker.lineNr = lineNr;
            marker.reducedComparablePart = this.reduceToComparablePart(marker);
            marker.reducedComparableIndex = this.calculateCurrentReducedComparableIndex(marker.reducedComparablePart);
            this.reducedComparableLineParts.add(marker.reducedComparablePart);
            this.commentMarkers.add(marker);
        }

        private int calculateCurrentReducedComparableIndex(String reducedPart) {
            return this.calculateReducedComparableIndex(reducedPart, this.reducedComparableLineParts);
        }

        private int calculateReducedComparableIndex(String reducedPart, List<String> reducedComparableLineParts2) {
            int index = 0;
            for (String reduced : reducedComparableLineParts2) {
                if (!reducedPart.equals(reduced)) continue;
                ++index;
            }
            return index;
        }

        private String reduceToComparablePart(CommentMarker marker) {
            String line = marker.originLine;
            int endIndex = line.indexOf(marker.comment);
            String justCode = line.substring(0, endIndex).trim();
            return this.reduceToComparablePart(justCode);
        }

        private String reduceToComparablePart(String justCode) {
            String result = justCode.replaceAll(" ", "");
            result = result.replaceAll("\"", "");
            result = result.replaceAll("'", "");
            return result;
        }
    }
}

