/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.yamleditor.script.formatter;

import de.jcup.yamleditor.script.formatter.YamlEdtiorFormatterScalarStyle;
import de.jcup.yamleditor.script.formatter.YamlSourceFormatterConfig;
import org.yaml.snakeyaml.DumperOptions;

public class SnakeYamlConfig {
    public static final int SNAKE_MAX_LINELENGTH = 400;
    public static final int SNAKE_MAX_INDENT = 10;
    private boolean explicitStart = false;
    private boolean explicitEnd = false;
    private int indent = 2;
    private int lineLength = 120;
    private DumperOptions.FlowStyle flowStyle = DumperOptions.FlowStyle.BLOCK;
    private boolean prettyFlow = false;
    private DumperOptions.ScalarStyle scalarStyle = DumperOptions.ScalarStyle.PLAIN;
    boolean multiDocFileStartingWithSeparator = false;
    private boolean preventTypeConversionOnFormat;

    public SnakeYamlConfig() {
    }

    public SnakeYamlConfig(YamlSourceFormatterConfig toCopy) {
        YamlEdtiorFormatterScalarStyle yamlEdtiorFormatterScalarStyle;
        if (toCopy == null) {
            return;
        }
        this.indent = toCopy.getIndent();
        this.preventTypeConversionOnFormat = toCopy.isPreventingTypeConversion();
        if (this.indent > 10) {
            this.indent = 10;
        }
        this.lineLength = toCopy.getMaxLineLength();
        if (this.lineLength > 400) {
            this.lineLength = 400;
        }
        if ((yamlEdtiorFormatterScalarStyle = toCopy.getScalarStyle()) == null) {
            return;
        }
        switch (yamlEdtiorFormatterScalarStyle) {
            case DOUBLE_QUOTED: {
                this.scalarStyle = DumperOptions.ScalarStyle.DOUBLE_QUOTED;
                this.flowStyle = DumperOptions.FlowStyle.BLOCK;
                break;
            }
            case SINGLE_QUOTED: {
                this.scalarStyle = DumperOptions.ScalarStyle.SINGLE_QUOTED;
                this.flowStyle = DumperOptions.FlowStyle.BLOCK;
                break;
            }
            default: {
                this.scalarStyle = DumperOptions.ScalarStyle.PLAIN;
                this.flowStyle = DumperOptions.FlowStyle.BLOCK;
            }
        }
    }

    public int getIndent() {
        return this.indent;
    }

    public int getLineLength() {
        return this.lineLength;
    }

    public boolean isExplicitEnd() {
        return this.explicitEnd;
    }

    public boolean isExplicitStart() {
        return this.explicitStart;
    }

    public boolean isPrettyFlow() {
        return this.prettyFlow;
    }

    public DumperOptions.FlowStyle getFlowStyle() {
        return this.flowStyle;
    }

    public DumperOptions.ScalarStyle getScalarStyle() {
        return this.scalarStyle;
    }

    public void setExplicitStart(boolean explicitStart) {
        this.explicitStart = explicitStart;
    }

    public void setExplicitEnd(boolean explicitEnd) {
        this.explicitEnd = explicitEnd;
    }

    public void setIndent(int indent) {
        this.indent = indent;
    }

    public void setFlowStyle(DumperOptions.FlowStyle flowStyle) {
        this.flowStyle = flowStyle;
    }

    public void setPrettyFlow(boolean prettyFlow) {
        this.prettyFlow = prettyFlow;
    }

    public void setScalarStyle(DumperOptions.ScalarStyle scalarStyle) {
        this.scalarStyle = scalarStyle;
    }

    public boolean isPreventingTypeConversionOnFormat() {
        return this.preventTypeConversionOnFormat;
    }
}

