/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.yamleditor.script;

import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.TreeMap;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class YamlScriptSortMemberSupport {
    private Yaml yamlParser;

    public YamlScriptSortMemberSupport() {
        DumperOptions options = new DumperOptions();
        options.setDefaultScalarStyle(DumperOptions.ScalarStyle.PLAIN);
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setSplitLines(true);
        this.yamlParser = new Yaml(options);
    }

    public String sortAscending(String input) {
        if (input == null) {
            return "";
        }
        String[] documents = input.split("---");
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < documents.length) {
            String document = documents[i];
            String sortedDocument = this.sortAscendingSingleDocument(document);
            sb.append(sortedDocument);
            if (i < documents.length - 1) {
                sb.append("---\n");
            }
            ++i;
        }
        return sb.toString();
    }

    public String sortAscendingSingleDocument(String input) {
        Map map = (Map)this.yamlParser.loadAs(input, Map.class);
        if (map == null) {
            return "";
        }
        StringWriter writer = new StringWriter();
        this.yamlParser.dump(this.sort(map), (Writer)writer);
        return writer.toString();
    }

    private Map<String, Object> sort(Map<String, Object> map) {
        TreeMap<String, Object> map2 = new TreeMap<String, Object>(map);
        LinkedHashSet<String> list = new LinkedHashSet<String>(map2.keySet());
        for (String key : list) {
            Object data = map.get(key);
            if (!(data instanceof Map)) continue;
            Map<String, Object> data2 = this.sort((Map)data);
            map2.put(key, data2);
        }
        return map2;
    }

    public boolean isHavingCommentsInside(String yamlContent) {
        if (yamlContent == null) {
            return false;
        }
        int begin = 0;
        int index = this.getIndex(yamlContent, begin);
        if (index == -1) {
            return false;
        }
        char[] chars = yamlContent.toCharArray();
        while (index != -1) {
            if (!this.isLineInsideString(index, chars)) {
                return true;
            }
            begin = index + 1;
            index = this.getIndex(yamlContent, begin);
        }
        return false;
    }

    private boolean isLineInsideString(int index, char[] yamlContent) {
        int posBefore = index - 1;
        int singleQuotes = 0;
        int doubleQuotes = 0;
        while (posBefore > 0) {
            char c = yamlContent[posBefore];
            if (c == '\n') break;
            if (c == '\'') {
                ++singleQuotes;
            }
            if (c == '\"') {
                ++doubleQuotes;
            }
            --posBefore;
        }
        int moduloSingle = singleQuotes % 2;
        int moduloDouble = doubleQuotes % 2;
        return moduloDouble != 0 || moduloSingle != 0;
    }

    private int getIndex(String yamlContent, int begin) {
        if (yamlContent == null) {
            return -1;
        }
        if (begin >= yamlContent.length()) {
            return -1;
        }
        return yamlContent.indexOf("#", begin);
    }
}

