/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.yamleditor.script;

import de.jcup.yamleditor.script.IndentionBlock;
import de.jcup.yamleditor.script.IndentionBlockBuilder;
import de.jcup.yamleditor.script.YamlError;
import de.jcup.yamleditor.script.YamlNode;
import de.jcup.yamleditor.script.YamlSanitizer;
import de.jcup.yamleditor.script.YamlSanitizerContext;
import de.jcup.yamleditor.script.YamlScriptModel;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.error.Mark;
import org.yaml.snakeyaml.error.MarkedYAMLException;
import org.yaml.snakeyaml.nodes.AnchorNode;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;

public class YamlScriptModelBuilder {
    private static final String UNDEFINED_NAME = "<undefName>";
    private static final YamlSanitizer[] NO_SANITIZING = new YamlSanitizer[0];
    private static boolean DEBUG = Boolean.getBoolean("de.jcup.yamleditor.model.debug");
    private Yaml yamlParser;
    private boolean calculateFoldings;
    private YamlSanitizer[] sanitizers = NO_SANITIZING;
    private Map<Node, String> nodeNameCacheMap;

    public YamlScriptModelBuilder() {
        this.yamlParser = new Yaml();
    }

    public YamlScriptModelBuilder setSanitizers(YamlSanitizer ... sanitizers) {
        this.sanitizers = sanitizers == null ? NO_SANITIZING : sanitizers;
        return this;
    }

    public YamlScriptModelBuilder setCalculateFoldings(boolean calculateFoldings) {
        this.calculateFoldings = calculateFoldings;
        return this;
    }

    public YamlScriptModel build(String unsafeSourceCode) {
        this.nodeNameCacheMap = new HashMap<Node, String>();
        YamlScriptModel model = new YamlScriptModel();
        try {
            YamlSanitizerContext context = new YamlSanitizerContext();
            String escapedSource = unsafeSourceCode;
            YamlSanitizer[] yamlSanitizerArray = this.sanitizers;
            int n = this.sanitizers.length;
            int n2 = 0;
            while (n2 < n) {
                YamlSanitizer yamlSanitizer = yamlSanitizerArray[n2];
                escapedSource = yamlSanitizer.sanitize(escapedSource, context);
                ++n2;
            }
            model.getMessages().addAll(context.getSanitizerMessages());
            StringReader reader = new StringReader(escapedSource);
            YamlNode root = model.getRootNode();
            Iterable nodes = this.yamlParser.composeAll((Reader)reader);
            for (Node node : nodes) {
                this.buildNode(model, root, node);
            }
            if (this.calculateFoldings) {
                IndentionBlockBuilder builder = new IndentionBlockBuilder();
                List<IndentionBlock> blocks = builder.build(escapedSource);
                this.transformIndentionsToFoldings(model, blocks);
            }
        }
        catch (MarkedYAMLException e) {
            String message = e.getMessage();
            Mark problem = e.getProblemMark();
            int start = problem.getIndex();
            int end = start + 1;
            YamlError error = new YamlError(start, end, message);
            model.errors.add(error);
        }
        this.nodeNameCacheMap.clear();
        return model;
    }

    private void transformIndentionsToFoldings(YamlScriptModel model, List<IndentionBlock> blocks) {
        for (IndentionBlock block : blocks) {
            model.addFolding(new YamlScriptModel.FoldingPosition(block.getStart(), block.getLength()));
        }
    }

    private void buildNode(YamlScriptModel model, YamlNode parent, Node node) {
        String found = this.nodeNameCacheMap.get(node);
        if (found != null) {
            YamlNode yamlNode = new YamlNode("<alias to existing anchor>" + this.resolveName(node));
            yamlNode.pos = parent.getPosition();
            yamlNode.end = parent.getEnd();
            parent.getChildren().add(yamlNode);
            return;
        }
        this.nodeNameCacheMap.put(node, UNDEFINED_NAME);
        if (node instanceof MappingNode) {
            this.appendMappings(model, parent, (MappingNode)node);
            return;
        }
        if (node instanceof SequenceNode) {
            this.appendSequence(model, parent, (SequenceNode)node);
        } else if (node instanceof ScalarNode) {
            this.appendScalar(model, parent, (ScalarNode)node);
        }
    }

    private void appendScalar(YamlScriptModel model, YamlNode parent, ScalarNode node) {
        YamlNode yamlNode = new YamlNode(this.resolveName((Node)node));
        this.prepare(yamlNode, (Node)node);
        parent.getChildren().add(yamlNode);
    }

    protected String resolveName(Node node) {
        return this.resolveName(node, -1);
    }

    protected String resolveName(Node node, int count) {
        String name = this.nodeNameCacheMap.get(node);
        if (name == null || UNDEFINED_NAME.equals(name)) {
            name = this.internalResolveName(node, count);
        }
        if (DEBUG) {
            name = String.valueOf(node.getClass().getSimpleName()) + ":" + name;
        }
        this.nodeNameCacheMap.put(node, name);
        return name;
    }

    private String internalResolveName(Node node, int count) {
        if (node instanceof AnchorNode) {
            AnchorNode an = (AnchorNode)node;
            return this.internalResolveName(an.getRealNode(), count);
        }
        if (node instanceof ScalarNode) {
            return ((ScalarNode)node).getValue();
        }
        if (node instanceof SequenceNode) {
            if (count > -1) {
                return count + ",";
            }
            return "<sequence>";
        }
        if (node instanceof MappingNode) {
            if (count > -1) {
                return "[" + count + "]";
            }
            return "<mapping>";
        }
        return node.getType().getName();
    }

    private void appendSequence(YamlScriptModel model, YamlNode parent, SequenceNode node) {
        int count = 0;
        List values = node.getValue();
        int valueCount = values.size();
        for (Node element : node.getValue()) {
            this.createYamlNodeAndAddToParent(model, parent, element, count++, valueCount);
        }
    }

    private void appendMappings(YamlScriptModel model, YamlNode parent, MappingNode node) {
        int count = 0;
        List values = node.getValue();
        int valueCount = values.size();
        for (NodeTuple nodeTuple : values) {
            Node keyNode = nodeTuple.getKeyNode();
            YamlNode yamlkeyNode = this.createYamlNodeAndAddToParent(model, parent, keyNode, count++, valueCount);
            Node valNode = nodeTuple.getValueNode();
            this.createYamlNodeAndAddToParent(model, yamlkeyNode, valNode, -1, -1);
        }
    }

    protected YamlNode createYamlNodeAndAddToParent(YamlScriptModel model, YamlNode parent, Node node, int count, int maxCount) {
        YamlNode yamlNodeToAppendNext = parent;
        if (this.isShown(node, maxCount)) {
            yamlNodeToAppendNext = this.buildShownNode(model, parent, node, count);
        } else {
            this.buildNode(model, parent, node);
        }
        return yamlNodeToAppendNext;
    }

    private YamlNode buildShownNode(YamlScriptModel model, YamlNode parent, Node node, int count) {
        YamlNode yamlNodeToAppendNext = null;
        if (node instanceof ScalarNode) {
            String keyName = this.resolveName(node);
            YamlNode yamlNode = new YamlNode(keyName);
            this.prepare(yamlNode, node);
            parent.getChildren().add(yamlNode);
            yamlNodeToAppendNext = yamlNode;
        } else if (node instanceof MappingNode) {
            MappingNode mp = (MappingNode)node;
            String keyName = this.resolveName(node, count);
            YamlNode yamlNode = new YamlNode(keyName);
            this.prepare(yamlNode, node);
            parent.getChildren().add(yamlNode);
            this.appendMappings(model, yamlNode, mp);
            yamlNodeToAppendNext = yamlNode;
        } else {
            yamlNodeToAppendNext = new YamlNode("<failure>");
        }
        return yamlNodeToAppendNext;
    }

    private boolean isShown(Node node, int maxCount) {
        if (node instanceof AnchorNode) {
            return true;
        }
        if (node instanceof ScalarNode) {
            return true;
        }
        if (node instanceof MappingNode) {
            return maxCount > 1;
        }
        return false;
    }

    void prepare(YamlNode yamlNode, Node node) {
        Mark start = node.getStartMark();
        yamlNode.pos = start.getIndex();
        yamlNode.end = yamlNode.pos + yamlNode.getName().length();
        yamlNode.snakeNode = node;
    }
}

