/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.yamleditor.script;

import de.jcup.yamleditor.YamlEditorDebugSettings;
import de.jcup.yamleditor.script.YamlError;
import de.jcup.yamleditor.script.YamlNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

public class YamlScriptModel {
    Collection<YamlError> errors = new ArrayList<YamlError>();
    private YamlNode rootNode;
    private SortedSet<FoldingPosition> foldingPositions = new TreeSet<FoldingPosition>();
    private List<String> messages = new ArrayList<String>();

    public YamlScriptModel() {
        this.rootNode = new YamlNode("root");
    }

    public YamlNode getRootNode() {
        return this.rootNode;
    }

    public boolean hasErrors() {
        return this.errors.size() > 0;
    }

    public Collection<YamlError> getErrors() {
        return this.errors;
    }

    public List<String> getMessages() {
        return this.messages;
    }

    public SortedSet<FoldingPosition> getFoldingPositions() {
        return this.foldingPositions;
    }

    public void addFolding(FoldingPosition folding) {
        this.foldingPositions.add(folding);
        if (YamlEditorDebugSettings.DEBUG_OUTPUT_ENABLED) {
            int offset = folding.offset;
            int end = offset + folding.length;
            YamlNode foldingNodeInfo = new YamlNode(String.valueOf(offset) + "," + end + "=" + folding.toString());
            foldingNodeInfo.pos = offset;
            foldingNodeInfo.end = end;
            foldingNodeInfo.debug = true;
            this.getRootNode().getChildren().add(foldingNodeInfo);
        }
    }

    public static class FoldingPosition
    implements Comparable<FoldingPosition> {
        private int offset;
        private int length;

        public FoldingPosition(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        public int getLength() {
            return this.length;
        }

        public int getOffset() {
            return this.offset;
        }

        @Override
        public int compareTo(FoldingPosition o) {
            return this.offset - o.offset;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.offset;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FoldingPosition other = (FoldingPosition)obj;
            return this.offset == other.offset;
        }

        public String toString() {
            return "FoldingPosition [offset=" + this.offset + ", length=" + this.length + "]";
        }
    }
}

