/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.yamleditor.script;

import de.jcup.yamleditor.script.IndentionBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class IndentionBlockBuilder {
    private static final Pattern LINE_SPLIT_PATTERN = Pattern.compile("\\\n");

    public List<IndentionBlock> build(String text) {
        String[] lines = LINE_SPLIT_PATTERN.split(text, -1);
        IndentContext context = new IndentContext(lines);
        int i = 0;
        while (i < lines.length) {
            context.calculateIndentBlockForLineIfNecessary(i);
            ++i;
        }
        return context.list;
    }

    int calculateIndention(String line) {
        char[] chars = line.toCharArray();
        int indention = 0;
        int i = 0;
        while (i < chars.length) {
            if (chars[i] != ' ') break;
            ++indention;
            ++i;
        }
        return indention;
    }

    private class IndentContext {
        List<IndentionBlock> list = new ArrayList<IndentionBlock>();
        private String[] lines;

        public IndentContext(String[] lines) {
            this.lines = lines;
        }

        public void calculateIndentBlockForLineIfNecessary(int index) {
            boolean containsChildren;
            String line = this.getLine(index);
            int indent = IndentionBlockBuilder.this.calculateIndention(line);
            int startIndex = this.calculateStartIndex(index);
            IndentionBlock current = new IndentionBlock(indent, startIndex);
            int childLines = 0;
            int lastChild = 0;
            int i = index + 1;
            while (i < this.lines.length) {
                String line2 = this.getLine(i);
                if (!line2.isEmpty()) {
                    int indent2 = IndentionBlockBuilder.this.calculateIndention(line2);
                    if (indent2 <= indent) break;
                    ++childLines;
                    lastChild = i;
                }
                ++i;
            }
            boolean bl = containsChildren = lastChild > 0 && childLines > 2;
            if (containsChildren) {
                String lastLine = this.getLine(lastChild);
                int startPosLastChild = this.calculateStartIndex(lastChild);
                current.end = startPosLastChild + lastLine.length();
                if (lastChild < this.lines.length - 1) {
                    ++current.end;
                }
                this.list.add(current);
            }
        }

        protected String getLine(int index) {
            if (this.lines == null) {
                return "";
            }
            if (this.lines.length <= index) {
                return "";
            }
            return this.lines[index];
        }

        public int calculateStartIndex(int index) {
            int pos = 0;
            int i = 0;
            while (i < index && i < this.lines.length) {
                String text = this.getLine(i);
                pos += text.length();
                ++pos;
                ++i;
            }
            return pos;
        }
    }
}

