/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.yamleditor.script;

import de.jcup.yamleditor.script.YamlSanitizer;
import de.jcup.yamleditor.script.YamlSanitizerContext;
import java.util.Arrays;
import java.util.Iterator;
import java.util.regex.Pattern;

public class GoTemplateSanitizer
implements YamlSanitizer {
    private static final String SANITIZER_MESSAGE = "Found Go template parts and sanitized them to have valid yaml: Replaced mapping parts internally by ((..._...)) and template only parts as comments to have valid yaml for parsing and ensure AST for outline.\nAlso syntax highlighting for Go templates was enabled.\n\nIf you do not like this, please disable 'Go Template Support' inside Yaml Editor preferences.";
    private static final String GO_TEMPLATE_START = "{{";
    private static final String GO_TEMPLATE_END = "}}";
    public static final Pattern PATTERN_CURLYBRACES_OPEN = Pattern.compile(Pattern.quote("{{"));
    public static final Pattern PATTERN_CURLYBRACES_CLOSE = Pattern.compile(Pattern.quote("}}"));
    public static final Pattern PATTERN_TO_REDUCED_INSIDE = Pattern.compile("[" + Pattern.quote("\"':-[]!#|>&%@]") + "]");

    @Override
    public String sanitize(String source, YamlSanitizerContext context) {
        int index = source.indexOf(GO_TEMPLATE_START);
        if (index == -1) {
            return source;
        }
        String sourceNoLeading = this.sanitizeGoTemplatesWithoutContentBefore(source);
        String sourceResult = this.sanitizeGoTemplatesAfterCharacters(context, sourceNoLeading);
        return sourceResult;
    }

    private String sanitizeGoTemplatesAfterCharacters(YamlSanitizerContext context, String sourceNoLeading) {
        int index = sourceNoLeading.indexOf(GO_TEMPLATE_START);
        StringBuilder sb = new StringBuilder(sourceNoLeading);
        while (index != -1) {
            int end = sb.indexOf(GO_TEMPLATE_END, index);
            if (end == -1) break;
            String part = sb.substring(index, end + 2);
            part = PATTERN_CURLYBRACES_OPEN.matcher(part).replaceAll("((");
            part = PATTERN_CURLYBRACES_CLOSE.matcher(part).replaceAll("))");
            part = PATTERN_TO_REDUCED_INSIDE.matcher(part).replaceAll("_");
            sb.replace(index, end + GO_TEMPLATE_END.length(), part);
            index = sb.indexOf(GO_TEMPLATE_START);
        }
        context.addSanitizerMessage(SANITIZER_MESSAGE);
        String sourceResult = sb.toString();
        return sourceResult;
    }

    private String sanitizeGoTemplatesWithoutContentBefore(String source) {
        String[] lines = source.split("\n");
        StringBuilder sb0 = new StringBuilder();
        Iterator<String> lit = Arrays.asList(lines).iterator();
        while (lit.hasNext()) {
            String next = lit.next();
            if (next.trim().startsWith(GO_TEMPLATE_START)) {
                sb0.append("#");
            }
            sb0.append(next);
            if (!lit.hasNext()) continue;
            sb0.append("\n");
        }
        String sourceNoLeading = sb0.toString();
        return sourceNoLeading;
    }
}

