/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.yamleditor.preferences;

import de.jcup.eclipse.commons.ui.ColorUtil;
import de.jcup.yamleditor.EclipseUtil;
import de.jcup.yamleditor.YamlEditor;
import de.jcup.yamleditor.preferences.PreferenceIdentifiable;
import de.jcup.yamleditor.preferences.YamlEditorPreferenceConstants;
import de.jcup.yamleditor.preferences.YamlEditorSyntaxColorPreferenceConstants;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class YamlEditorPreferences {
    private static YamlEditorPreferences INSTANCE = new YamlEditorPreferences();
    private IPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, "de.jcup.yamleditor");

    private YamlEditorPreferences() {
        this.store.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event == null) {
                    return;
                }
                String property = event.getProperty();
                if (property == null) {
                    return;
                }
                ChangeContext context = new ChangeContext();
                YamlEditorSyntaxColorPreferenceConstants[] yamlEditorSyntaxColorPreferenceConstantsArray = YamlEditorSyntaxColorPreferenceConstants.values();
                int n = yamlEditorSyntaxColorPreferenceConstantsArray.length;
                int n2 = 0;
                while (n2 < n) {
                    YamlEditorSyntaxColorPreferenceConstants c = yamlEditorSyntaxColorPreferenceConstantsArray[n2];
                    if (property.equals(c.getId())) {
                        context.colorChanged = true;
                        break;
                    }
                    ++n2;
                }
                this.updateColorsInYamlEditors(context);
            }

            private void updateColorsInYamlEditors(ChangeContext context) {
                IEditorReference[] references;
                if (!context.hasChanges()) {
                    return;
                }
                IWorkbenchPage activePage = EclipseUtil.getActivePage();
                if (activePage == null) {
                    return;
                }
                IEditorReference[] iEditorReferenceArray = references = activePage.getEditorReferences();
                int n = references.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorReference ref = iEditorReferenceArray[n2];
                    IEditorPart editor = ref.getEditor(false);
                    if (editor != null && editor instanceof YamlEditor) {
                        YamlEditor geditor = (YamlEditor)editor;
                        if (context.colorChanged) {
                            geditor.handleColorSettingsChanged();
                        }
                        if (context.validationChanged) {
                            geditor.rebuildOutline();
                        }
                    }
                    ++n2;
                }
            }
        });
    }

    public String getStringPreference(YamlEditorPreferenceConstants id) {
        String data = this.getPreferenceStore().getString(id.getId());
        if (data == null) {
            data = "";
        }
        return data;
    }

    public boolean getBooleanPreference(YamlEditorPreferenceConstants id) {
        boolean data = this.getPreferenceStore().getBoolean(id.getId());
        return data;
    }

    public void setBooleanPreference(YamlEditorPreferenceConstants id, boolean value) {
        this.getPreferenceStore().setValue(id.getId(), value);
    }

    public boolean isLinkOutlineWithEditorEnabled() {
        return this.getBooleanPreference(YamlEditorPreferenceConstants.P_LINK_OUTLINE_WITH_EDITOR);
    }

    public IPreferenceStore getPreferenceStore() {
        return this.store;
    }

    public boolean getDefaultBooleanPreference(YamlEditorPreferenceConstants id) {
        boolean data = this.getPreferenceStore().getDefaultBoolean(id.getId());
        return data;
    }

    public RGB getColor(PreferenceIdentifiable identifiable) {
        RGB color = PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)identifiable.getId());
        return color;
    }

    public String getWebColor(PreferenceIdentifiable identifiable) {
        RGB color = this.getColor(identifiable);
        if (color == null) {
            return null;
        }
        String webColor = ColorUtil.convertToHexColor((RGB)color);
        return webColor;
    }

    public boolean isCodeFoldingEnabledOnEditorStartup() {
        return this.getBooleanPreference(YamlEditorPreferenceConstants.P_OPEN_NEW_EDITORS_WITH_CODE_FOLDING_ENABLED);
    }

    public void setDefaultColor(PreferenceIdentifiable identifiable, RGB color) {
        PreferenceConverter.setDefault((IPreferenceStore)this.getPreferenceStore(), (String)identifiable.getId(), (RGB)color);
    }

    public static YamlEditorPreferences getInstance() {
        return INSTANCE;
    }

    public int getAmountOfSpacesToReplaceTab() {
        return this.getPreferenceStore().getInt(YamlEditorPreferenceConstants.P_SOURCE_FORMAT_INDENT.getId());
    }

    public int getSourceFormatterLineLength() {
        return this.getPreferenceStore().getInt(YamlEditorPreferenceConstants.P_SOURCE_FORMAT_LINE_LENGTH.getId());
    }

    public int getSourceFormatterIndent() {
        return this.getPreferenceStore().getInt(YamlEditorPreferenceConstants.P_SOURCE_FORMAT_INDENT.getId());
    }

    public String getSourceFormatterScalarStyleId() {
        return this.getPreferenceStore().getString(YamlEditorPreferenceConstants.P_SOURCE_SCALAR_STYLE_ID.getId());
    }

    public boolean isSourceFormatterRescuingComments() {
        return this.getPreferenceStore().getBoolean(YamlEditorPreferenceConstants.P_SOURCE_FORMAT_RESCUE_COMMENTS_ENABLED.getId());
    }

    public boolean isGoTemplateSupportEnabled() {
        return this.getPreferenceStore().getBoolean(YamlEditorPreferenceConstants.P_GO_TEMPLATE_SUPPORT_ENABLED.getId());
    }

    public boolean isPreventingTypeConversionOnFormat() {
        return this.getPreferenceStore().getBoolean(YamlEditorPreferenceConstants.P_PREVENT_TYPE_CONVERSION_ON_FORMAT_ENABLED.getId());
    }

    private class ChangeContext {
        private boolean colorChanged = false;
        private boolean validationChanged = false;

        private ChangeContext() {
        }

        private boolean hasChanges() {
            boolean changedAtAll = this.colorChanged;
            changedAtAll = changedAtAll || this.validationChanged;
            return changedAtAll;
        }
    }
}

