/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.yamleditor.preferences;

import de.jcup.yamleditor.YamlEditorUtil;
import de.jcup.yamleditor.preferences.YamlEditorPreferenceConstants;
import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class YamlEditorPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    protected static final int INDENT = 20;
    private Button bracketHighlightingCheckbox;
    private Button enclosingBracketsRadioButton;
    private Button matchingBracketAndCaretLocationRadioButton;
    private Button matchingBracketRadioButton;
    private ColorFieldEditor matchingBracketsColor;
    private BooleanFieldEditor linkEditorWithOutline;
    private ArrayList<MasterButtonSlaveSelectionListener> masterSlaveListeners = new ArrayList();
    private boolean enclosingBrackets;
    private boolean highlightBracketAtCaretLocation;
    private boolean matchingBrackets;
    private BooleanFieldEditor autoCreateEndBrackets;
    private BooleanFieldEditor codeAssistWithYamlKeywords;
    private BooleanFieldEditor codeAssistWithSimpleWords;
    private ColorFieldEditor marginRuleColor;
    private BooleanFieldEditor codeFoldingEnabledOnNewEditors;

    protected static void indent(Control control) {
        ((GridData)control.getLayoutData()).horizontalIndent += 20;
    }

    public YamlEditorPreferencePage() {
        super(1);
        this.setPreferenceStore(YamlEditorUtil.getPreferences().getPreferenceStore());
    }

    public void init(IWorkbench workbench) {
    }

    public void performDefaults() {
        super.performDefaults();
        this.reloadBracketHighlightingPreferenceDefaults();
    }

    public boolean performOk() {
        boolean ok = super.performOk();
        if (ok) {
            this.setBoolean(YamlEditorPreferenceConstants.P_EDITOR_MATCHING_BRACKETS_ENABLED, this.matchingBrackets);
            this.setBoolean(YamlEditorPreferenceConstants.P_EDITOR_HIGHLIGHT_BRACKET_AT_CARET_LOCATION, this.highlightBracketAtCaretLocation);
            this.setBoolean(YamlEditorPreferenceConstants.P_EDITOR_ENCLOSING_BRACKETS, this.enclosingBrackets);
        }
        return ok;
    }

    protected void createDependency(Button master, Control slave) {
        Assert.isNotNull((Object)slave);
        YamlEditorPreferencePage.indent(slave);
        MasterButtonSlaveSelectionListener listener = new MasterButtonSlaveSelectionListener(master, slave);
        master.addSelectionListener((SelectionListener)listener);
        this.masterSlaveListeners.add(listener);
    }

    protected void createFieldEditors() {
        Composite appearanceComposite = new Composite(this.getFieldEditorParent(), 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        appearanceComposite.setLayout((Layout)layout);
        Composite otherComposite = new Composite(appearanceComposite, 0);
        GridLayout otherLayout = new GridLayout();
        otherLayout.marginWidth = 0;
        otherLayout.marginHeight = 0;
        otherComposite.setLayout((Layout)otherLayout);
        this.codeFoldingEnabledOnNewEditors = new BooleanFieldEditor(YamlEditorPreferenceConstants.P_OPEN_NEW_EDITORS_WITH_CODE_FOLDING_ENABLED.getId(), "New opened editors have code folding enabled", otherComposite);
        this.codeFoldingEnabledOnNewEditors.getDescriptionControl(otherComposite).setToolTipText("When enabled code foldings is active per default. Can be changed in ruler context menu for each editor instance");
        this.addField((FieldEditor)this.codeFoldingEnabledOnNewEditors);
        this.linkEditorWithOutline = new BooleanFieldEditor(YamlEditorPreferenceConstants.P_LINK_OUTLINE_WITH_EDITOR.getId(), "New opened editors are linked with outline", otherComposite);
        this.linkEditorWithOutline.getDescriptionControl(otherComposite).setToolTipText("Via this setting the default behaviour for new opened outlines is set");
        this.addField((FieldEditor)this.linkEditorWithOutline);
        this.marginRuleColor = new ColorFieldEditor(YamlEditorPreferenceConstants.P_EDITOR_MARGIN_RULE_LINE_COLOR.getId(), "Margin rule line color", otherComposite);
        this.addField((FieldEditor)this.marginRuleColor);
        Label spacer = new Label(appearanceComposite, 16384);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        gd.heightHint = this.convertHeightInCharsToPixels(1) / 2;
        spacer.setLayoutData((Object)gd);
        GridData bracketsGroupLayoutData = new GridData();
        bracketsGroupLayoutData.horizontalSpan = 2;
        bracketsGroupLayoutData.widthHint = 400;
        Group bracketsGroup = new Group(appearanceComposite, 0);
        bracketsGroup.setText("Brackets");
        bracketsGroup.setLayout((Layout)new GridLayout());
        bracketsGroup.setLayoutData((Object)bracketsGroupLayoutData);
        this.autoCreateEndBrackets = new BooleanFieldEditor(YamlEditorPreferenceConstants.P_EDITOR_AUTO_CREATE_END_BRACKETS.getId(), "Auto create ending brackets", (Composite)bracketsGroup);
        this.addField((FieldEditor)this.autoCreateEndBrackets);
        String label = "Bracket highlighting";
        this.bracketHighlightingCheckbox = this.addButton((Composite)bracketsGroup, 32, label, 0, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                YamlEditorPreferencePage.this.matchingBrackets = YamlEditorPreferencePage.this.bracketHighlightingCheckbox.getSelection();
            }
        });
        Composite radioComposite = new Composite((Composite)bracketsGroup, 0);
        GridLayout radioLayout = new GridLayout();
        radioLayout.marginWidth = 0;
        radioLayout.marginHeight = 0;
        radioComposite.setLayout((Layout)radioLayout);
        label = "highlight matching bracket";
        this.matchingBracketRadioButton = this.addButton(radioComposite, 16, label, 0, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (YamlEditorPreferencePage.this.matchingBracketRadioButton.getSelection()) {
                    YamlEditorPreferencePage.this.highlightBracketAtCaretLocation = false;
                }
            }
        });
        this.createDependency(this.bracketHighlightingCheckbox, (Control)this.matchingBracketRadioButton);
        label = "highlight matching bracket and caret location";
        this.matchingBracketAndCaretLocationRadioButton = this.addButton(radioComposite, 16, label, 0, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (YamlEditorPreferencePage.this.matchingBracketAndCaretLocationRadioButton.getSelection()) {
                    YamlEditorPreferencePage.this.highlightBracketAtCaretLocation = true;
                }
            }
        });
        this.createDependency(this.bracketHighlightingCheckbox, (Control)this.matchingBracketAndCaretLocationRadioButton);
        label = "highlight enclosing brackets";
        this.enclosingBracketsRadioButton = this.addButton(radioComposite, 16, label, 0, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selection = YamlEditorPreferencePage.this.enclosingBracketsRadioButton.getSelection();
                YamlEditorPreferencePage.this.enclosingBrackets = selection;
                if (selection) {
                    YamlEditorPreferencePage.this.highlightBracketAtCaretLocation = true;
                }
            }
        });
        this.createDependency(this.bracketHighlightingCheckbox, (Control)this.enclosingBracketsRadioButton);
        this.matchingBracketsColor = new ColorFieldEditor(YamlEditorPreferenceConstants.P_EDITOR_MATCHING_BRACKETS_COLOR.getId(), "Matching brackets color", radioComposite);
        this.addField((FieldEditor)this.matchingBracketsColor);
        this.createDependency(this.bracketHighlightingCheckbox, (Control)this.matchingBracketsColor.getLabelControl(radioComposite));
        this.createDependency(this.bracketHighlightingCheckbox, (Control)this.matchingBracketsColor.getColorSelector().getButton());
        GridData codeAssistGroupLayoutData = new GridData();
        codeAssistGroupLayoutData.horizontalSpan = 2;
        codeAssistGroupLayoutData.widthHint = 400;
        Group codeAssistGroup = new Group(appearanceComposite, 0);
        codeAssistGroup.setText("Code assistance");
        codeAssistGroup.setLayout((Layout)new GridLayout());
        codeAssistGroup.setLayoutData((Object)codeAssistGroupLayoutData);
        this.codeAssistWithYamlKeywords = new BooleanFieldEditor(YamlEditorPreferenceConstants.P_CODE_ASSIST_ADD_KEYWORDS.getId(), "Yaml keywords and external commands", (Composite)codeAssistGroup);
        this.codeAssistWithYamlKeywords.getDescriptionControl((Composite)codeAssistGroup).setToolTipText("When enabled the standard keywords supported by yaml editor are always automatically available as code proposals");
        this.addField((FieldEditor)this.codeAssistWithYamlKeywords);
        this.codeAssistWithSimpleWords = new BooleanFieldEditor(YamlEditorPreferenceConstants.P_CODE_ASSIST_ADD_SIMPLEWORDS.getId(), "Existing words", (Composite)codeAssistGroup);
        this.codeAssistWithSimpleWords.getDescriptionControl((Composite)codeAssistGroup).setToolTipText("When enabled the current source will be scanned for words. The existing words will be available as code proposals");
        this.addField((FieldEditor)this.codeAssistWithSimpleWords);
        GridData specialSupportGroupLayoutData = new GridData();
        specialSupportGroupLayoutData.horizontalSpan = 2;
        specialSupportGroupLayoutData.widthHint = 400;
        Group specialSupportGroup = new Group(appearanceComposite, 0);
        specialSupportGroup.setText("Special");
        specialSupportGroup.setLayout((Layout)new GridLayout());
        specialSupportGroup.setLayoutData((Object)codeAssistGroupLayoutData);
        BooleanFieldEditor goTemplateSupportEditor = new BooleanFieldEditor(YamlEditorPreferenceConstants.P_GO_TEMPLATE_SUPPORT_ENABLED.getId(), "Support Go templates", (Composite)specialSupportGroup);
        this.addField((FieldEditor)goTemplateSupportEditor);
        goTemplateSupportEditor.getDescriptionControl((Composite)specialSupportGroup).setToolTipText("When enabled go templates will be recognized and escaped before parsing.\n This prevents parse errors because of usage of {{, }}, and other special characters in yaml.\n");
    }

    protected void initialize() {
        this.initializeBracketHighlightingPreferences();
        super.initialize();
        this.updateSlaveComponents();
    }

    private Button addButton(Composite parent, int style, String label, int indentation, SelectionListener listener) {
        Button button = new Button(parent, style);
        button.setText(label);
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        gd.horizontalSpan = 2;
        button.setLayoutData((Object)gd);
        button.addSelectionListener(listener);
        return button;
    }

    private void setBoolean(YamlEditorPreferenceConstants id, boolean value) {
        YamlEditorUtil.getPreferences().setBooleanPreference(id, value);
    }

    private boolean getBoolean(YamlEditorPreferenceConstants id) {
        return YamlEditorUtil.getPreferences().getBooleanPreference(id);
    }

    private boolean getDefaultBoolean(YamlEditorPreferenceConstants id) {
        return YamlEditorUtil.getPreferences().getDefaultBooleanPreference(id);
    }

    private void initializeBracketHighlightingPreferences() {
        this.matchingBrackets = this.getBoolean(YamlEditorPreferenceConstants.P_EDITOR_MATCHING_BRACKETS_ENABLED);
        this.highlightBracketAtCaretLocation = this.getBoolean(YamlEditorPreferenceConstants.P_EDITOR_HIGHLIGHT_BRACKET_AT_CARET_LOCATION);
        this.enclosingBrackets = this.getBoolean(YamlEditorPreferenceConstants.P_EDITOR_ENCLOSING_BRACKETS);
        this.updateBracketUI();
    }

    private void reloadBracketHighlightingPreferenceDefaults() {
        this.matchingBrackets = this.getDefaultBoolean(YamlEditorPreferenceConstants.P_EDITOR_MATCHING_BRACKETS_ENABLED);
        this.highlightBracketAtCaretLocation = this.getDefaultBoolean(YamlEditorPreferenceConstants.P_EDITOR_HIGHLIGHT_BRACKET_AT_CARET_LOCATION);
        this.enclosingBrackets = this.getDefaultBoolean(YamlEditorPreferenceConstants.P_EDITOR_ENCLOSING_BRACKETS);
        this.updateBracketUI();
    }

    private void updateBracketUI() {
        this.bracketHighlightingCheckbox.setSelection(this.matchingBrackets);
        this.enclosingBracketsRadioButton.setSelection(this.enclosingBrackets);
        if (!this.enclosingBrackets) {
            this.matchingBracketRadioButton.setSelection(!this.highlightBracketAtCaretLocation);
            this.matchingBracketAndCaretLocationRadioButton.setSelection(this.highlightBracketAtCaretLocation);
        }
        this.updateSlaveComponents();
    }

    private void updateSlaveComponents() {
        for (MasterButtonSlaveSelectionListener listener : this.masterSlaveListeners) {
            listener.updateSlaveComponent();
        }
    }

    private class MasterButtonSlaveSelectionListener
    implements SelectionListener {
        private Button master;
        private Control slave;

        public MasterButtonSlaveSelectionListener(Button master, Control slave) {
            this.master = master;
            this.slave = slave;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            this.updateSlaveComponent();
        }

        private void updateSlaveComponent() {
            boolean state = this.master.getSelection();
            this.slave.setEnabled(state);
        }
    }
}

