/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.yamleditor.preferences;

import de.jcup.yamleditor.YamlEditorUtil;
import de.jcup.yamleditor.preferences.ChangeableComboFieldEditor;
import de.jcup.yamleditor.preferences.YamlEditorPreferenceConstants;
import de.jcup.yamleditor.script.formatter.YamlEdtiorFormatterScalarStyle;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class YamlEditorFormatterPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public YamlEditorFormatterPreferencePage() {
        this.setPreferenceStore(YamlEditorUtil.getPreferences().getPreferenceStore());
    }

    public void init(IWorkbench workbench) {
    }

    protected void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        IntegerFieldEditor indentEditor = new IntegerFieldEditor(YamlEditorPreferenceConstants.P_SOURCE_FORMAT_INDENT.getId(), "Indent / Tab replacement", parent);
        indentEditor.setValidRange(2, 10);
        this.addField((FieldEditor)indentEditor);
        indentEditor.getLabelControl(parent).setToolTipText("Amount of spaces used by source formatter to make indention.\nWill also be used when inserting spaces while pressing TAB key.");
        IntegerFieldEditor lineLengthEditor = new IntegerFieldEditor(YamlEditorPreferenceConstants.P_SOURCE_FORMAT_LINE_LENGTH.getId(), "Max line length", parent);
        lineLengthEditor.setValidRange(40, 400);
        this.addField((FieldEditor)lineLengthEditor);
        lineLengthEditor.getLabelControl(parent).setToolTipText("Maximum lne length used by source formatter");
        String labelText = "Scalar style";
        YamlEdtiorFormatterScalarStyle[] allStyles = YamlEdtiorFormatterScalarStyle.values();
        String[][] entryNamesAndValues = new String[allStyles.length][2];
        int index = 0;
        YamlEdtiorFormatterScalarStyle[] yamlEdtiorFormatterScalarStyleArray = allStyles;
        int n = allStyles.length;
        int n2 = 0;
        while (n2 < n) {
            YamlEdtiorFormatterScalarStyle style = yamlEdtiorFormatterScalarStyleArray[n2];
            entryNamesAndValues[index++] = new String[]{style.getText(), style.getId()};
            ++n2;
        }
        ChangeableComboFieldEditor comboEditor = new ChangeableComboFieldEditor(YamlEditorPreferenceConstants.P_SOURCE_SCALAR_STYLE_ID.getId(), labelText, entryNamesAndValues, parent);
        this.addField(comboEditor);
        BooleanFieldEditor rescueCommentsEditor = new BooleanFieldEditor(YamlEditorPreferenceConstants.P_SOURCE_FORMAT_RESCUE_COMMENTS_ENABLED.getId(), "Rescue comments", parent);
        this.addField((FieldEditor)rescueCommentsEditor);
        rescueCommentsEditor.getDescriptionControl(parent).setToolTipText("When enabled comments will be rescued at formatting time.\n(Full line comments will be at same line number as before, comments\nat end of a yaml line are tried to be added at end of those lines again)");
        BooleanFieldEditor tcpOnFormatEditor = new BooleanFieldEditor(YamlEditorPreferenceConstants.P_PREVENT_TYPE_CONVERSION_ON_FORMAT_ENABLED.getId(), "Prevent type conversion", parent);
        this.addField((FieldEditor)tcpOnFormatEditor);
        tcpOnFormatEditor.getDescriptionControl(parent).setToolTipText("When enabled source formatter will try to keep data as is. \nFor example: 'on' is recognized as a boolean and is normally transformed into `true`.\nThis is prevented by having this option enabled.\n");
    }
}

