/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.yamleditor.outline;

import de.jcup.yamleditor.AbstractFilterableTreeQuickDialog;
import de.jcup.yamleditor.AbstractTreeViewerFilter;
import de.jcup.yamleditor.FilterPatternMatcher;
import de.jcup.yamleditor.YamlEditor;
import de.jcup.yamleditor.YamlEditorActivator;
import de.jcup.yamleditor.outline.Item;
import de.jcup.yamleditor.outline.ItemTextMatcher;
import de.jcup.yamleditor.outline.ItemTextViewerFilter;
import de.jcup.yamleditor.outline.YamlEditorContentOutlinePage;
import de.jcup.yamleditor.outline.YamlEditorOutlineLabelProvider;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class YamlQuickOutlineDialog
extends AbstractFilterableTreeQuickDialog<Item> {
    private static final int MIN_WIDTH = 400;
    private static final int MIN_HEIGHT = 300;
    private YamlEditor editor;

    public YamlQuickOutlineDialog(IAdaptable adaptable, Shell parent, String infoText) {
        super(adaptable, parent, "Yaml quick outline", 400, 300, infoText);
        this.editor = (YamlEditor)adaptable.getAdapter(YamlEditor.class);
    }

    @Override
    protected ITreeContentProvider createTreeContentProvider(IAdaptable adaptable) {
        return (ITreeContentProvider)adaptable.getAdapter(ITreeContentProvider.class);
    }

    @Override
    protected void openSelectionImpl(ISelection selection, String filterText) {
        if (this.editor == null) {
            return;
        }
        YamlEditorContentOutlinePage outlinePage = this.editor.getOutlinePage();
        boolean outlineAvailable = this.outlinePageVisible(outlinePage);
        if (outlineAvailable) {
            this.editor.openSelectedTreeItemInEditor(selection, false);
        } else {
            outlinePage.setSelection(selection);
        }
    }

    protected boolean outlinePageVisible(YamlEditorContentOutlinePage outlinePage) {
        Control control = outlinePage.getControl();
        boolean controlAvailable = control == null || control.isDisposed() || !control.isVisible();
        return controlAvailable;
    }

    @Override
    protected AbstractUIPlugin getUIPlugin() {
        YamlEditorActivator editorActivator = YamlEditorActivator.getDefault();
        return editorActivator;
    }

    @Override
    protected Item getInitialSelectedItem() {
        if (this.editor == null) {
            return null;
        }
        Item item = this.editor.getItemAtCarretPosition();
        return item;
    }

    @Override
    protected FilterPatternMatcher<Item> createItemMatcher() {
        return new ItemTextMatcher();
    }

    @Override
    protected IBaseLabelProvider createLabelProvider() {
        YamlEditorOutlineLabelProvider labelProvider = new YamlEditorOutlineLabelProvider();
        return new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)labelProvider);
    }

    @Override
    protected AbstractTreeViewerFilter<Item> createFilter() {
        return new ItemTextViewerFilter();
    }
}

