/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.yamleditor.outline;

import de.jcup.yamleditor.YamlEditorDebugSettings;
import de.jcup.yamleditor.outline.Item;
import de.jcup.yamleditor.outline.ItemType;
import de.jcup.yamleditor.outline.RootItem;
import de.jcup.yamleditor.script.YamlNode;
import de.jcup.yamleditor.script.YamlScriptModel;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.yaml.snakeyaml.nodes.Node;

public class YamlEditorTreeContentProvider
implements ITreeContentProvider {
    private static final String YAML_SCRIPT_CONTAINS_ERRORS = "YAML file contains errors.";
    private static final Object[] RESULT_WHEN_EMPTY = new Object[0];
    private Object[] items;
    private Object monitor = new Object();
    private RootItem root;

    YamlEditorTreeContentProvider() {
        this.items = RESULT_WHEN_EMPTY;
    }

    public RootItem getRoot() {
        return this.root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getElements(Object inputElement) {
        Object object = this.monitor;
        synchronized (object) {
            if (inputElement != null && !(inputElement instanceof YamlScriptModel)) {
                return new Object[]{"Unsupported input element:" + inputElement};
            }
            if (this.items != null && this.items.length > 0) {
                return this.items;
            }
        }
        return RESULT_WHEN_EMPTY;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof Item) {
            Item item = (Item)parentElement;
            return item.getChildren().toArray();
        }
        return null;
    }

    public Object getParent(Object element) {
        if (element instanceof Item) {
            Item item = (Item)element;
            if (item.parent == null || item.parent.isRoot()) {
                return null;
            }
            return item.parent;
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof Item) {
            Item item = (Item)element;
            return item.hasChildren();
        }
        return false;
    }

    private Item[] createItems(YamlScriptModel model) {
        List<YamlNode> nodes = model.getRootNode().getChildren();
        this.root = new RootItem();
        List<Item> list = this.root.getChildren();
        this.buildItems(this.root, nodes);
        if (model.hasErrors()) {
            Item item = new Item();
            item.name = YAML_SCRIPT_CONTAINS_ERRORS;
            item.type = ItemType.META_ERROR;
            item.offset = 0;
            item.length = 0;
            item.endOffset = 0;
            list.add(0, item);
        }
        return list.toArray(new Item[list.size()]);
    }

    protected void buildItems(Item parent, List<YamlNode> nodes) {
        List<Item> children = parent.getChildren();
        for (YamlNode yamlNode : nodes) {
            Item child = new Item();
            child.offset = yamlNode.getPosition();
            child.endOffset = yamlNode.getEnd();
            child.length = yamlNode.getLengthToNameEnd();
            child.name = yamlNode.getName();
            children.add(child);
            child.parent = parent;
            this.appendDebugIfAvailable(yamlNode, child);
            if (!yamlNode.hasChildren()) continue;
            this.buildItems(child, yamlNode.getChildren());
        }
    }

    protected void appendDebugIfAvailable(YamlNode yamlNode, Item child) {
        if (yamlNode.isDebug()) {
            child.type = ItemType.META_DEBUG;
        } else if (YamlEditorDebugSettings.DEBUG_OUTPUT_ENABLED) {
            StringBuilder sb = new StringBuilder();
            sb.append("pos:");
            sb.append(yamlNode.getPosition());
            sb.append(",end:");
            sb.append(yamlNode.getEnd());
            sb.append(",length:");
            sb.append(yamlNode.getEnd() - yamlNode.getPosition());
            sb.append(",");
            sb.append("snake{");
            Node snakeNode = yamlNode.getSnakeNode();
            if (snakeNode != null) {
                sb.append("type=");
                sb.append(snakeNode.getType().getSimpleName());
                sb.append(",");
                sb.append(snakeNode.getNodeId());
            } else {
                sb.append("null");
            }
            sb.append("}");
            sb.append(child.name);
            child.name = sb.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildTree(YamlScriptModel model) {
        Object object = this.monitor;
        synchronized (object) {
            if (model == null) {
                this.items = null;
                return;
            }
            this.items = this.createItems(model);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Item tryToFindByOffset(int offset) {
        Object object = this.monitor;
        synchronized (object) {
            block4: {
                if (this.items != null) break block4;
                return null;
            }
            Object[] children = this.items;
            Item item = this.tryToFindItemWithOffset(offset, children);
            return item;
        }
    }

    private Item tryToFindItemWithOffset(int offset, Object[] children) {
        Object[] objectArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object oitem = objectArray[n2];
            if (oitem instanceof Item) {
                Item item = (Item)oitem;
                int itemStart = item.getOffset();
                int itemEnd = item.getEndOffset();
                if (offset >= itemStart && offset <= itemEnd) {
                    return item;
                }
                Item result = this.tryToFindItemWithOffset(offset, item.getChildren().toArray());
                if (result != null) {
                    return result;
                }
            }
            ++n2;
        }
        return null;
    }
}

