/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.yamleditor.outline;

import de.jcup.yamleditor.ColorManager;
import de.jcup.yamleditor.EclipseUtil;
import de.jcup.yamleditor.YamlEditorActivator;
import de.jcup.yamleditor.YamlEditorColorConstants;
import de.jcup.yamleditor.outline.Item;
import de.jcup.yamleditor.outline.ItemType;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IToolTipProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;

public class YamlEditorOutlineLabelProvider
extends BaseLabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider,
IColorProvider,
IToolTipProvider {
    private static final String ICON_NODE = "public_co.png";
    private static final String ICON_LEAF = "field_public_obj.png";
    private static final String ICON_ERROR = "error_tsk.png";
    private static final String ICON_INFO = "info_tsk.png";
    private StyledString.Styler outlineItemTypeStyler = new StyledString.Styler(){

        public void applyStyles(TextStyle textStyle) {
            textStyle.foreground = YamlEditorOutlineLabelProvider.this.getColorManager().getColor(YamlEditorColorConstants.OUTLINE_ITEM__TYPE);
        }
    };

    public Color getBackground(Object element) {
        return null;
    }

    public Color getForeground(Object element) {
        return null;
    }

    public Image getImage(Object element) {
        if (element == null) {
            return null;
        }
        if (element instanceof Item) {
            Item item = (Item)element;
            ItemType type = item.getItemType();
            if (type == null) {
                if (item.hasChildren()) {
                    return this.getOutlineImage(ICON_NODE);
                }
                return this.getOutlineImage(ICON_LEAF);
            }
            switch (type) {
                case META_ERROR: {
                    return this.getOutlineImage(ICON_ERROR);
                }
                case META_INFO: {
                    return this.getOutlineImage(ICON_INFO);
                }
            }
        }
        return null;
    }

    public StyledString getStyledText(Object element) {
        StyledString styled = new StyledString();
        if (element == null) {
            styled.append("null");
        }
        if (element instanceof Item) {
            StyledString typeString;
            Item item = (Item)element;
            ItemType itemType = item.getItemType();
            if (itemType == ItemType.SPECIAL) {
                typeString = new StyledString("special:", this.outlineItemTypeStyler);
                styled.append(typeString);
            } else if (itemType == ItemType.META_DEBUG) {
                typeString = new StyledString(String.valueOf(item.getOffset()) + ": ", this.outlineItemTypeStyler);
                styled.append(typeString);
            }
            String name = item.getName();
            if (name != null) {
                styled.append(name);
            }
        } else {
            return styled.append(element.toString());
        }
        return styled;
    }

    public ColorManager getColorManager() {
        YamlEditorActivator editorActivator = YamlEditorActivator.getDefault();
        if (editorActivator == null) {
            return ColorManager.getStandalone();
        }
        return editorActivator.getColorManager();
    }

    private Image getOutlineImage(String name) {
        return EclipseUtil.getImage("/icons/outline/" + name, "de.jcup.yamleditor");
    }

    public String getToolTipText(Object element) {
        Item item;
        if (element instanceof Item && ItemType.META_ERROR.equals((Object)(item = (Item)element).getItemType())) {
            return String.valueOf(item.getName()) + "\nThe outline will only show valid parts of document!";
        }
        return null;
    }
}

