/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.yamleditor.outline;

import de.jcup.yamleditor.EclipseUtil;
import de.jcup.yamleditor.YamlEditor;
import de.jcup.yamleditor.outline.Item;
import de.jcup.yamleditor.outline.YamlEditorOutlineLabelProvider;
import de.jcup.yamleditor.outline.YamlEditorTreeContentProvider;
import de.jcup.yamleditor.script.YamlScriptModel;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class YamlEditorContentOutlinePage
extends ContentOutlinePage
implements IDoubleClickListener {
    private static ImageDescriptor IMG_DESC_LINKED = YamlEditorContentOutlinePage.createImageDescriptor("/icons/outline/synced.png");
    private static ImageDescriptor IMG_DESC_NOT_LINKED = YamlEditorContentOutlinePage.createImageDescriptor("/icons/outline/sync_broken.png");
    private static ImageDescriptor IMG_DESC_EXPAND_ALL = YamlEditorContentOutlinePage.createImageDescriptor("/icons/expandall.png");
    private static ImageDescriptor IMG_DESC_COLLAPSE_ALL = YamlEditorContentOutlinePage.createImageDescriptor("/icons/collapseall.png");
    private YamlEditorTreeContentProvider contentProvider;
    private Object input;
    private YamlEditor editor;
    private YamlEditorOutlineLabelProvider labelProvider;
    private boolean linkingWithEditorEnabled;
    private boolean ignoreNextSelectionEvents;
    private ToggleLinkingAction toggleLinkingAction;
    private ISelection selection;

    public YamlEditorContentOutlinePage(YamlEditor editor) {
        this.editor = editor;
        this.contentProvider = new YamlEditorTreeContentProvider();
    }

    private static ImageDescriptor createImageDescriptor(String name) {
        return EclipseUtil.createImageDescriptor(name, "de.jcup.yamleditor");
    }

    public YamlEditorTreeContentProvider getContentProvider() {
        return this.contentProvider;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.labelProvider = new YamlEditorOutlineLabelProvider();
        TreeViewer viewer = this.getTreeViewer();
        viewer.setContentProvider((IContentProvider)this.contentProvider);
        viewer.addDoubleClickListener((IDoubleClickListener)this);
        viewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)this.labelProvider));
        viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        ExpandAllAction expandAllAction = new ExpandAllAction();
        CollapseAllAction collapseAllAction = new CollapseAllAction();
        ExpandSelectionAction expandSelectionAction = new ExpandSelectionAction();
        CollapseSelectionAction collapseSelectionAction = new CollapseSelectionAction();
        MenuManager menuMgr = new MenuManager();
        menuMgr.add((IAction)expandSelectionAction);
        menuMgr.add((IAction)collapseSelectionAction);
        Menu menu = menuMgr.createContextMenu((Control)viewer.getTree());
        viewer.getControl().setMenu(menu);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)viewer);
        if (this.input != null) {
            viewer.setInput(this.input);
        }
        this.toggleLinkingAction = new ToggleLinkingAction();
        this.toggleLinkingAction.setActionDefinitionId("org.eclipse.ui.navigate.linkWithEditor");
        IActionBars actionBars = this.getSite().getActionBars();
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        toolBarManager.add((IAction)expandAllAction);
        toolBarManager.add((IAction)collapseAllAction);
        toolBarManager.add((IAction)this.toggleLinkingAction);
        IMenuManager viewMenuManager = actionBars.getMenuManager();
        viewMenuManager.add((IContributionItem)new Separator("EndFilterGroup"));
        viewMenuManager.add((IContributionItem)new Separator("treeGroup"));
        viewMenuManager.add((IAction)this.toggleLinkingAction);
        viewMenuManager.add((IAction)expandAllAction);
        viewMenuManager.add((IAction)collapseAllAction);
        viewMenuManager.add((IContributionItem)new Separator("treeSelectionGroup"));
        viewMenuManager.add((IAction)expandSelectionAction);
        viewMenuManager.add((IAction)collapseSelectionAction);
        if (this.input == null && this.editor != null) {
            this.editor.rebuildOutline();
        }
    }

    public void doubleClick(DoubleClickEvent event) {
        if (this.editor == null) {
            return;
        }
        if (this.linkingWithEditorEnabled) {
            this.editor.setFocus();
            return;
        }
        ISelection selection = event.getSelection();
        this.editor.openSelectedTreeItemInEditor(selection, true);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        super.selectionChanged(event);
        if (!this.linkingWithEditorEnabled) {
            return;
        }
        if (this.ignoreNextSelectionEvents) {
            return;
        }
        this.selection = event.getSelection();
        this.editor.openSelectedTreeItemInEditor(this.selection, false);
    }

    public void onEditorCaretMoved(int caretOffset) {
        YamlEditorTreeContentProvider gcp;
        Item item;
        if (!this.linkingWithEditorEnabled) {
            return;
        }
        this.ignoreNextSelectionEvents = true;
        if (this.contentProvider instanceof YamlEditorTreeContentProvider && (item = (gcp = this.contentProvider).tryToFindByOffset(caretOffset)) != null) {
            this.selection = new StructuredSelection((Object)item);
            this.getTreeViewer().setSelection(this.selection, true);
        }
        this.ignoreNextSelectionEvents = false;
    }

    private Object getFirstSelectedElement() {
        if (!(this.selection instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection ss = (IStructuredSelection)this.selection;
        Object element = ss.getFirstElement();
        return element;
    }

    public void rebuild(YamlScriptModel model) {
        if (model == null) {
            return;
        }
        this.contentProvider.rebuildTree(model);
        TreeViewer treeViewer = this.getTreeViewer();
        if (treeViewer != null) {
            Control control = treeViewer.getControl();
            if (control == null || control.isDisposed()) {
                return;
            }
            treeViewer.setInput((Object)model);
        }
    }

    protected ImageDescriptor getImageDescriptionForLinked() {
        return IMG_DESC_LINKED;
    }

    protected ImageDescriptor getImageDescriptionNotLinked() {
        return IMG_DESC_NOT_LINKED;
    }

    class CollapseAllAction
    extends Action {
        private CollapseAllAction() {
            this.setImageDescriptor(IMG_DESC_COLLAPSE_ALL);
            this.setText("Collapse all");
        }

        public void run() {
            YamlEditorContentOutlinePage.this.getTreeViewer().collapseAll();
        }
    }

    class CollapseSelectionAction
    extends Action {
        private CollapseSelectionAction() {
            this.setImageDescriptor(IMG_DESC_COLLAPSE_ALL);
            this.setText("Collapse children");
        }

        public void run() {
            Object element = YamlEditorContentOutlinePage.this.getFirstSelectedElement();
            if (element == null) {
                return;
            }
            YamlEditorContentOutlinePage.this.getTreeViewer().collapseToLevel(element, -1);
        }
    }

    class ExpandAllAction
    extends Action {
        private ExpandAllAction() {
            this.setImageDescriptor(IMG_DESC_EXPAND_ALL);
            this.setText("Expand all");
        }

        public void run() {
            YamlEditorContentOutlinePage.this.getTreeViewer().expandAll();
        }
    }

    class ExpandSelectionAction
    extends Action {
        private ExpandSelectionAction() {
            this.setImageDescriptor(IMG_DESC_EXPAND_ALL);
            this.setText("Expand children");
        }

        public void run() {
            Object element = YamlEditorContentOutlinePage.this.getFirstSelectedElement();
            if (element == null) {
                return;
            }
            YamlEditorContentOutlinePage.this.getTreeViewer().expandToLevel(element, -1);
        }
    }

    class ToggleLinkingAction
    extends Action {
        private ToggleLinkingAction() {
            if (YamlEditorContentOutlinePage.this.editor != null) {
                YamlEditorContentOutlinePage.this.linkingWithEditorEnabled = YamlEditorContentOutlinePage.this.editor.getPreferences().isLinkOutlineWithEditorEnabled();
            }
            this.setDescription("link with editor");
            this.initImage();
            this.initText();
        }

        public void run() {
            YamlEditorContentOutlinePage.this.linkingWithEditorEnabled = !YamlEditorContentOutlinePage.this.linkingWithEditorEnabled;
            this.initText();
            this.initImage();
        }

        private void initImage() {
            this.setImageDescriptor(YamlEditorContentOutlinePage.this.linkingWithEditorEnabled ? YamlEditorContentOutlinePage.this.getImageDescriptionForLinked() : YamlEditorContentOutlinePage.this.getImageDescriptionNotLinked());
        }

        private void initText() {
            this.setText(YamlEditorContentOutlinePage.this.linkingWithEditorEnabled ? "Click to unlink from editor" : "Click to link with editor");
        }
    }
}

