/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.yamleditor.document;

import de.jcup.yamleditor.document.ScanSlider;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class YamlMappingRule
implements IPredicateRule {
    private static final int MAXIMUM_PREFIX_BEFORE_INFINIT_LOOP_DETECTED = 10000;
    private IToken token;

    public YamlMappingRule(IToken token) {
        this.token = token;
    }

    public IToken getSuccessToken() {
        return this.token;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        return this.evaluate(scanner, false);
    }

    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        char c;
        boolean startOfDocument;
        ScanSlider slider = new ScanSlider(scanner);
        boolean newLine = startOfDocument = scanner.getColumn() == 0;
        if (!startOfDocument) {
            int cbefore = slider.readBefore();
            newLine = this.isNewLine(scanner, (char)cbefore);
            StringBuilder prefixSb = null;
            while (!newLine) {
                if (prefixSb == null) {
                    prefixSb = new StringBuilder();
                }
                if (prefixSb.length() > 10000) {
                    System.err.println("Yaml editor: Infinite loop detected. Prevent eclipse freeze by terminating editor.");
                    return this.getSuccessToken();
                }
                char cb = (char)cbefore;
                boolean hyphenAlreadyInPrefix = prefixSb.indexOf("-") != -1;
                boolean possibleListEntry = cb == '-' && !hyphenAlreadyInPrefix;
                prefixSb.append(cb);
                if (cb != ' ' && !possibleListEntry) break;
                slider.moveBack();
                slider.moveBack();
                if (scanner.getColumn() == 0) {
                    newLine = true;
                    break;
                }
                cbefore = slider.readBefore();
                newLine = this.isNewLine(scanner, (char)cbefore);
            }
            slider.resetScanner();
        }
        if (!newLine) {
            slider.resetScanner();
            return Token.UNDEFINED;
        }
        char start = (char)slider.moveForward();
        if (!this.isWordStart(start)) {
            slider.resetScanner();
            return Token.UNDEFINED;
        }
        StringBuilder sb = new StringBuilder();
        do {
            int read = slider.moveForward();
            c = (char)read;
            if (-1 != read && this.isWordPart(sb, c)) continue;
            slider.resetScanner();
            return Token.UNDEFINED;
        } while (c != ':' || !Character.isWhitespace(c = (char)slider.moveForward()));
        return this.getSuccessToken();
    }

    protected boolean isNewLine(ICharacterScanner scanner, char cbefore) {
        boolean newLine = scanner.getColumn() == 0;
        newLine = newLine || cbefore == '\n';
        newLine = newLine || cbefore == '\r';
        return newLine;
    }

    private boolean isWordPart(StringBuilder sb, char c) {
        if (c == ':' || c == '-' || c == '_' || c == '.' || c == '*') {
            return true;
        }
        if (c == ' ') {
            return sb.indexOf(":") == -1;
        }
        return Character.isLetterOrDigit(c);
    }

    private boolean isWordStart(char c) {
        return Character.isAlphabetic(c);
    }
}

