/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.yamleditor.document;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public abstract class YamlLineStartsWithRule
implements IPredicateRule {
    private IToken successToken;
    private char[] startsWith;
    private char[] endsWith;
    private boolean multiLines;
    private boolean successAfterStartFound;

    public YamlLineStartsWithRule(String startsWith, String endsWith, boolean successAfterStartFound, boolean multiLines, IToken token) {
        this.successToken = token;
        this.multiLines = multiLines;
        this.startsWith = startsWith.toCharArray();
        this.endsWith = endsWith == null ? new char[]{} : endsWith.toCharArray();
        this.successAfterStartFound = successAfterStartFound;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        return this.evaluate(scanner, false);
    }

    public IToken getSuccessToken() {
        return this.successToken;
    }

    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        int count;
        block13: {
            count = 0;
            int pos = 0;
            while (pos < this.startsWith.length) {
                int c = scanner.read();
                ++count;
                if (c == -1 || c == 10 || c == 13) {
                    return this.resetScannerAndReturnUndefined(scanner, count);
                }
                if (this.startsWith[pos] != c && this.isAcceptedAtStart(c)) {
                    pos = 0;
                    continue;
                }
                if (this.startsWith[pos++] == c) continue;
                return this.resetScannerAndReturnUndefined(scanner, count);
            }
            if (this.successAfterStartFound) {
                return this.getSuccessToken();
            }
            boolean noEndsWithScanNecessary = this.endsWith.length == 0;
            int n = -1;
            int endsWithPos = 0;
            while (true) {
                int n2 = scanner.read();
                ++count;
                if (n2 == -1) {
                    if (noEndsWithScanNecessary) {
                        return this.getSuccessToken();
                    }
                    return this.resetScannerAndReturnUndefined(scanner, count);
                }
                if (n2 == 10) {
                    if (this.multiLines) {
                        endsWithPos = 0;
                        continue;
                    }
                    if (noEndsWithScanNecessary) {
                        return this.getSuccessToken();
                    }
                    return this.resetScannerAndReturnUndefined(scanner, count);
                }
                if (noEndsWithScanNecessary) continue;
                if (this.multiLines) {
                    if (endsWithPos >= this.endsWith.length) continue;
                    if (n2 != this.endsWith[endsWithPos]) {
                        endsWithPos = this.endsWith.length + 1;
                        continue;
                    }
                    if (++endsWithPos != this.endsWith.length) continue;
                    return this.getSuccessToken();
                }
                if (endsWithPos >= this.endsWith.length) break block13;
                if (n2 == this.endsWith[endsWithPos]) {
                    ++endsWithPos;
                }
                if (endsWithPos == this.endsWith.length) break;
            }
            return this.getSuccessToken();
        }
        return this.resetScannerAndReturnUndefined(scanner, count);
    }

    protected abstract boolean isAcceptedAtStart(int var1);

    private IToken resetScannerAndReturnUndefined(ICharacterScanner scanner, int count) {
        while (count > 0) {
            scanner.unread();
            --count;
        }
        return Token.UNDEFINED;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(":starsWith='");
        sb.append(this.startsWith);
        sb.append("', endsWith='");
        sb.append(this.endsWith);
        sb.append("', multiLines=");
        sb.append(this.multiLines);
        return sb.toString();
    }
}

