/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.yamleditor.document;

import de.jcup.yamleditor.document.ExactWordPatternRule;
import de.jcup.yamleditor.document.OnlyHyphenKeyWordDetector;
import de.jcup.yamleditor.document.OnlyLettersKeyWordDetector;
import de.jcup.yamleditor.document.YamlDocumentIdentifier;
import de.jcup.yamleditor.document.YamlDocumentIdentifiers;
import de.jcup.yamleditor.document.YamlDoubleQuoteRule;
import de.jcup.yamleditor.document.YamlMappingRule;
import de.jcup.yamleditor.document.YamlSingleQuoteRule;
import de.jcup.yamleditor.document.keywords.DocumentKeyWord;
import de.jcup.yamleditor.document.keywords.YamlBooleanKeyWords;
import de.jcup.yamleditor.document.keywords.YamlReservedWords;
import de.jcup.yamleditor.preferences.YamlEditorPreferences;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;

public class YamlDocumentPartitionScanner
extends RuleBasedPartitionScanner {
    private OnlyLettersKeyWordDetector onlyLettersWordDetector = new OnlyLettersKeyWordDetector();
    private OnlyHyphenKeyWordDetector onlyHyphenWordsDetector = new OnlyHyphenKeyWordDetector();

    public int getOffset() {
        return this.fOffset;
    }

    public YamlDocumentPartitionScanner() {
        IToken block = this.createToken(YamlDocumentIdentifiers.BLOCK_KEYWORD);
        IToken comment = this.createToken(YamlDocumentIdentifiers.COMMENT);
        IToken doubleString = this.createToken(YamlDocumentIdentifiers.DOUBLE_STRING);
        IToken singleString = this.createToken(YamlDocumentIdentifiers.SINGLE_STRING);
        IToken mappings = this.createToken(YamlDocumentIdentifiers.MAPPINGS);
        IToken yamlReservedWords = this.createToken(YamlDocumentIdentifiers.RESERVED_WORDS);
        IToken booleans = this.createToken(YamlDocumentIdentifiers.BOOLEANS);
        ArrayList<IPredicateRule> rules = new ArrayList<IPredicateRule>();
        rules.add((IPredicateRule)new SingleLineRule("#", "", comment, '\uffff', true));
        rules.add(new YamlDoubleQuoteRule(doubleString));
        rules.add(new YamlSingleQuoteRule(singleString));
        rules.add((IPredicateRule)new ExactWordPatternRule(this.onlyHyphenWordsDetector, "---", block, true));
        rules.add((IPredicateRule)new SingleLineRule("<tag:", ">", yamlReservedWords, '\uffff', true));
        rules.add(new YamlMappingRule(mappings));
        if (YamlEditorPreferences.getInstance().isGoTemplateSupportEnabled()) {
            IToken goTemplates = this.createToken(YamlDocumentIdentifiers.GO_TEMPLATE_BLOCK);
            rules.add((IPredicateRule)new MultiLineRule("{{", "}}", goTemplates));
        }
        this.buildWordRules(rules, booleans, YamlBooleanKeyWords.values());
        this.buildWordRules(rules, yamlReservedWords, YamlReservedWords.values());
        this.setPredicateRules(rules.toArray(new IPredicateRule[rules.size()]));
    }

    private void buildWordRules(List<IPredicateRule> rules, IToken token, DocumentKeyWord[] values) {
        DocumentKeyWord[] documentKeyWordArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            DocumentKeyWord keyWord = documentKeyWordArray[n2];
            ExactWordPatternRule rule1 = new ExactWordPatternRule(this.onlyLettersWordDetector, this.createWordStart(keyWord), token, keyWord.isBreakingOnEof());
            rules.add((IPredicateRule)rule1);
            ++n2;
        }
    }

    private String createWordStart(DocumentKeyWord keyWord) {
        return keyWord.getText();
    }

    private IToken createToken(YamlDocumentIdentifier identifier) {
        return new Token((Object)identifier.getId());
    }
}

