/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.yamleditor.document;

import de.jcup.yamleditor.document.Counter;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.WordPatternRule;

public class ExactWordPatternRule
extends WordPatternRule {
    private String toStringValue;
    StringBuilder traceSb;
    boolean trace = false;
    private int allowedPrefix = -1;
    private int allowedPostfix = -1;

    public void setAllowedPostfix(char allowedPostfix) {
        this.allowedPostfix = allowedPostfix;
    }

    public void setAllowedPrefix(char allowedPrefix) {
        this.allowedPrefix = allowedPrefix;
    }

    public ExactWordPatternRule(IWordDetector detector, String exactWord, IToken token) {
        this(detector, exactWord, token, true);
    }

    public ExactWordPatternRule(IWordDetector detector, String exactWord, IToken token, boolean breaksOnEOF) {
        super(detector, exactWord, null, token);
        this.toStringValue = String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ":" + exactWord;
        this.fBreaksOnEOF = breaksOnEOF;
    }

    protected boolean sequenceDetected(ICharacterScanner scanner, char[] sequence, boolean eofAllowed) {
        boolean wordHasPrefix;
        int column;
        Counter counter = new Counter();
        if (this.trace) {
            this.traceSb = new StringBuilder();
        }
        if ((column = scanner.getColumn()) == 1) {
            wordHasPrefix = false;
        } else {
            this.scannerUnread(scanner, counter);
            this.scannerUnread(scanner, counter);
            char charBefore = (char)this.scannerRead(scanner, counter);
            this.scannerRead(scanner, counter);
            wordHasPrefix = this.isIllegalPrefixCharacter(charBefore);
        }
        if (wordHasPrefix) {
            this.scannerRead(scanner, counter);
            return counter.cleanupAndReturn(scanner, false);
        }
        int i = 1;
        while (i < sequence.length) {
            int c = this.scannerRead(scanner, counter);
            if (c == -1) {
                if (eofAllowed) {
                    return counter.cleanupAndReturn(scanner, true);
                }
                return counter.cleanupAndReturn(scanner, false);
            }
            if (c != sequence[i]) {
                this.scannerUnread(scanner, counter);
                int j = i - 1;
                while (j > 0) {
                    this.scannerUnread(scanner, counter);
                    --j;
                }
                return counter.cleanupAndReturn(scanner, false);
            }
            ++i;
        }
        int read = this.scannerRead(scanner, counter);
        char charAfter = (char)read;
        this.scannerUnread(scanner, counter);
        if (charAfter != this.allowedPostfix && !Character.isWhitespace(charAfter) && -1 != read) {
            return counter.cleanupAndReturn(scanner, false);
        }
        return counter.cleanupAndReturn(scanner, true);
    }

    private boolean isIllegalPrefixCharacter(char charBefore) {
        if (charBefore == this.allowedPrefix) {
            return false;
        }
        boolean isPrefix = !Character.isWhitespace(charBefore);
        return isPrefix;
    }

    private int scannerRead(ICharacterScanner scanner, Counter counter) {
        int c = scanner.read();
        if (c == -1) {
            return c;
        }
        ++counter.count;
        if (this.trace) {
            this.traceSb.append((char)c);
        }
        return c;
    }

    private void scannerUnread(ICharacterScanner scanner, Counter counter) {
        scanner.unread();
        --counter.count;
        if (this.trace) {
            int length = this.traceSb.length();
            if (length < 1) {
                this.traceSb.append("[(-1)]");
            } else {
                this.traceSb.setLength(--length);
            }
        }
    }

    public String toString() {
        return this.toStringValue;
    }
}

