/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.yamleditor;

import de.jcup.eclipse.commons.codeassist.MultipleContentAssistProcessor;
import de.jcup.eclipse.commons.templates.TemplateSupport;
import de.jcup.yamleditor.ColorManager;
import de.jcup.yamleditor.YamlEditorActivator;
import de.jcup.yamleditor.YamlEditorSimpleWordContentAssistProcessor;
import de.jcup.yamleditor.YamlEditorUtil;
import de.jcup.yamleditor.YamlHyperlinkDetector;
import de.jcup.yamleditor.document.YamlDocumentIdentifiers;
import de.jcup.yamleditor.preferences.YamlEditorPreferences;
import de.jcup.yamleditor.preferences.YamlEditorSyntaxColorPreferenceConstants;
import de.jcup.yamleditor.presentation.PresentationSupport;
import de.jcup.yamleditor.presentation.YamlDefaultTextScanner;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.URLHyperlinkDetector;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.quickassist.IQuickAssistAssistant;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.DefaultAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.templates.TemplateCompletionProcessor;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class YamlSourceViewerConfiguration
extends TextSourceViewerConfiguration {
    private YamlDefaultTextScanner scanner;
    private ColorManager colorManager;
    private TextAttribute defaultTextAttribute;
    private YamlEditorAnnotationHoover annotationHoover;
    private IAdaptable adaptable;
    private ContentAssistant contentAssistant;
    private YamlEditorSimpleWordContentAssistProcessor contentAssistProcessor;

    public YamlSourceViewerConfiguration(IAdaptable adaptable) {
        IPreferenceStore generalTextStore = EditorsUI.getPreferenceStore();
        this.fPreferenceStore = new ChainedPreferenceStore(new IPreferenceStore[]{YamlEditorUtil.getPreferences().getPreferenceStore(), generalTextStore});
        Assert.isNotNull((Object)adaptable, (String)"adaptable may not be null!");
        this.annotationHoover = new YamlEditorAnnotationHoover();
        this.initContentAssistance();
        this.colorManager = (ColorManager)adaptable.getAdapter(ColorManager.class);
        Assert.isNotNull((Object)this.colorManager, (String)" adaptable must support color manager");
        this.defaultTextAttribute = new TextAttribute(this.colorManager.getColor(YamlEditorUtil.getPreferences().getColor(YamlEditorSyntaxColorPreferenceConstants.COLOR_NORMAL_TEXT)));
        this.adaptable = adaptable;
    }

    private void initContentAssistance() {
        this.contentAssistant = new ContentAssistant();
        this.contentAssistProcessor = new YamlEditorSimpleWordContentAssistProcessor();
        this.contentAssistant.enableColoredLabels(true);
        YamlDocumentIdentifiers[] yamlDocumentIdentifiersArray = YamlDocumentIdentifiers.values();
        int n = yamlDocumentIdentifiersArray.length;
        int n2 = 0;
        while (n2 < n) {
            YamlDocumentIdentifiers identifier = yamlDocumentIdentifiersArray[n2];
            this.contentAssistant.setContentAssistProcessor((IContentAssistProcessor)this.contentAssistProcessor, identifier.getId());
            ++n2;
        }
        this.contentAssistant.addCompletionListener(this.contentAssistProcessor.getCompletionListener());
        TemplateSupport templatesupport = YamlEditorActivator.getDefault().getTemplateSupportProvider().getSupport();
        TemplateCompletionProcessor templateProcessor = templatesupport.getProcessor();
        MultipleContentAssistProcessor multiProcessor = new MultipleContentAssistProcessor((IContentAssistProcessor)templateProcessor, new IContentAssistProcessor[]{this.contentAssistProcessor});
        this.contentAssistant.setContentAssistProcessor((IContentAssistProcessor)multiProcessor, "__dftl_partition_content_type");
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        return this.contentAssistant;
    }

    public IQuickAssistAssistant getQuickAssistAssistant(ISourceViewer sourceViewer) {
        return null;
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        return null;
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return this.annotationHoover;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return YamlDocumentIdentifiers.allIdsToStringArray("__dftl_partition_content_type");
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        if (sourceViewer == null) {
            return null;
        }
        return new IHyperlinkDetector[]{new URLHyperlinkDetector(), new YamlHyperlinkDetector(this.adaptable)};
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        this.addDefaultPresentation(reconciler);
        this.addPresentation(reconciler, YamlDocumentIdentifiers.BLOCK_KEYWORD.getId(), YamlEditorUtil.getPreferences().getColor(YamlEditorSyntaxColorPreferenceConstants.COLOR_BLOCK), 1);
        this.addPresentation(reconciler, YamlDocumentIdentifiers.RESERVED_WORDS.getId(), YamlEditorUtil.getPreferences().getColor(YamlEditorSyntaxColorPreferenceConstants.COLOR_RESERVED_KEYWORD), 1);
        this.addPresentation(reconciler, YamlDocumentIdentifiers.BOOLEANS.getId(), YamlEditorUtil.getPreferences().getColor(YamlEditorSyntaxColorPreferenceConstants.COLOR_BOOLEANS), 0);
        this.addPresentation(reconciler, YamlDocumentIdentifiers.DOUBLE_STRING.getId(), YamlEditorUtil.getPreferences().getColor(YamlEditorSyntaxColorPreferenceConstants.COLOR_GSTRING), 0);
        this.addPresentation(reconciler, YamlDocumentIdentifiers.SINGLE_STRING.getId(), YamlEditorUtil.getPreferences().getColor(YamlEditorSyntaxColorPreferenceConstants.COLOR_SINGLE_STRING), 0);
        this.addPresentation(reconciler, YamlDocumentIdentifiers.COMMENT.getId(), YamlEditorUtil.getPreferences().getColor(YamlEditorSyntaxColorPreferenceConstants.COLOR_COMMENT), 0);
        this.addPresentation(reconciler, YamlDocumentIdentifiers.MAPPINGS.getId(), YamlEditorUtil.getPreferences().getColor(YamlEditorSyntaxColorPreferenceConstants.COLOR_MAPPINGS), 1);
        if (YamlEditorPreferences.getInstance().isGoTemplateSupportEnabled()) {
            this.addPresentation(reconciler, YamlDocumentIdentifiers.GO_TEMPLATE_BLOCK.getId(), YamlEditorUtil.getPreferences().getColor(YamlEditorSyntaxColorPreferenceConstants.COLOR_TEMPLATE_VARIABLE), 2);
        }
        return reconciler;
    }

    private void addDefaultPresentation(PresentationReconciler reconciler) {
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.getYamlDefaultTextScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
    }

    private IToken createColorToken(RGB rgb) {
        Token token = new Token((Object)new TextAttribute(this.colorManager.getColor(rgb)));
        return token;
    }

    private void addPresentation(PresentationReconciler reconciler, String id, RGB rgb, int style) {
        TextAttribute textAttribute = new TextAttribute(this.colorManager.getColor(rgb), this.defaultTextAttribute.getBackground(), style);
        PresentationSupport presentation = new PresentationSupport(textAttribute);
        reconciler.setDamager((IPresentationDamager)presentation, id);
        reconciler.setRepairer((IPresentationRepairer)presentation, id);
    }

    private YamlDefaultTextScanner getYamlDefaultTextScanner() {
        if (this.scanner == null) {
            this.scanner = new YamlDefaultTextScanner(this.colorManager);
            this.updateTextScannerDefaultColorToken();
        }
        return this.scanner;
    }

    public void updateTextScannerDefaultColorToken() {
        if (this.scanner == null) {
            return;
        }
        RGB color = YamlEditorUtil.getPreferences().getColor(YamlEditorSyntaxColorPreferenceConstants.COLOR_NORMAL_TEXT);
        this.scanner.setDefaultReturnToken(this.createColorToken(color));
    }

    private class YamlEditorAnnotationHoover
    extends DefaultAnnotationHover {
        private YamlEditorAnnotationHoover() {
        }

        protected boolean isIncluded(Annotation annotation) {
            return annotation instanceof MarkerAnnotation;
        }
    }
}

