/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.yamleditor;

import org.eclipse.jface.text.IPaintPositionManager;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class YamlMarginRulePainter
implements IPainter,
PaintListener,
ModifyListener {
    private StyledText styledText;
    private int cachedWidgetX = -1;
    private boolean active = false;
    private MarginPaintSetup setup;
    private int pixels;

    public YamlMarginRulePainter(ITextViewer textViewer, MarginPaintSetup setup) {
        this.styledText = textViewer.getTextWidget();
        this.setup = setup;
        this.initialize();
    }

    private void initialize() {
        this.computeWidgetX();
        this.redrawWidget();
    }

    private void computeWidgetX() {
        int pixels = this.getCalculatedPixelsForOneCharacter();
        this.cachedWidgetX = pixels * this.setup.column;
    }

    private int getCalculatedPixelsForOneCharacter() {
        if (this.pixels != -1) {
            return this.pixels;
        }
        GC gc = new GC((Drawable)this.styledText);
        this.pixels = gc.getFontMetrics().getAverageCharWidth();
        gc.dispose();
        return this.pixels;
    }

    public void setX(int x) {
        if (x == this.cachedWidgetX) {
            return;
        }
        this.cachedWidgetX = x;
        this.redrawWidget();
    }

    public void deactivate(boolean redraw) {
        if (!this.active) {
            return;
        }
        this.active = false;
        this.cachedWidgetX = -1;
        this.styledText.removePaintListener((PaintListener)this);
        if (redraw) {
            this.redrawWidget();
        }
    }

    protected void redrawWidget() {
        this.styledText.redraw();
    }

    public void dispose() {
        this.styledText = null;
    }

    public void paint(int reason) {
        if (this.active) {
            if (16 == reason || 8 == reason) {
                this.redrawWidget();
            }
            return;
        }
        this.active = true;
        this.styledText.addPaintListener((PaintListener)this);
        if (this.cachedWidgetX == -1) {
            this.computeWidgetX();
        }
        this.redrawWidget();
    }

    public void paintControl(PaintEvent e) {
        int x;
        if (this.styledText != null && (x = this.cachedWidgetX - this.styledText.getHorizontalPixel()) >= 0) {
            Rectangle area = this.styledText.getClientArea();
            e.gc.setForeground(this.setup.lineColor);
            e.gc.setLineStyle(this.setup.lineStyle);
            e.gc.setLineWidth(this.setup.lineWidth);
            e.gc.drawLine(x, 0, x, area.height);
        }
    }

    public void setPositionManager(IPaintPositionManager manager) {
    }

    public void modifyText(ModifyEvent e) {
    }

    public static class MarginPaintSetup {
        public int column = 1;
        public Color lineColor;
        public int lineStyle = 1;
        public int lineWidth = 1;
    }
}

