/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.yamleditor;

import de.jcup.yamleditor.UnpersistedMarkerHelper;
import de.jcup.yamleditor.YamlEditorActivator;
import de.jcup.yamleditor.preferences.YamlEditorPreferences;
import de.jcup.yamleditor.script.YamlError;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;

public class YamlEditorUtil {
    private static UnpersistedMarkerHelper scriptProblemMarkerHelper = new UnpersistedMarkerHelper("de.jcup.yamleditor.script.problem");

    public static YamlEditorPreferences getPreferences() {
        return YamlEditorPreferences.getInstance();
    }

    public static void logInfo(String info) {
        YamlEditorUtil.getLog().log((IStatus)new Status(1, "de.jcup.yamleditor", info));
    }

    public static void logWarning(String warning) {
        YamlEditorUtil.getLog().log((IStatus)new Status(2, "de.jcup.yamleditor", warning));
    }

    public static void logError(String error, Throwable t) {
        YamlEditorUtil.getLog().log((IStatus)new Status(4, "de.jcup.yamleditor", error, t));
    }

    public static void removeScriptErrors(IEditorPart editor) {
        if (editor == null) {
            return;
        }
        IEditorInput input = editor.getEditorInput();
        if (input == null) {
            return;
        }
        IResource editorResource = (IResource)input.getAdapter(IResource.class);
        if (editorResource == null) {
            return;
        }
        scriptProblemMarkerHelper.removeMarkers(editorResource);
    }

    public static void addScriptInfo(IEditorPart editor, int line, String message) {
        YamlEditorUtil.addScriptMarker(editor, line, 0, message, -1, -1);
    }

    public static void addScriptError(IEditorPart editor, int line, YamlError error, int severity) {
        if (error == null) {
            return;
        }
        String message = error.getMessage();
        int start = error.getStart();
        int end = error.getEnd();
        YamlEditorUtil.addScriptMarker(editor, line, severity, message, start, end);
    }

    private static void addScriptMarker(IEditorPart editor, int line, int severity, String message, int start, int end) {
        if (editor == null) {
            return;
        }
        IEditorInput input = editor.getEditorInput();
        if (input == null) {
            return;
        }
        IResource editorResource = (IResource)input.getAdapter(IResource.class);
        if (editorResource == null) {
            return;
        }
        try {
            scriptProblemMarkerHelper.createScriptMarker(severity, editorResource, message, line, start, end);
        }
        catch (CoreException e) {
            YamlEditorUtil.logError("Was not able to add error markers", e);
        }
    }

    private static ILog getLog() {
        ILog log = YamlEditorActivator.getDefault().getLog();
        return log;
    }
}

