/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.yamleditor;

import de.jcup.yamleditor.SimpleWordCodeCompletion;
import de.jcup.yamleditor.SimpleWordListBuilder;
import de.jcup.yamleditor.WordListBuilder;
import de.jcup.yamleditor.YamlEditorUtil;
import de.jcup.yamleditor.document.keywords.DocumentKeyWord;
import de.jcup.yamleditor.document.keywords.YamlBooleanKeyWords;
import de.jcup.yamleditor.document.keywords.YamlReservedWords;
import de.jcup.yamleditor.preferences.YamlEditorPreferenceConstants;
import de.jcup.yamleditor.preferences.YamlEditorPreferences;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.BoldStylerProvider;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension7;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class YamlEditorSimpleWordContentAssistProcessor
implements IContentAssistProcessor,
ICompletionListener {
    private static final SimpleWordListBuilder WORD_LIST_BUILDER = new SimpleWordListBuilder();
    private static final NoWordListBuilder NO_WORD_BUILDER = new NoWordListBuilder();
    private String errorMessage;
    private SimpleWordCodeCompletion simpleWordCompletion = new SimpleWordCodeCompletion();

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        IDocument document = viewer.getDocument();
        if (document == null) {
            return null;
        }
        String source = document.get();
        Set<String> words = this.simpleWordCompletion.calculate(source, offset);
        ICompletionProposal[] result = new ICompletionProposal[words.size()];
        int i = 0;
        for (String word : words) {
            result[i++] = new SimpleWordProposal(document, offset, word);
        }
        return result;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public boolean isAddingSpaceAtEnd() {
        return true;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public ICompletionListener getCompletionListener() {
        return this;
    }

    public void assistSessionStarted(ContentAssistEvent event) {
        this.simpleWordCompletion.reset();
        YamlEditorPreferences preferences = YamlEditorPreferences.getInstance();
        boolean addKeyWords = preferences.getBooleanPreference(YamlEditorPreferenceConstants.P_CODE_ASSIST_ADD_KEYWORDS);
        boolean addSimpleWords = preferences.getBooleanPreference(YamlEditorPreferenceConstants.P_CODE_ASSIST_ADD_SIMPLEWORDS);
        if (addSimpleWords) {
            this.simpleWordCompletion.setWordListBuilder(WORD_LIST_BUILDER);
        } else {
            this.simpleWordCompletion.setWordListBuilder(NO_WORD_BUILDER);
        }
        if (addKeyWords) {
            this.addAllYamlKeyWords();
        }
    }

    protected void addAllYamlKeyWords() {
        Enum keyword;
        Enum[] enumArray = YamlBooleanKeyWords.values();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            keyword = enumArray[n2];
            this.addKeyWord((DocumentKeyWord)((Object)keyword));
            ++n2;
        }
        enumArray = YamlReservedWords.values();
        n = enumArray.length;
        n2 = 0;
        while (n2 < n) {
            keyword = enumArray[n2];
            this.addKeyWord((DocumentKeyWord)((Object)keyword));
            ++n2;
        }
    }

    protected void addKeyWord(DocumentKeyWord keyword) {
        this.simpleWordCompletion.add(keyword.getText());
    }

    public void assistSessionEnded(ContentAssistEvent event) {
        this.simpleWordCompletion.reset();
    }

    public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
    }

    private static class NoWordListBuilder
    implements WordListBuilder {
        private List<String> list = new ArrayList<String>(0);

        private NoWordListBuilder() {
        }

        @Override
        public List<String> build(String source) {
            return this.list;
        }
    }

    private class SimpleWordProposal
    implements ICompletionProposal,
    ICompletionProposalExtension7 {
        private int offset;
        private String word;
        private int nextSelection;
        private StyledString styledString;
        private String textBefore;

        SimpleWordProposal(IDocument document, int offset, String word) {
            this.offset = offset;
            this.word = word;
            String source = document.get();
            this.textBefore = YamlEditorSimpleWordContentAssistProcessor.this.simpleWordCompletion.getTextbefore(source, offset);
        }

        public void apply(IDocument document) {
            String proposal = this.word;
            if (YamlEditorSimpleWordContentAssistProcessor.this.isAddingSpaceAtEnd()) {
                proposal = String.valueOf(proposal) + " ";
            }
            int zeroOffset = this.offset - this.textBefore.length();
            try {
                document.replace(zeroOffset, this.textBefore.length(), proposal);
                this.nextSelection = zeroOffset + proposal.length();
            }
            catch (BadLocationException e) {
                YamlEditorUtil.logError("Not able to replace by proposal:" + this.word + ", zero offset:" + zeroOffset + ", textBefore:" + this.textBefore, e);
            }
        }

        public Point getSelection(IDocument document) {
            Point point = new Point(this.nextSelection, 0);
            return point;
        }

        public String getAdditionalProposalInfo() {
            return null;
        }

        public String getDisplayString() {
            return this.word;
        }

        public Image getImage() {
            return null;
        }

        public IContextInformation getContextInformation() {
            return null;
        }

        public StyledString getStyledDisplayString(IDocument document, int offset, BoldStylerProvider boldStylerProvider) {
            if (this.styledString != null) {
                return this.styledString;
            }
            this.styledString = new StyledString();
            this.styledString.append(this.word);
            try {
                int enteredTextLength = this.textBefore.length();
                int indexOfTextBefore = this.word.toLowerCase().indexOf(this.textBefore.toLowerCase());
                if (indexOfTextBefore != -1) {
                    this.styledString.setStyle(indexOfTextBefore, enteredTextLength, boldStylerProvider.getBoldStyler());
                }
            }
            catch (RuntimeException e) {
                YamlEditorUtil.logError("Not able to set styles for proposal:" + this.word, e);
            }
            return this.styledString;
        }
    }
}

