/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.yamleditor;

import de.jcup.eclipse.commons.ui.ColorUtil;
import de.jcup.yamleditor.AdaptedFromEGradle;
import de.jcup.yamleditor.ColorManager;
import de.jcup.yamleditor.EclipseUtil;
import de.jcup.yamleditor.ReplaceTabBySpacesVerifyKeyListener;
import de.jcup.yamleditor.StatusMessageSupport;
import de.jcup.yamleditor.YamlBracketInsertionCompleter;
import de.jcup.yamleditor.YamlBracketsSupport;
import de.jcup.yamleditor.YamlEditorActivator;
import de.jcup.yamleditor.YamlEditorUtil;
import de.jcup.yamleditor.YamlMarginRulePainter;
import de.jcup.yamleditor.YamlSourceViewerConfiguration;
import de.jcup.yamleditor.document.YamlFileDocumentProvider;
import de.jcup.yamleditor.document.YamlTextFileDocumentProvider;
import de.jcup.yamleditor.outline.Item;
import de.jcup.yamleditor.outline.YamlEditorContentOutlinePage;
import de.jcup.yamleditor.outline.YamlEditorTreeContentProvider;
import de.jcup.yamleditor.outline.YamlQuickOutlineDialog;
import de.jcup.yamleditor.preferences.YamlEditorPreferenceConstants;
import de.jcup.yamleditor.preferences.YamlEditorPreferences;
import de.jcup.yamleditor.script.GoTemplateSanitizer;
import de.jcup.yamleditor.script.YamlError;
import de.jcup.yamleditor.script.YamlSanitizer;
import de.jcup.yamleditor.script.YamlScriptModel;
import de.jcup.yamleditor.script.YamlScriptModelBuilder;
import de.jcup.yamleditor.script.YamlScriptSortMemberSupport;
import de.jcup.yamleditor.script.formatter.DefaultYamlSourceFormatterConfig;
import de.jcup.yamleditor.script.formatter.YamlEdtiorFormatterScalarStyle;
import de.jcup.yamleditor.script.formatter.YamlSourceFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.SortedSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.CursorLinePainter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ISourceViewerExtension2;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.custom.CaretEvent;
import org.eclipse.swt.custom.CaretListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

@AdaptedFromEGradle
public class YamlEditor
extends TextEditor
implements StatusMessageSupport,
IResourceChangeListener {
    private static final YamlFileDocumentProvider YAML_FILE_DOCUMENT_PROVIDER = new YamlFileDocumentProvider();
    private static final YamlTextFileDocumentProvider YAML_TEXT_FILE_DOCUMENT_PROVIDER = new YamlTextFileDocumentProvider();
    public static final String EDITOR_ID = "yamleditor.editors.YamlEditor";
    public static final String EDITOR_CONTEXT_MENU_ID = "yamleditor.editors.YamlEditor.context";
    public static final String EDITOR_RULER_CONTEXT_MENU_ID = "yamleditor.editors.YamlEditor.context.ruler";
    private static final GoTemplateSanitizer GO_TEMPLATE_SANITIZER = new GoTemplateSanitizer();
    private YamlBracketsSupport bracketMatcher = new YamlBracketsSupport();
    private SourceViewerDecorationSupport additionalSourceViewerSupport;
    private YamlEditorContentOutlinePage outlinePage;
    private YamlScriptModelBuilder modelBuilder;
    private Object monitor = new Object();
    private boolean quickOutlineOpened;
    int lastCaretPosition;
    private String bgColor;
    private String fgColor;
    private boolean ignoreNextCaretMove;
    private ProjectionViewer viewer;
    private YamlMarginRulePainter marginRulePainter;
    private boolean codeFoldingEnabled;

    public YamlEditor() {
        this.setSourceViewerConfiguration((SourceViewerConfiguration)new YamlSourceViewerConfiguration((IAdaptable)this));
        this.modelBuilder = new YamlScriptModelBuilder();
        this.codeFoldingEnabled = YamlEditorPreferences.getInstance().isCodeFoldingEnabledOnEditorStartup();
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (this.isMarkerChangeForThisEditor(event)) {
            int severity = this.getSeverity();
            this.setTitleImageDependingOnSeverity(severity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openQuickOutline() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.quickOutlineOpened) {
                return;
            }
            this.quickOutlineOpened = true;
        }
        Shell shell = this.getEditorSite().getShell();
        String text = this.getDocumentText();
        YamlScriptModel model = this.modelBuilder.setSanitizers(this.calculateSanitizers()).setCalculateFoldings(false).build(text);
        YamlQuickOutlineDialog dialog = new YamlQuickOutlineDialog((IAdaptable)this, shell, "Quick outline");
        dialog.setInput(model);
        dialog.open();
        Object object2 = this.monitor;
        synchronized (object2) {
            this.quickOutlineOpened = false;
        }
    }

    void setTitleImageDependingOnSeverity(final int severity) {
        EclipseUtil.safeAsyncExec(new Runnable(){

            @Override
            public void run() {
                if (severity == 2) {
                    YamlEditor.this.setTitleImage(EclipseUtil.getImage("icons/yaml-editor-with-error.png", "de.jcup.yamleditor"));
                } else {
                    YamlEditor.this.setTitleImage(EclipseUtil.getImage("icons/yaml-editor.png", "de.jcup.yamleditor"));
                }
            }
        });
    }

    private int getSeverity() {
        IResource resource;
        block4: {
            IEditorInput editorInput = this.getEditorInput();
            if (editorInput == null) {
                return 0;
            }
            try {
                resource = ResourceUtil.getResource((IEditorInput)editorInput);
                if (resource != null) break block4;
                return 0;
            }
            catch (CoreException coreException) {
                return 0;
            }
        }
        int severity = resource.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 2);
        return severity;
    }

    private void addErrorMarkers(YamlScriptModel model, int severity) {
        if (model == null) {
            return;
        }
        IDocument document = this.getDocument();
        if (document == null) {
            return;
        }
        Collection<YamlError> errors = model.getErrors();
        for (YamlError error : errors) {
            int line;
            int startPos = error.getStart();
            try {
                line = document.getLineOfOffset(startPos);
            }
            catch (BadLocationException e) {
                EclipseUtil.logError("Cannot get line offset for " + startPos, e);
                line = 0;
            }
            YamlEditorUtil.addScriptError((IEditorPart)this, line, error, severity);
        }
    }

    @Override
    public void setErrorMessage(String message) {
        super.setStatusLineErrorMessage(message);
    }

    public YamlBracketsSupport getBracketMatcher() {
        return this.bracketMatcher;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        Control adapter = this.getAdapter(Control.class);
        if (adapter instanceof StyledText) {
            StyledText text = (StyledText)adapter;
            text.addCaretListener((CaretListener)new YamlEditorCaretListener());
        }
        this.activateYamlEditorContext();
        this.installAdditionalSourceViewerSupport();
        ISourceViewer sourceViewer = this.getSourceViewer();
        StyledText styledText = sourceViewer.getTextWidget();
        styledText.addKeyListener((KeyListener)new YamlBracketInsertionCompleter(this));
        this.handleInitialFolding();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        this.setTitleImageInitial();
    }

    private void handleInitialFolding() {
        ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
        if (!this.isCodeFoldingEnabled()) {
            return;
        }
        viewer.doOperation(19);
    }

    public YamlEditorContentOutlinePage getOutlinePage() {
        if (this.outlinePage == null) {
            this.outlinePage = new YamlEditorContentOutlinePage(this);
        }
        return this.outlinePage;
    }

    private void installAdditionalSourceViewerSupport() {
        this.additionalSourceViewerSupport = new SourceViewerDecorationSupport(this.getSourceViewer(), this.getOverviewRuler(), this.getAnnotationAccess(), this.getSharedColors());
        this.additionalSourceViewerSupport.setCharacterPairMatcher((ICharacterPairMatcher)this.bracketMatcher);
        this.additionalSourceViewerSupport.setMatchingCharacterPainterPreferenceKeys(YamlEditorPreferenceConstants.P_EDITOR_MATCHING_BRACKETS_ENABLED.getId(), YamlEditorPreferenceConstants.P_EDITOR_MATCHING_BRACKETS_COLOR.getId(), YamlEditorPreferenceConstants.P_EDITOR_HIGHLIGHT_BRACKET_AT_CARET_LOCATION.getId(), YamlEditorPreferenceConstants.P_EDITOR_ENCLOSING_BRACKETS.getId());
        IPreferenceStore preferenceStoreForDecorationSupport = YamlEditorUtil.getPreferences().getPreferenceStore();
        this.additionalSourceViewerSupport.install(preferenceStoreForDecorationSupport);
    }

    public void dispose() {
        super.dispose();
        if (this.additionalSourceViewerSupport != null) {
            this.additionalSourceViewerSupport.dispose();
        }
        if (this.bracketMatcher != null) {
            this.bracketMatcher.dispose();
            this.bracketMatcher = null;
        }
        if (this.marginRulePainter != null) {
            this.marginRulePainter.dispose();
            this.marginRulePainter = null;
        }
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public String getBackGroundColorAsWeb() {
        this.ensureColorsFetched();
        return this.bgColor;
    }

    public String getForeGroundColorAsWeb() {
        this.ensureColorsFetched();
        return this.fgColor;
    }

    private void ensureColorsFetched() {
        if (this.bgColor == null || this.fgColor == null) {
            ISourceViewer sourceViewer = this.getSourceViewer();
            if (sourceViewer == null) {
                return;
            }
            final StyledText textWidget = sourceViewer.getTextWidget();
            if (textWidget == null) {
                return;
            }
            EclipseUtil.getSafeDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    YamlEditor.this.bgColor = ColorUtil.convertToHexColor((Color)textWidget.getBackground());
                    YamlEditor.this.fgColor = ColorUtil.convertToHexColor((Color)textWidget.getForeground());
                }
            });
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (YamlEditor.class.equals(adapter)) {
            return (T)this;
        }
        if (IContentOutlinePage.class.equals(adapter)) {
            return (T)((Object)this.getOutlinePage());
        }
        if (ColorManager.class.equals(adapter)) {
            return (T)this.getColorManager();
        }
        if (IFile.class.equals(adapter)) {
            IEditorInput input = this.getEditorInput();
            if (input instanceof IFileEditorInput) {
                IFileEditorInput feditorInput = (IFileEditorInput)input;
                return (T)feditorInput.getFile();
            }
            return null;
        }
        if (ISourceViewer.class.equals(adapter)) {
            return (T)this.getSourceViewer();
        }
        if (StatusMessageSupport.class.equals(adapter)) {
            return (T)this;
        }
        if (ITreeContentProvider.class.equals(adapter) || YamlEditorTreeContentProvider.class.equals(adapter)) {
            if (this.outlinePage == null) {
                return null;
            }
            return (T)this.outlinePage.getContentProvider();
        }
        return (T)super.getAdapter(adapter);
    }

    public void gotoMatchingBracket() {
        this.bracketMatcher.gotoMatchingBracket((IAdaptable)this);
    }

    String getDocumentText() {
        IDocument doc = this.getDocument();
        if (doc == null) {
            return "";
        }
        return doc.get();
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        this.setDocumentProvider(this.resolveSharedDocumentProvider(input));
        super.doSetInput(input);
        this.rebuildOutline();
    }

    protected void editorSaved() {
        super.editorSaved();
        this.rebuildOutline();
    }

    public void rebuildOutline() {
        final String text = this.getDocumentText();
        EclipseUtil.safeAsyncExec(new Runnable(){

            @Override
            public void run() {
                YamlEditorUtil.removeScriptErrors((IEditorPart)YamlEditor.this);
                YamlScriptModel model = YamlEditor.this.modelBuilder.setSanitizers(YamlEditor.this.calculateSanitizers()).setCalculateFoldings(YamlEditor.this.isCodeFoldingEnabled()).build(text);
                YamlEditor.this.getOutlinePage().rebuild(model);
                YamlEditor.this.updateFoldingStructure(model.getFoldingPositions());
                if (model.hasErrors()) {
                    YamlEditor.this.addErrorMarkers(model, 2);
                }
                for (String message : model.getMessages()) {
                    YamlEditorUtil.addScriptInfo((IEditorPart)YamlEditor.this, -1, message);
                }
            }
        });
    }

    protected YamlSanitizer[] calculateSanitizers() {
        if (this.isGoTemplateSupportEnabled()) {
            return new YamlSanitizer[]{GO_TEMPLATE_SANITIZER};
        }
        return null;
    }

    public boolean isGoTemplateSupportEnabled() {
        return YamlEditorPreferences.getInstance().isGoTemplateSupportEnabled();
    }

    private void setTitleImageInitial() {
        IResource resource = this.resolveResource();
        if (resource != null) {
            try {
                int maxSeverity = resource.findMaxProblemSeverity(null, true, 2);
                this.setTitleImageDependingOnSeverity(maxSeverity);
            }
            catch (CoreException coreException) {}
        }
    }

    private IResource resolveResource() {
        IEditorInput input = this.getEditorInput();
        if (!(input instanceof IFileEditorInput)) {
            return null;
        }
        return ((IFileEditorInput)input).getFile();
    }

    private boolean isMarkerChangeForThisEditor(IResourceChangeEvent event) {
        IResource resource = ResourceUtil.getResource((IEditorInput)this.getEditorInput());
        if (resource == null) {
            return false;
        }
        IPath path = resource.getFullPath();
        if (path == null) {
            return false;
        }
        IResourceDelta eventDelta = event.getDelta();
        if (eventDelta == null) {
            return false;
        }
        IResourceDelta delta = eventDelta.findMember(path);
        if (delta == null) {
            return false;
        }
        boolean isMarkerChangeForThisResource = (delta.getFlags() & 0x20000) != 0;
        return isMarkerChangeForThisResource;
    }

    private IDocumentProvider resolveSharedDocumentProvider(IEditorInput input) {
        if (input instanceof FileStoreEditorInput) {
            return YAML_TEXT_FILE_DOCUMENT_PROVIDER;
        }
        return YAML_FILE_DOCUMENT_PROVIDER;
    }

    public IDocument getDocument() {
        return this.getDocumentProvider().getDocument((Object)this.getEditorInput());
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        if (site == null) {
            return;
        }
        IWorkbenchPage page = site.getPage();
        if (page == null) {
            return;
        }
        page.showActionSet("org.eclipse.ui.edit.text.actionSet.presentation");
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        this.fAnnotationAccess = this.getAnnotationAccess();
        this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        this.viewer = new ProjectionViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)this.viewer);
        YamlMarginRulePainter.MarginPaintSetup setup = new YamlMarginRulePainter.MarginPaintSetup();
        this.marginRulePainter = new YamlMarginRulePainter((ITextViewer)this.viewer, setup);
        RGB lineColor = YamlEditorPreferences.getInstance().getColor(YamlEditorPreferenceConstants.P_EDITOR_MARGIN_RULE_LINE_COLOR);
        setup.lineColor = this.getColorManager().getColor(lineColor);
        setup.lineStyle = 2;
        this.viewer.getTextWidget().addVerifyKeyListener((VerifyKeyListener)new ReplaceTabBySpacesVerifyKeyListener(this));
        CursorLinePainter cursorLinePainter = new CursorLinePainter((ITextViewer)this.viewer);
        this.viewer.addPainter((IPainter)cursorLinePainter);
        this.viewer.addPainter((IPainter)this.marginRulePainter);
        ProjectionSupport support = new ProjectionSupport(this.viewer, this.getAnnotationAccess(), this.getSharedColors());
        support.install();
        this.getSourceViewerDecorationSupport((ISourceViewer)this.viewer);
        return this.viewer;
    }

    protected void updateFoldingStructure(SortedSet<YamlScriptModel.FoldingPosition> positions) {
        if (!this.isCodeFoldingEnabled()) {
            return;
        }
        ProjectionAnnotationModel annotationModel = this.viewer.getProjectionAnnotationModel();
        if (annotationModel == null) {
            return;
        }
        HashMap<Position, ProjectionAnnotation> allAnnotations = new HashMap<Position, ProjectionAnnotation>();
        Iterator it = annotationModel.getAnnotationIterator();
        while (it.hasNext()) {
            Annotation v = (Annotation)it.next();
            if (!(v instanceof ProjectionAnnotation)) continue;
            ProjectionAnnotation anno = (ProjectionAnnotation)v;
            allAnnotations.put(annotationModel.getPosition((Annotation)anno), anno);
        }
        HashMap<ProjectionAnnotation, Position> newAnnotations = new HashMap<ProjectionAnnotation, Position>();
        ArrayList deletedAnnotationsList = new ArrayList(allAnnotations.values());
        ArrayList<ProjectionAnnotation> modifiedAnnotationsList = new ArrayList<ProjectionAnnotation>();
        for (YamlScriptModel.FoldingPosition foldingPos : positions) {
            ProjectionAnnotation annotation = new ProjectionAnnotation();
            Position pos = new Position(foldingPos.getOffset());
            pos.length = foldingPos.getLength();
            ProjectionAnnotation found = (ProjectionAnnotation)allAnnotations.get(pos);
            if (found != null) {
                deletedAnnotationsList.remove(found);
                continue;
            }
            LinkedHashSet keySet = new LinkedHashSet(allAnnotations.keySet());
            for (Position key : keySet) {
                boolean foundSamePosButModified;
                boolean bl = foundSamePosButModified = key.getOffset() == pos.getOffset() && key.getLength() != pos.getLength();
                if (!foundSamePosButModified) continue;
                ProjectionAnnotation annoBefore = (ProjectionAnnotation)allAnnotations.get(key);
                allAnnotations.remove(key);
                if (annoBefore == null) continue;
                annotation = annoBefore;
                deletedAnnotationsList.remove(annoBefore);
                modifiedAnnotationsList.add(annoBefore);
                break;
            }
            allAnnotations.put(pos, annotation);
            newAnnotations.put(annotation, pos);
        }
        Annotation[] deletions = deletedAnnotationsList.toArray(new Annotation[deletedAnnotationsList.size()]);
        Annotation[] modifications = modifiedAnnotationsList.toArray(new Annotation[modifiedAnnotationsList.size()]);
        annotationModel.modifyAnnotations(deletions, newAnnotations, modifications);
    }

    public boolean isCodeFoldingEnabled() {
        return this.codeFoldingEnabled;
    }

    public void moveMargineLineIfNecessary() {
        int caretXPosition = this.viewer.getTextWidget().getCaret().getLocation().x;
        this.marginRulePainter.setX(caretXPosition);
    }

    protected String[] collectContextMenuPreferencePages() {
        String[] inheritedPages;
        ArrayList<String> list = new ArrayList<String>();
        list.add("yamleditor.eclipse.gradleeditor.preferences.YamlEditorEditorPreferencePage");
        list.add("yamleditor.eclipse.gradleeditor.preferences.YamlEditorEditorSyntaxColorPreferencePage");
        list.add("yamleditor.eclipse.gradleeditor.preferences.YamlEditorTaskTagsPreferencePage");
        String[] stringArray = inheritedPages = super.collectContextMenuPreferencePages();
        int n = inheritedPages.length;
        int n2 = 0;
        while (n2 < n) {
            String inheritedPage = stringArray[n2];
            if (inheritedPage != null) {
                list.add(inheritedPage);
            }
            ++n2;
        }
        return list.toArray(new String[list.size()]);
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.setEditorContextMenuId(EDITOR_CONTEXT_MENU_ID);
        this.setRulerContextMenuId(EDITOR_RULER_CONTEXT_MENU_ID);
    }

    private void activateYamlEditorContext() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        if (contextService != null) {
            contextService.activateContext(EDITOR_CONTEXT_MENU_ID);
        }
    }

    private ColorManager getColorManager() {
        return YamlEditorActivator.getDefault().getColorManager();
    }

    public void handleColorSettingsChanged() {
        ISourceViewer viewer = this.getSourceViewer();
        SourceViewerConfiguration configuration = this.getSourceViewerConfiguration();
        if (viewer instanceof ISourceViewerExtension2) {
            ISourceViewerExtension2 viewerExtension2 = (ISourceViewerExtension2)viewer;
            viewerExtension2.unconfigure();
            if (configuration instanceof YamlSourceViewerConfiguration) {
                YamlSourceViewerConfiguration gconf = (YamlSourceViewerConfiguration)configuration;
                gconf.updateTextScannerDefaultColorToken();
            }
            viewer.configure(configuration);
        }
    }

    public void toggleComment() {
        ISelection selection = this.getSelectionProvider().getSelection();
        if (!(selection instanceof TextSelection)) {
            return;
        }
        IDocumentProvider dp = this.getDocumentProvider();
        IDocument doc = dp.getDocument((Object)this.getEditorInput());
        TextSelection ts = (TextSelection)selection;
        int startLine = ts.getStartLine();
        int endLine = ts.getEndLine();
        int i = startLine;
        while (i <= endLine) {
            try {
                IRegion info = doc.getLineInformation(i);
                int offset = info.getOffset();
                String line = doc.get(info.getOffset(), info.getLength());
                StringBuilder foundCode = new StringBuilder();
                StringBuilder whitespaces = new StringBuilder();
                int j = 0;
                while (j < line.length()) {
                    char ch = line.charAt(j);
                    if (Character.isWhitespace(ch)) {
                        if (foundCode.length() == 0) {
                            whitespaces.append(ch);
                        }
                    } else {
                        foundCode.append(ch);
                    }
                    if (foundCode.length() > 0) break;
                    ++j;
                }
                int whitespaceOffsetAdd = whitespaces.length();
                if ("#".equals(foundCode.toString())) {
                    doc.replace(offset + whitespaceOffsetAdd, 2, "");
                } else {
                    doc.replace(offset, 0, "# ");
                }
            }
            catch (BadLocationException badLocationException) {}
            ++i;
        }
        try {
            int selectionStartOffset = doc.getLineOffset(startLine);
            int endlineOffset = doc.getLineOffset(endLine);
            int endlineLength = doc.getLineLength(endLine);
            int endlineLastPartOffset = endlineOffset + endlineLength;
            int length = endlineLastPartOffset - selectionStartOffset;
            TextSelection newSelection = new TextSelection(selectionStartOffset, length);
            this.getSelectionProvider().setSelection((ISelection)newSelection);
        }
        catch (BadLocationException badLocationException) {}
    }

    public void openSelectedTreeItemInEditor(ISelection selection, boolean grabFocus) {
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection ss = (IStructuredSelection)selection;
        Object firstElement = ss.getFirstElement();
        if (!(firstElement instanceof Item)) {
            return;
        }
        Item item = (Item)firstElement;
        int offset = item.getOffset();
        int length = item.getLength();
        if (length == 0) {
            length = 1;
        }
        this.ignoreNextCaretMove = true;
        this.selectAndReveal(offset, length);
        if (grabFocus) {
            this.setFocus();
        }
    }

    public Item getItemAtCarretPosition() {
        return this.getItemAt(this.lastCaretPosition);
    }

    public Item getItemAt(int offset) {
        if (this.outlinePage == null) {
            return null;
        }
        YamlEditorTreeContentProvider contentProvider = this.outlinePage.getContentProvider();
        if (contentProvider == null) {
            return null;
        }
        Item item = contentProvider.tryToFindByOffset(offset);
        return item;
    }

    public YamlEditorPreferences getPreferences() {
        return YamlEditorPreferences.getInstance();
    }

    public void collapseAllFoldings() {
        this.setCollapseStateForAllFoldings(true);
    }

    protected void setCollapseStateForAllFoldings(boolean collapse) {
        ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
        if (collapse) {
            viewer.doOperation(21);
        } else {
            viewer.doOperation(20);
        }
    }

    public void expandAllFoldings() {
        this.setCollapseStateForAllFoldings(false);
    }

    public void toggleFolding() {
        boolean old = this.codeFoldingEnabled;
        this.codeFoldingEnabled = !old;
        ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
        if (this.codeFoldingEnabled) {
            viewer.enableProjection();
            this.rebuildOutline();
        } else {
            viewer.disableProjection();
        }
    }

    public void formatSourceCode() {
        String code = this.getDocumentText();
        String sourceFormatterScalarStyleId = this.getPreferences().getSourceFormatterScalarStyleId();
        YamlEdtiorFormatterScalarStyle scalarStyle = YamlEdtiorFormatterScalarStyle.fromId(sourceFormatterScalarStyleId);
        DefaultYamlSourceFormatterConfig config = new DefaultYamlSourceFormatterConfig();
        config.setIndent(this.getPreferences().getSourceFormatterIndent());
        config.setMaxLineLength(this.getPreferences().getSourceFormatterLineLength());
        config.setScalarStyle(scalarStyle);
        config.setPreventTypeConversion(this.getPreferences().isPreventingTypeConversionOnFormat());
        config.setRestoreCommentsEnabled(this.getPreferences().isSourceFormatterRescuingComments());
        String output = new YamlSourceFormatter().format(code, config);
        this.getDocument().set(output);
    }

    public void sortAscending() {
        boolean confirmed;
        String yamlContent = this.getDocument().get();
        if (yamlContent == null) {
            return;
        }
        YamlScriptSortMemberSupport support = new YamlScriptSortMemberSupport();
        if (support.isHavingCommentsInside(yamlContent) && !(confirmed = MessageDialog.openConfirm((Shell)de.jcup.eclipse.commons.ui.EclipseUtil.getActiveWorkbenchShell(), (String)"Warning", (String)"It seems you have got comments inside your yaml file.\nAt the moment sorting will destroy comments!\n\nDo you still want to sort?"))) {
            return;
        }
        this.getDocument().set(support.sortAscending(yamlContent));
        this.rebuildOutline();
    }

    private class YamlEditorCaretListener
    implements CaretListener {
        private YamlEditorCaretListener() {
        }

        public void caretMoved(CaretEvent event) {
            if (event == null) {
                return;
            }
            YamlEditor.this.lastCaretPosition = event.caretOffset;
            if (YamlEditor.this.ignoreNextCaretMove) {
                YamlEditor.this.ignoreNextCaretMove = false;
                return;
            }
            if (YamlEditor.this.outlinePage == null) {
                return;
            }
            YamlEditor.this.outlinePage.onEditorCaretMoved(event.caretOffset);
        }
    }
}

