/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.yamleditor;

import de.jcup.yamleditor.StatusMessageSupport;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.DefaultCharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;

public final class YamlBracketsSupport
extends DefaultCharacterPairMatcher {
    protected static final char[] BRACKETS = new char[]{'{', '}', '(', ')', '[', ']', '<', '>'};
    private List<IRegion> previousSelections;

    public YamlBracketsSupport() {
        super(BRACKETS, "__dftl_partitioning", true);
    }

    public void gotoMatchingBracket(IAdaptable adaptable) {
        int direction;
        IRegion region;
        ISourceViewer sourceViewer = (ISourceViewer)adaptable.getAdapter(ISourceViewer.class);
        StatusMessageSupport statusMessageSupport = (StatusMessageSupport)adaptable.getAdapter(StatusMessageSupport.class);
        if (sourceViewer == null) {
            return;
        }
        if (statusMessageSupport == null) {
            return;
        }
        IDocument document = sourceViewer.getDocument();
        if (document == null) {
            return;
        }
        IRegion selection = this.getSignedSelection(sourceViewer);
        if (this.previousSelections == null) {
            this.initializePreviousSelectionList();
        }
        if ((region = this.match(document, selection.getOffset(), selection.getLength())) == null) {
            region = this.findEnclosingPeerCharacters(document, selection.getOffset(), selection.getLength());
            this.initializePreviousSelectionList();
            this.previousSelections.add(selection);
        } else if (this.previousSelections.size() == 2) {
            if (!selection.equals(this.previousSelections.get(1))) {
                this.initializePreviousSelectionList();
            }
        } else if (this.previousSelections.size() == 3) {
            if (selection.equals(this.previousSelections.get(2)) && !selection.equals(this.previousSelections.get(0))) {
                IRegion originalSelection = this.previousSelections.get(0);
                sourceViewer.setSelectedRange(originalSelection.getOffset(), originalSelection.getLength());
                sourceViewer.revealRange(originalSelection.getOffset(), originalSelection.getLength());
                this.initializePreviousSelectionList();
                return;
            }
            this.initializePreviousSelectionList();
        }
        if (region == null) {
            statusMessageSupport.setErrorMessage("Can't go to matching bracket");
            sourceViewer.getTextWidget().getDisplay().beep();
            return;
        }
        int offset = region.getOffset();
        int length = region.getLength();
        if (length < 1) {
            return;
        }
        int anchor = this.getAnchor();
        int targetOffset = anchor == 0 ? offset + 1 : offset + length - 1;
        boolean visible = false;
        if (sourceViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)sourceViewer;
            visible = extension.modelOffset2WidgetOffset(targetOffset) > -1;
        } else {
            IRegion visibleRegion = sourceViewer.getVisibleRegion();
            boolean bl = visible = targetOffset >= visibleRegion.getOffset() && targetOffset <= visibleRegion.getOffset() + visibleRegion.getLength();
        }
        if (!visible) {
            statusMessageSupport.setErrorMessage("Matching bracket outside selected type");
            sourceViewer.getTextWidget().getDisplay().beep();
            return;
        }
        int adjustment = this.getOffsetAdjustment(document, selection.getOffset() + selection.getLength(), selection.getLength());
        targetOffset += adjustment;
        int n = selection.getLength() == 0 ? 0 : (direction = selection.getLength() > 0 ? 1 : -1);
        if (this.previousSelections.size() == 1 && direction < 0) {
            ++targetOffset;
        }
        if (this.previousSelections.size() > 0) {
            this.previousSelections.add((IRegion)new Region(targetOffset, direction));
        }
        sourceViewer.setSelectedRange(targetOffset, direction);
        sourceViewer.revealRange(targetOffset, direction);
    }

    protected int getOffsetAdjustment(IDocument document, int offset, int length) {
        block7: {
            block6: {
                if (length == 0 || Math.abs(length) > 1) {
                    return 0;
                }
                try {
                    if (length >= 0) break block6;
                    if (this.isOpeningBracket(document.getChar(offset))) {
                        return 1;
                    }
                    break block7;
                }
                catch (BadLocationException badLocationException) {}
            }
            if (this.isClosingBracket(document.getChar(offset - 1))) {
                return -1;
            }
        }
        return 0;
    }

    protected final IRegion getSignedSelection(ISourceViewer sourceViewer) {
        Point viewerSelection = sourceViewer.getSelectedRange();
        StyledText text = sourceViewer.getTextWidget();
        Point selection = text.getSelectionRange();
        if (text.getCaretOffset() == selection.x) {
            viewerSelection.x += viewerSelection.y;
            viewerSelection.y = -viewerSelection.y;
        }
        return new Region(viewerSelection.x, viewerSelection.y);
    }

    protected boolean isClosingBracket(char character) {
        int i = 1;
        while (i < BRACKETS.length) {
            if (character == BRACKETS[i]) {
                return true;
            }
            i += 2;
        }
        return false;
    }

    protected boolean isOpeningBracket(char character) {
        int i = 0;
        while (i < BRACKETS.length) {
            if (character == BRACKETS[i]) {
                return true;
            }
            i += 2;
        }
        return false;
    }

    private void initializePreviousSelectionList() {
        this.previousSelections = new ArrayList<IRegion>(3);
    }
}

