/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.yamleditor;

import de.jcup.yamleditor.YamlEditor;
import de.jcup.yamleditor.YamlEditorUtil;
import de.jcup.yamleditor.preferences.YamlEditorPreferenceConstants;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;

class YamlBracketInsertionCompleter
extends KeyAdapter {
    private final YamlEditor yamlEditor;

    YamlBracketInsertionCompleter(YamlEditor yamlEditor) {
        this.yamlEditor = yamlEditor;
    }

    public void keyReleased(KeyEvent e) {
        InsertClosingBracketsSupport insertClosingBracketsSupport = this.getInsertionSupport(e);
        if (insertClosingBracketsSupport == null) {
            return;
        }
        ISelectionProvider selectionProvider = this.yamlEditor.getSelectionProvider();
        if (selectionProvider == null) {
            return;
        }
        ISelection selection = selectionProvider.getSelection();
        if (!(selection instanceof ITextSelection)) {
            return;
        }
        boolean enabled = YamlEditorUtil.getPreferences().getBooleanPreference(YamlEditorPreferenceConstants.P_EDITOR_AUTO_CREATE_END_BRACKETS);
        if (!enabled) {
            return;
        }
        ITextSelection textSelection = (ITextSelection)selection;
        int offset = textSelection.getOffset();
        try {
            IDocument document = this.yamlEditor.getDocument();
            if (document == null) {
                return;
            }
            insertClosingBracketsSupport.insertClosingBrackets(document, selectionProvider, offset);
        }
        catch (BadLocationException badLocationException) {
            return;
        }
    }

    protected InsertClosingBracketsSupport getInsertionSupport(KeyEvent e) {
        if (e.character == '[') {
            return new EdgeBracketInsertionSupport();
        }
        if (e.character == '{') {
            return new CurlyBracketInsertionSupport();
        }
        return null;
    }

    private class CurlyBracketInsertionSupport
    extends InsertClosingBracketsSupport {
        private CurlyBracketInsertionSupport() {
        }

        @Override
        protected void insertClosingBrackets(IDocument document, ISelectionProvider selectionProvider, int offset) throws BadLocationException {
            document.replace(offset - 1, 1, "{}");
            selectionProvider.setSelection((ISelection)new TextSelection(offset, 0));
        }
    }

    private class EdgeBracketInsertionSupport
    extends InsertClosingBracketsSupport {
        private EdgeBracketInsertionSupport() {
        }

        @Override
        protected void insertClosingBrackets(IDocument document, ISelectionProvider selectionProvider, int offset) throws BadLocationException {
            document.replace(offset - 1, 1, "[]");
            selectionProvider.setSelection((ISelection)new TextSelection(offset, 0));
        }
    }

    private abstract class InsertClosingBracketsSupport {
        private InsertClosingBracketsSupport() {
        }

        protected abstract void insertClosingBrackets(IDocument var1, ISelectionProvider var2, int var3) throws BadLocationException;
    }
}

