/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.yamleditor;

import de.jcup.yamleditor.AbstractMarkerHelper;
import de.jcup.yamleditor.AdaptedFromEGradle;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;

@AdaptedFromEGradle
public class UnpersistedMarkerHelper
extends AbstractMarkerHelper {
    private List<IMarker> markerRegistry;

    public UnpersistedMarkerHelper(String markerType) {
        this.markerType = markerType;
        this.markerRegistry = new ArrayList<IMarker>();
    }

    @Override
    protected void handleMarkerAdded(IMarker marker) {
        if (marker == null) {
            return;
        }
        this.markerRegistry.add(marker);
    }

    public void removeAllRegisteredMarkers() throws CoreException {
        ArrayList<IMarker> workingCopy = new ArrayList<IMarker>(this.markerRegistry);
        for (IMarker marker : workingCopy) {
            String type = null;
            boolean markerExists = marker.exists();
            if (markerExists) {
                try {
                    type = marker.getType();
                }
                catch (CoreException coreException) {
                    markerExists = false;
                }
                if ("org.eclipse.core.resources.taskmarker".equals(type)) continue;
            }
            this.markerRegistry.remove(marker);
            if (!markerExists) continue;
            marker.delete();
        }
    }

    public boolean hasRegisteredMarkers() {
        return !this.markerRegistry.isEmpty();
    }
}

