/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.yamleditor;

import de.jcup.yamleditor.WordListBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SimpleWordListBuilder
implements WordListBuilder {
    @Override
    public List<String> build(String source) {
        if (source == null || source.isEmpty()) {
            return Collections.emptyList();
        }
        String[] allWords = source.split("[\\s,;:.!()\\?=]");
        ArrayList<String> list = new ArrayList<String>();
        String[] stringArray = allWords;
        int n = allWords.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            String transformed = this.transformIfNecessary(word);
            if (transformed != null && !transformed.isEmpty()) {
                list.add(transformed);
            }
            ++n2;
        }
        return list;
    }

    private String transformIfNecessary(String word) {
        if (word == null) {
            return null;
        }
        if (word.isEmpty()) {
            return null;
        }
        String transformed = word;
        if (transformed.startsWith("#")) {
            transformed = this.dropFirstChar(transformed);
        }
        if (transformed.startsWith("'")) {
            transformed = this.dropFirstChar(transformed);
        }
        if (transformed.startsWith("\"")) {
            transformed = this.dropFirstChar(transformed);
        }
        if (transformed.endsWith("'")) {
            transformed = this.dropLastChar(transformed);
        }
        if (transformed.endsWith("\"")) {
            transformed = this.dropLastChar(transformed);
        }
        return transformed;
    }

    private String dropLastChar(String transformed) {
        return transformed.substring(0, transformed.length() - 1);
    }

    private String dropFirstChar(String transformed) {
        transformed = transformed.substring(1);
        return transformed;
    }
}

