/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.yamleditor;

import de.jcup.yamleditor.SimpleWordListBuilder;
import de.jcup.yamleditor.WordListBuilder;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class SimpleWordCodeCompletion {
    private Set<String> additionalWordsCache = new HashSet<String>();
    private SortedSet<String> allWordsCache = new TreeSet<String>();
    private WordListBuilder wordListBuilder;

    public void add(String word) {
        if (word == null) {
            return;
        }
        if (!this.allWordsCache.isEmpty()) {
            this.allWordsCache.clear();
        }
        this.additionalWordsCache.add(word.trim());
    }

    public Set<String> calculate(String source, int offset) {
        this.rebuildCacheIfNecessary(source);
        if (offset == 0) {
            return Collections.unmodifiableSet(this.allWordsCache);
        }
        String wanted = this.getTextbefore(source, offset);
        return this.filter(this.allWordsCache, wanted);
    }

    public String getTextbefore(String source, int offset) {
        if (source == null || source.isEmpty()) {
            return "";
        }
        if (offset <= 0) {
            return "";
        }
        int sourceLength = source.length();
        if (offset > sourceLength) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int current = offset - 1;
        boolean ongoing = false;
        while (current >= 0) {
            char c;
            boolean bl = ongoing = !Character.isWhitespace(c = source.charAt(current--));
            if (ongoing) {
                sb.insert(0, c);
            }
            if (ongoing) continue;
        }
        return sb.toString();
    }

    public SimpleWordCodeCompletion reset() {
        this.allWordsCache.clear();
        this.additionalWordsCache.clear();
        return this;
    }

    Set<String> filter(SortedSet<String> allWords, String wanted) {
        if (wanted == null || wanted.isEmpty()) {
            return allWords;
        }
        LinkedHashSet<String> filtered = new LinkedHashSet<String>();
        LinkedHashSet<String> addAfterEnd = new LinkedHashSet<String>();
        String wantedLowerCase = wanted.toLowerCase();
        for (String word : allWords) {
            String wordLowerCase = word.toLowerCase();
            if (wordLowerCase.startsWith(wantedLowerCase)) {
                filtered.add(word);
                continue;
            }
            if (wordLowerCase.indexOf(wantedLowerCase) == -1) continue;
            addAfterEnd.add(word);
        }
        filtered.addAll(addAfterEnd);
        filtered.remove(wanted);
        return filtered;
    }

    private void rebuildCacheIfNecessary(String source) {
        if (this.allWordsCache.isEmpty()) {
            this.allWordsCache.addAll(this.additionalWordsCache);
            this.allWordsCache.addAll(this.getWordListBuilder().build(source));
            this.allWordsCache.remove("");
        }
    }

    public WordListBuilder getWordListBuilder() {
        if (this.wordListBuilder == null) {
            this.wordListBuilder = new SimpleWordListBuilder();
        }
        return this.wordListBuilder;
    }

    public void setWordListBuilder(WordListBuilder wordListBuilder) {
        this.wordListBuilder = wordListBuilder;
    }
}

