/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.yamleditor;

import de.jcup.yamleditor.EclipseUtil;
import de.jcup.yamleditor.YamlEditor;
import de.jcup.yamleditor.preferences.YamlEditorPreferences;
import java.util.ArrayList;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.texteditor.IDocumentProvider;

class ReplaceTabBySpacesVerifyKeyListener
implements VerifyKeyListener {
    private final YamlEditor yamlEditor;

    ReplaceTabBySpacesVerifyKeyListener(YamlEditor yamlEditor) {
        if (yamlEditor == null) {
            throw new IllegalArgumentException();
        }
        this.yamlEditor = yamlEditor;
    }

    public void verifyKey(final VerifyEvent event) {
        if (event.character == '\t') {
            event.doit = false;
            EclipseUtil.safeAsyncExec(new Runnable(){

                @Override
                public void run() {
                    boolean doOutdent;
                    ISelection selection = ReplaceTabBySpacesVerifyKeyListener.this.yamlEditor.getSelectionProvider().getSelection();
                    if (!(selection instanceof ITextSelection)) {
                        return;
                    }
                    ITextSelection ts = (ITextSelection)selection;
                    IDocumentProvider dp = ReplaceTabBySpacesVerifyKeyListener.this.yamlEditor.getDocumentProvider();
                    IDocument doc = dp.getDocument((Object)ReplaceTabBySpacesVerifyKeyListener.this.yamlEditor.getEditorInput());
                    int offset = ts.getOffset();
                    if (offset == -1) {
                        offset = ((ReplaceTabBySpacesVerifyKeyListener)ReplaceTabBySpacesVerifyKeyListener.this).yamlEditor.lastCaretPosition;
                    }
                    boolean isMultiline = ts.getStartLine() != -1 && ts.getEndLine() > ts.getStartLine();
                    boolean doIndent = event.stateMask == 0;
                    boolean bl = doOutdent = (event.stateMask & 0x20000) == 131072;
                    if (!doIndent && !doOutdent) {
                        return;
                    }
                    try {
                        int numSpaces = YamlEditorPreferences.getInstance().getAmountOfSpacesToReplaceTab();
                        if (numSpaces < 1) {
                            return;
                        }
                        String tabReplacement = ReplaceTabBySpacesVerifyKeyListener.this.createTabReplacement(numSpaces);
                        if (isMultiline) {
                            this.handleMultiLineSelection(ts, doc, doIndent, numSpaces, tabReplacement);
                        } else {
                            this.handleSingleLineSelection(ts, doc, offset, doIndent, numSpaces, tabReplacement);
                        }
                    }
                    catch (BadLocationException e) {
                        EclipseUtil.logError("Cannot insert tab replacement at " + offset, e);
                    }
                }

                private void handleSingleLineSelection(ITextSelection ts, IDocument doc, int offset, boolean doIndent, int numSpaces, String tabReplacement) throws BadLocationException {
                    int newCaretPosition;
                    if (doIndent) {
                        doc.replace(offset, ts.getLength(), tabReplacement);
                        newCaretPosition = offset + numSpaces;
                    } else {
                        int offsetBlockStart = doc.getLineOffset(ts.getStartLine());
                        int offsetBlockEnd = doc.getLineOffset(ts.getEndLine()) + doc.getLineLength(ts.getEndLine());
                        int lengthBlock = offsetBlockEnd - offsetBlockStart;
                        if (lengthBlock <= 0) {
                            return;
                        }
                        String line = doc.get(offsetBlockStart, lengthBlock);
                        String replacement = ReplaceTabBySpacesVerifyKeyListener.this.outdent(line, numSpaces);
                        doc.replace(offsetBlockStart, lengthBlock, replacement);
                        newCaretPosition = offset > offsetBlockStart + numSpaces ? offset - numSpaces : offsetBlockStart;
                    }
                    Control control = ReplaceTabBySpacesVerifyKeyListener.this.yamlEditor.getAdapter(Control.class);
                    if (control instanceof StyledText) {
                        StyledText t = (StyledText)control;
                        t.setCaretOffset(newCaretPosition);
                    }
                }

                private void handleMultiLineSelection(ITextSelection ts, IDocument doc, boolean doIndent, int numSpaces, String tabReplacement) throws BadLocationException {
                    int offsetBlockStart = doc.getLineOffset(ts.getStartLine());
                    int offsetBlockEnd = doc.getLineOffset(ts.getEndLine()) + doc.getLineLength(ts.getEndLine());
                    int lengthBlock = offsetBlockEnd - offsetBlockStart;
                    if (lengthBlock <= 0) {
                        return;
                    }
                    String lineBlock = doc.get(offsetBlockStart, lengthBlock);
                    String[] lines = lineBlock.split("\\r?\\n");
                    ArrayList<String> replacement = new ArrayList<String>();
                    String[] stringArray = lines;
                    int n = lines.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String line = stringArray[n2];
                        String newLine = null;
                        newLine = doIndent ? ReplaceTabBySpacesVerifyKeyListener.this.indent(line, tabReplacement) : ReplaceTabBySpacesVerifyKeyListener.this.outdent(line, numSpaces);
                        replacement.add(newLine);
                        ++n2;
                    }
                    String strReplacement = String.join((CharSequence)"\n", replacement);
                    doc.replace(offsetBlockStart, lengthBlock - 1, strReplacement);
                    ReplaceTabBySpacesVerifyKeyListener.this.yamlEditor.selectAndReveal(offsetBlockStart, strReplacement.length());
                }
            });
        }
    }

    private String createTabReplacement(int spaces) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < spaces) {
            sb.append(' ');
            ++i;
        }
        return sb.toString();
    }

    private String outdent(String line, int spaces) {
        int numLeadingSpaces = 0;
        int i = 0;
        while (i < spaces && i < line.length()) {
            if (line.charAt(i) != ' ') break;
            ++numLeadingSpaces;
            ++i;
        }
        return line.substring(Math.min(numLeadingSpaces, spaces));
    }

    private String indent(String line, String toInsert) {
        return String.valueOf(toInsert) + line;
    }
}

