/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.yamleditor;

import de.jcup.yamleditor.YamlEditorActivator;
import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class EclipseUtil {
    public static ImageDescriptor createImageDescriptor(String path, String pluginId) {
        if (path == null) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
        if (pluginId == null) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
        Bundle bundle = Platform.getBundle((String)pluginId);
        if (bundle == null) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
        URL url = FileLocator.find((Bundle)bundle, (IPath)new Path(path), null);
        ImageDescriptor imageDesc = ImageDescriptor.createFromURL((URL)url);
        return imageDesc;
    }

    public static IEditorPart getActiveEditor() {
        IWorkbenchPage page = EclipseUtil.getActivePage();
        IEditorPart activeEditor = page.getActiveEditor();
        return activeEditor;
    }

    public static IWorkbenchPage getActivePage() {
        if (!PlatformUI.isWorkbenchRunning()) {
            return null;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return window.getActivePage();
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbench workbench = EclipseUtil.getWorkbench();
        if (workbench == null) {
            return null;
        }
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        Shell shell = window.getShell();
        return shell;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        IWorkbench workbench = EclipseUtil.getWorkbench();
        if (workbench == null) {
            return null;
        }
        IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
        if (workbenchWindow != null) {
            return workbenchWindow;
        }
        WorkbenchWindowRunnable wwr = new WorkbenchWindowRunnable();
        EclipseUtil.getSafeDisplay().syncExec((Runnable)wwr);
        return wwr.workbenchWindowFromUI;
    }

    public static IProject[] getAllProjects() {
        IProject[] projects = EclipseUtil.getWorkspace().getRoot().getProjects();
        return projects;
    }

    public static Image getImage(String path, String pluginId) {
        ImageRegistry imageRegistry = EclipseUtil.getImageRegistry();
        if (imageRegistry == null) {
            return null;
        }
        Image image = imageRegistry.get(path);
        if (image == null) {
            ImageDescriptor imageDesc = EclipseUtil.createImageDescriptor(path, pluginId);
            image = imageDesc.createImage();
            if (image == null) {
                image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
            }
            imageRegistry.put(path, image);
        }
        return image;
    }

    public static Display getSafeDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static void safeAsyncExec(Runnable runnable) {
        EclipseUtil.getSafeDisplay().asyncExec(runnable);
    }

    public static void throwCoreException(String message) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "de.jcup.yamleditor", message));
    }

    public static void throwCoreException(String message, Exception e) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "de.jcup.yamleditor", message, (Throwable)e));
    }

    public static String resolveMessageIfNotSet(String message, Throwable cause) {
        if (message == null) {
            message = cause == null ? "Unknown" : cause.getMessage();
        }
        return message;
    }

    private static ImageRegistry getImageRegistry() {
        YamlEditorActivator mainActivator = YamlEditorActivator.getDefault();
        if (mainActivator == null) {
            return null;
        }
        return mainActivator.getImageRegistry();
    }

    private static IWorkbench getWorkbench() {
        if (!PlatformUI.isWorkbenchRunning()) {
            return null;
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        return workbench;
    }

    public static void logError(String error, Throwable t) {
        EclipseUtil.getLog().log((IStatus)new Status(4, "de.jcup.yamleditor", error, t));
    }

    private static ILog getLog() {
        ILog log = YamlEditorActivator.getDefault().getLog();
        return log;
    }

    private static class WorkbenchWindowRunnable
    implements Runnable {
        IWorkbenchWindow workbenchWindowFromUI;

        private WorkbenchWindowRunnable() {
        }

        @Override
        public void run() {
            IWorkbench workbench = EclipseUtil.getWorkbench();
            if (workbench == null) {
                return;
            }
            this.workbenchWindowFromUI = workbench.getActiveWorkbenchWindow();
        }
    }
}

