/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.yamleditor;

import de.jcup.yamleditor.AdaptedFromEGradle;
import de.jcup.yamleditor.Matcher;
import java.util.ArrayList;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreePathContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

@AdaptedFromEGradle
public abstract class AbstractTreeViewerFilter<T>
extends ViewerFilter {
    private Matcher<T> matcher;

    public void setMatcher(Matcher<T> matcher) {
        this.matcher = matcher;
    }

    public Object[] filter(Viewer viewer, TreePath parentPath, Object[] elements) {
        int size = elements.length;
        ArrayList<Object> out = new ArrayList<Object>(size);
        int i = 0;
        while (i < size) {
            Object element = elements[i];
            if (this.selectTreePath(viewer, parentPath, element)) {
                out.add(element);
            }
            ++i;
        }
        return out.toArray();
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        return this.selectTreePath(viewer, new TreePath(new Object[]{parentElement}), element);
    }

    private boolean selectTreePath(Viewer viewer, TreePath parentPath, Object element) {
        int i = 0;
        while (i < parentPath.getSegmentCount() - 1) {
            if (element.equals(parentPath.getSegment(i))) {
                return false;
            }
            ++i;
        }
        if (!(viewer instanceof TreeViewer)) {
            return true;
        }
        if (this.matcher == null) {
            return true;
        }
        TreeViewer treeViewer = (TreeViewer)viewer;
        Boolean matchingResult = this.isMatchingOrNull(element);
        if (matchingResult != null) {
            return matchingResult;
        }
        return this.hasUnfilteredChild(treeViewer, parentPath, element);
    }

    Boolean isMatchingOrNull(Object element) {
        Object item = null;
        try {
            item = element;
        }
        catch (ClassCastException classCastException) {
            return Boolean.FALSE;
        }
        if (this.matcher.matches(item)) {
            return Boolean.TRUE;
        }
        return null;
    }

    private boolean hasUnfilteredChild(TreeViewer viewer, TreePath parentPath, Object element) {
        Object[] children;
        TreePath elementPath = parentPath.createChildPath(element);
        IContentProvider contentProvider = viewer.getContentProvider();
        Object[] objectArray = children = contentProvider instanceof ITreePathContentProvider ? ((ITreePathContentProvider)contentProvider).getChildren(elementPath) : ((ITreeContentProvider)contentProvider).getChildren(element);
        if (children == null || children.length == 0) {
            return false;
        }
        int i = 0;
        while (i < children.length) {
            if (this.selectTreePath((Viewer)viewer, elementPath, children[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

