/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.yamleditor;

import de.jcup.yamleditor.AdaptedFromEGradle;
import de.jcup.yamleditor.EclipseUtil;
import de.jcup.yamleditor.SimpleStringUtils;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.texteditor.MarkerUtilities;

@AdaptedFromEGradle
abstract class AbstractMarkerHelper {
    protected String markerType;

    AbstractMarkerHelper() {
    }

    private IMarker findMarker(IResource resource, String message, int lineNumber, String type) throws CoreException {
        IMarker[] marker = resource.findMarkers(type, true, 0);
        int i = 0;
        while (i < marker.length) {
            IMarker currentMarker = marker[i];
            if (currentMarker != null) {
                boolean sameMessageAndLineNr;
                Object lineNrAttribute = currentMarker.getAttribute("lineNumber");
                String markerLineNumber = null;
                if (lineNrAttribute != null) {
                    markerLineNumber = lineNrAttribute.toString();
                }
                Object messageAttribute = currentMarker.getAttribute("message");
                String markerMessage = null;
                if (messageAttribute != null) {
                    markerMessage = messageAttribute.toString();
                }
                boolean bl = sameMessageAndLineNr = SimpleStringUtils.equals(markerLineNumber, String.valueOf(lineNumber)) && SimpleStringUtils.equals(markerMessage, message);
                if (sameMessageAndLineNr) {
                    return currentMarker;
                }
            }
            ++i;
        }
        return null;
    }

    public void createScriptMarker(int severity, IResource resource, String message, int lineNumber, int charStart, int charEnd) throws CoreException {
        this.createMarker(resource, message, lineNumber, this.markerType, severity, charStart, charEnd, -1);
    }

    public void createTaskMarker(int priority, IResource resource, String message, int lineNumber, int charStart, int charEnd) throws CoreException {
        this.createMarker(resource, message, lineNumber, this.markerType, -1, charStart, charEnd, priority);
    }

    private void createMarker(IResource resource, String message, int lineNumber, String markerType, int severity, int charStart, int charEnd, int priority) throws CoreException {
        IMarker marker;
        if (lineNumber <= 0) {
            lineNumber = 1;
        }
        if ((marker = this.findMarker(resource, message, lineNumber, markerType)) == null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (severity != -1) {
                map.put("severity", new Integer(severity));
            }
            if (priority != -1) {
                map.put("priority", new Integer(priority));
            }
            map.put("location", resource.getFullPath().toOSString());
            map.put("message", message);
            MarkerUtilities.setLineNumber(map, (int)lineNumber);
            MarkerUtilities.setMessage(map, (String)message);
            if (charStart != -1) {
                MarkerUtilities.setCharStart(map, (int)charStart);
                MarkerUtilities.setCharEnd(map, (int)charEnd);
            }
            this.internalCreateMarker(resource, map, markerType);
        }
    }

    private void internalCreateMarker(final IResource resource, final Map<String, Object> attributes, final String markerType) throws CoreException {
        IWorkspaceRunnable r = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IMarker marker = resource.createMarker(markerType);
                marker.setAttributes(attributes);
                AbstractMarkerHelper.this.handleMarkerAdded(marker);
            }
        };
        resource.getWorkspace().run(r, null, 1, null);
    }

    protected void handleMarkerAdded(IMarker marker) {
    }

    public void removeMarkers(IResource resource) {
        if (resource == null) {
            return;
        }
        this.removeMarkers(resource, this.markerType);
    }

    private IMarker[] removeMarkers(IResource resource, String markerType) {
        if (resource == null) {
            return new IMarker[0];
        }
        IMarker[] tasks = null;
        if (resource != null) {
            try {
                tasks = resource.findMarkers(markerType, true, 0);
                int i = 0;
                while (i < tasks.length) {
                    tasks[i].delete();
                    ++i;
                }
            }
            catch (CoreException e) {
                EclipseUtil.logError("Was not able to delete markers", e);
            }
        }
        if (tasks == null) {
            tasks = new IMarker[]{};
        }
        return tasks;
    }
}

