/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.util;

import de.jcup.asciidoctoreditor.AsciiDoctorEditor;
import de.jcup.asciidoctoreditor.AsciiDoctorEditorActivator;
import de.jcup.asciidoctoreditor.preferences.AsciiDoctorEditorPreferences;
import de.jcup.asciidoctoreditor.script.ASPMarker;
import de.jcup.asciidoctoreditor.script.AsciiDoctorMarker;
import de.jcup.asciidoctoreditor.ui.UnpersistedMarkerHelper;
import de.jcup.asciidoctoreditor.util.EclipseUtil;
import java.io.File;
import java.net.URL;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

public class AsciiDoctorEditorUtil {
    private static final IProgressMonitor NULL_MONITOR = new NullProgressMonitor();
    private static UnpersistedMarkerHelper validationMarkerHelper = new UnpersistedMarkerHelper("de.jcup.asciidoctoreditor.script.problem");
    private static UnpersistedMarkerHelper aspMarkerHelper = new UnpersistedMarkerHelper("de.jcup.asciidoctoreditor.asp.marker");

    public static AsciiDoctorEditorPreferences getPreferences() {
        return AsciiDoctorEditorPreferences.getInstance();
    }

    public static final AsciiDoctorEditor findActiveAsciidoctorEditorOrNull() {
        IEditorPart editor = AsciiDoctorEditorUtil.findActiveEditorOrNull();
        if (editor instanceof AsciiDoctorEditor) {
            return (AsciiDoctorEditor)editor;
        }
        return null;
    }

    public static final IEditorPart findActiveEditorOrNull() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return null;
        }
        IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return null;
        }
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        if (activePage == null) {
            return null;
        }
        IEditorPart editor = activePage.getActiveEditor();
        return editor;
    }

    public static Image getImage(String path) {
        return EclipseUtil.getImage(path, "de.jcup.asciidoctoreditor");
    }

    public static ImageDescriptor createImageDescriptor(String path) {
        return EclipseUtil.createImageDescriptor(path, "de.jcup.asciidoctoreditor");
    }

    public static File toFile(IPath path) throws CoreException {
        if (path == null) {
            return null;
        }
        IFileStore fileStore = FileBuffers.getFileStoreAtLocation((IPath)path);
        if (fileStore == null) {
            return null;
        }
        File file = null;
        file = fileStore.toLocalFile(0, NULL_MONITOR);
        return file;
    }

    public static File toFile(IResource resource) throws CoreException {
        if (resource == null) {
            return AsciiDoctorEditorUtil.toFile(null);
        }
        return AsciiDoctorEditorUtil.toFile(resource.getLocation());
    }

    public static void logInfo(String info) {
        AsciiDoctorEditorUtil.getLog().log((IStatus)new Status(1, "de.jcup.asciidoctoreditor", info));
    }

    public static void logWarning(String warning) {
        AsciiDoctorEditorUtil.getLog().log((IStatus)new Status(2, "de.jcup.asciidoctoreditor", warning));
    }

    public static void logError(String error, Throwable t) {
        AsciiDoctorEditorUtil.getLog().log((IStatus)new Status(4, "de.jcup.asciidoctoreditor", error, t));
    }

    public static void removeScriptErrors(IEditorPart editor) {
        if (editor == null) {
            return;
        }
        IEditorInput input = editor.getEditorInput();
        if (input == null) {
            return;
        }
        IResource editorResource = (IResource)input.getAdapter(IResource.class);
        if (editorResource == null) {
            return;
        }
        validationMarkerHelper.removeMarkers(editorResource);
        aspMarkerHelper.removeMarkers(editorResource);
    }

    public static void addAsciiDoctorMarker(IEditorPart editor, int line, AsciiDoctorMarker marker, int severity) {
        if (editor == null) {
            return;
        }
        if (marker == null) {
            return;
        }
        IEditorInput input = editor.getEditorInput();
        if (input == null) {
            return;
        }
        IResource editorResource = (IResource)input.getAdapter(IResource.class);
        AsciiDoctorEditorUtil.addAsciiDoctorMarker(line, marker, severity, editorResource);
    }

    public static void addAsciiDoctorMarker(int line, AsciiDoctorMarker marker, int severity, IResource editorResource) {
        if (editorResource == null) {
            return;
        }
        if (marker == null) {
            return;
        }
        try {
            if (marker instanceof ASPMarker) {
                aspMarkerHelper.createScriptMarker(severity, editorResource, marker.getMessage(), line, marker.getStart(), marker.getEnd());
            } else {
                validationMarkerHelper.createScriptMarker(severity, editorResource, marker.getMessage(), line, marker.getStart(), marker.getEnd());
            }
        }
        catch (CoreException e) {
            AsciiDoctorEditorUtil.logError("Was not able to add error markers", e);
        }
    }

    private static ILog getLog() {
        ILog log = AsciiDoctorEditorActivator.getDefault().getLog();
        return log;
    }

    public static void openFileInExternalBrowser(File tempAdFile) {
        try {
            URL url = tempAdFile.toURI().toURL();
            IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
            IWebBrowser externalBrowser = browserSupport.getExternalBrowser();
            externalBrowser.openURL(url);
        }
        catch (Exception ex) {
            AsciiDoctorEditorUtil.logError("Was not able to open url in external browser", ex);
        }
    }

    public static boolean isAsciidocFileExtension(String extension) {
        if (extension == null) {
            return false;
        }
        switch (extension) {
            case "asciidoc": 
            case "ad": 
            case "asc": 
            case "adoc": {
                return true;
            }
        }
        return false;
    }
}

