/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.ui;

import de.jcup.asciidoctoreditor.AdaptedFromEGradle;
import de.jcup.asciidoctoreditor.FilterPatternMatcher;
import de.jcup.asciidoctoreditor.outline.FallbackOutlineContentProvider;
import de.jcup.asciidoctoreditor.ui.AbstractQuickDialog;
import de.jcup.asciidoctoreditor.ui.AbstractTreeViewerFilter;
import de.jcup.asciidoctoreditor.util.EclipseUtil;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.UIJob;

@AdaptedFromEGradle
public abstract class AbstractFilterableTreeQuickDialog<T>
extends AbstractQuickDialog
implements IDoubleClickListener {
    private static final boolean DO_SHOW_DIALOG = true;
    private static final int DEFAULT_X = 600;
    private static final int DEFAULT_Y = 400;
    private Object input;
    private Object monitor = new Object();
    private Text text;
    private TreeViewer treeViewer;
    private String currentUsedFilterText;
    private ITreeContentProvider contentProvider;
    private AbstractTreeViewerFilter<T> textFilter;
    private FilterPatternMatcher<T> matcher;
    private int minWidth;
    private int minHeight;

    public AbstractFilterableTreeQuickDialog(IAdaptable adaptable, Shell parent, String title, int minWidth, int minHeight, String infoText) {
        super(parent, 16, true, true, true, true, true, title, infoText);
        this.minWidth = minWidth;
        this.minHeight = minHeight;
        this.contentProvider = this.createTreeContentProvider(adaptable);
        if (this.contentProvider == null) {
            this.contentProvider = new FallbackOutlineContentProvider();
        }
    }

    protected abstract ITreeContentProvider createTreeContentProvider(IAdaptable var1);

    public void doubleClick(DoubleClickEvent event) {
        ISelection selection = event.getSelection();
        this.openSelectionAndCloseDialog(selection);
    }

    private final void openSelectionAndCloseDialog(ISelection selection) {
        this.openSelection(selection);
        this.close();
    }

    private final void openSelection(ISelection selection) {
        String filterText = null;
        if (this.text != null && !this.text.isDisposed()) {
            filterText = this.text.getText();
        }
        this.openSelectionImpl(selection, filterText);
    }

    protected abstract void openSelectionImpl(ISelection var1, String var2);

    public final void setInput(Object input) {
        this.input = input;
    }

    @Override
    protected final void beforeRunEventLoop() {
        this.treeViewer.setInput(this.input);
        this.text.setFocus();
        T item = this.getInitialSelectedItem();
        if (item == null) {
            return;
        }
        StructuredSelection startSelection = new StructuredSelection(item);
        this.treeViewer.setSelection((ISelection)startSelection, true);
    }

    protected abstract T getInitialSelectedItem();

    @Override
    protected boolean canHandleShellCloseEvent() {
        return true;
    }

    protected final Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        boolean isWin32 = Util.isWindows();
        GridLayoutFactory.fillDefaults().extendedMargins(isWin32 ? 0 : 3, 3, 2, 2).applyTo(composite);
        IBaseLabelProvider labelProvider = this.createLabelProvider();
        if (labelProvider == null) {
            labelProvider = new LabelProvider();
        }
        int style = 0;
        Tree tree = new Tree(composite, 4 | style & 0xFFFFFFFD);
        GridData gridData = new GridData(1808);
        gridData.heightHint = tree.getItemHeight() * 12;
        gridData.verticalAlignment = 128;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        tree.setLayoutData((Object)gridData);
        this.treeViewer = new TreeViewer(tree);
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.textFilter = this.createFilter();
        this.matcher = this.createItemMatcher();
        this.textFilter.setMatcher(this.matcher);
        this.treeViewer.setFilters(new ViewerFilter[]{this.textFilter});
        tree.setLayoutData((Object)gridData);
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.treeViewer.addDoubleClickListener((IDoubleClickListener)this);
        this.treeViewer.setLabelProvider(labelProvider);
        return composite;
    }

    protected abstract FilterPatternMatcher<T> createItemMatcher();

    protected abstract IBaseLabelProvider createLabelProvider();

    protected abstract AbstractTreeViewerFilter<T> createFilter();

    protected Control createInfoTextArea(Composite parent) {
        return super.createInfoTextArea(parent);
    }

    protected Control createTitleControl(Composite parent) {
        this.text = new Text(parent, 0);
        GridData textLayoutData = new GridData();
        textLayoutData.horizontalAlignment = 4;
        textLayoutData.verticalAlignment = 4;
        textLayoutData.grabExcessHorizontalSpace = true;
        textLayoutData.grabExcessVerticalSpace = false;
        textLayoutData.horizontalSpan = 2;
        this.text.setLayoutData((Object)textLayoutData);
        this.text.addKeyListener((KeyListener)new FilterKeyListener());
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(1, 1).applyTo((Control)this.text);
        return this.text;
    }

    protected final IDialogSettings getDialogSettings() {
        AbstractUIPlugin activator = this.getUIPlugin();
        if (activator == null) {
            return null;
        }
        return activator.getDialogSettings();
    }

    protected abstract AbstractUIPlugin getUIPlugin();

    protected Point getInitialLocation(Point initialSize) {
        IDialogSettings dialogSettings = this.getDialogSettings();
        if (dialogSettings == null) {
            return new Point(600, 400);
        }
        return super.getInitialLocation(initialSize);
    }

    protected Point getInitialSize() {
        IDialogSettings dialogSettings = this.getDialogSettings();
        if (dialogSettings == null) {
            return new Point(this.minWidth, this.minHeight);
        }
        Point point = super.getInitialSize();
        if (point.x < this.minWidth) {
            point.x = this.minWidth;
        }
        if (point.y < this.minHeight) {
            point.y = this.minHeight;
        }
        return point;
    }

    protected boolean hasInfoArea() {
        return super.hasInfoArea();
    }

    private void rebuildFilterTextPattern() {
        if (this.text == null) {
            return;
        }
        if (this.text.isDisposed()) {
            return;
        }
        String filterText = this.text.getText();
        if (filterText == null ? this.currentUsedFilterText == null : filterText.equals(this.currentUsedFilterText)) {
            return;
        }
        this.matcher.setFilterText(filterText);
        this.currentUsedFilterText = filterText;
    }

    private class FilterKeyListener
    extends KeyAdapter {
        private boolean dirty;

        private FilterKeyListener() {
        }

        public void keyPressed(KeyEvent event) {
            if (event.keyCode == 0x1000002) {
                Tree tree = AbstractFilterableTreeQuickDialog.this.treeViewer.getTree();
                if (tree.isDisposed()) {
                    return;
                }
                if (tree.isFocusControl()) {
                    return;
                }
                tree.setFocus();
                return;
            }
            if (event.character == '\r') {
                ISelection selection = AbstractFilterableTreeQuickDialog.this.treeViewer.getSelection();
                AbstractFilterableTreeQuickDialog.this.openSelectionAndCloseDialog(selection);
                return;
            }
            boolean allowedChar = false;
            allowedChar = allowedChar || event.character == '*';
            allowedChar = allowedChar || event.character == '(';
            allowedChar = allowedChar || event.character == ')';
            allowedChar = allowedChar || Character.isJavaIdentifierPart(event.character);
            boolean bl = allowedChar = allowedChar || Character.isWhitespace(event.character);
            if (!allowedChar) {
                event.doit = false;
                return;
            }
            if (AbstractFilterableTreeQuickDialog.this.treeViewer == null) {
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void keyReleased(KeyEvent e) {
            String filterText = AbstractFilterableTreeQuickDialog.this.text.getText();
            if (filterText != null && filterText.equals(AbstractFilterableTreeQuickDialog.this.currentUsedFilterText)) {
                return;
            }
            Object object = AbstractFilterableTreeQuickDialog.this.monitor;
            synchronized (object) {
                if (this.dirty) {
                    return;
                }
                this.dirty = true;
            }
            UIJob job = new UIJob("Rebuild asciidoctor editor quick outline"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    try {
                        AbstractFilterableTreeQuickDialog.this.rebuildFilterTextPattern();
                        if (AbstractFilterableTreeQuickDialog.this.treeViewer.getControl().isDisposed()) {
                            return Status.CANCEL_STATUS;
                        }
                        AbstractFilterableTreeQuickDialog.this.treeViewer.refresh();
                        if (AbstractFilterableTreeQuickDialog.this.matcher.hasFilterPattern()) {
                            AbstractFilterableTreeQuickDialog.this.treeViewer.expandAll();
                            FilterKeyListener.this.selectFirstMaching();
                        }
                    }
                    catch (RuntimeException e) {
                        EclipseUtil.logError("quick dialog failure", e);
                    }
                    FilterKeyListener.this.dirty = false;
                    return Status.OK_STATUS;
                }
            };
            job.schedule(400L);
        }

        protected void selectFirstMaching() {
            this.selectfirstMatching(this.getTreeContentProvider().getElements(null));
        }

        private boolean selectfirstMatching(Object[] elements) {
            if (AbstractFilterableTreeQuickDialog.this.treeViewer == null) {
                return false;
            }
            if (AbstractFilterableTreeQuickDialog.this.textFilter == null) {
                return false;
            }
            if (elements == null) {
                return false;
            }
            int i = 0;
            while (i < elements.length) {
                Object element = elements[i];
                if (Boolean.TRUE.equals(AbstractFilterableTreeQuickDialog.this.textFilter.isMatchingOrNull(element))) {
                    StructuredSelection selection = new StructuredSelection(element);
                    AbstractFilterableTreeQuickDialog.this.treeViewer.setSelection((ISelection)selection, true);
                    return true;
                }
                ITreeContentProvider contentProvider = this.getTreeContentProvider();
                Object[] children = contentProvider.getChildren(element);
                boolean selectionDone = this.selectfirstMatching(children);
                if (selectionDone) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private ITreeContentProvider getTreeContentProvider() {
            return AbstractFilterableTreeQuickDialog.this.contentProvider;
        }
    }
}

