/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.toolbar;

import de.jcup.asciidoctoreditor.AsciiDoctorEditor;
import de.jcup.asciidoctoreditor.toolbar.InsertTextAction;
import de.jcup.asciidoctoreditor.toolbar.NewTableDialog;
import de.jcup.asciidoctoreditor.util.EclipseUtil;
import org.eclipse.jface.resource.ImageDescriptor;

public class NewTableInsertAction
extends InsertTextAction {
    private static final String GAP = "   ";
    private static ImageDescriptor IMG_NEW_TABLE = NewTableInsertAction.createToolbarImageDescriptor("table.gif");

    public NewTableInsertAction(AsciiDoctorEditor editor) {
        super(editor, "Insert a table", IMG_NEW_TABLE);
    }

    @Override
    protected void beforeInsert(InsertTextAction.InsertTextContext context) {
        NewTableDialog dialog = new NewTableDialog(EclipseUtil.getActiveWorkbenchShell());
        int result = dialog.open();
        if (result == 1) {
            context.canceled = true;
            return;
        }
        TableData data = new TableData();
        data.rows = dialog.getRows();
        data.columns = dialog.getColumns();
        context.data = data;
    }

    @Override
    protected String getInsertText(InsertTextAction.InsertTextContext context) {
        TableData data = (TableData)context.data;
        StringBuilder sb = new StringBuilder();
        sb.append("[options=\"header\",cols=\"");
        int i = 0;
        while (i < data.columns) {
            sb.append("1");
            if (i < data.columns - 1) {
                sb.append(",");
            }
            ++i;
        }
        sb.append("\"]\n");
        sb.append("|===");
        sb.append("\n");
        this.appendColumns(data, sb, 0, "Head");
        sb.append("//");
        int charsNeededForHeadline = data.columns * (GAP.length() + 6) - 5;
        int i2 = 0;
        while (i2 < charsNeededForHeadline) {
            sb.append("-");
            ++i2;
        }
        sb.append("\n");
        int row = 1;
        while (row <= data.rows) {
            this.appendColumns(data, sb, row, "Row");
            ++row;
        }
        sb.append("|===");
        sb.append("\n");
        return sb.toString();
    }

    private void appendColumns(TableData data, StringBuilder sb, int row, String text) {
        int column = 1;
        while (column <= data.columns) {
            sb.append("|");
            sb.append(text);
            if (row > 0) {
                sb.append(row);
            }
            sb.append(this.toColumnName(column));
            sb.append(GAP);
            ++column;
        }
        sb.append("\n");
    }

    private String toColumnName(int column) {
        if (column == 0) {
            return "";
        }
        if (column > 26) {
            return "-";
        }
        return "" + (char)(column + 64);
    }

    private class TableData {
        int rows;
        int columns;

        private TableData() {
        }
    }
}

