/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.toolbar;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;

public class NewTableDialog
extends TitleAreaDialog {
    private Spinner spinnerColumns;
    private int rows;
    private int columns;
    private Spinner spinnerRows;

    public NewTableDialog(Shell parentShell) {
        super(parentShell);
    }

    public void create() {
        super.create();
        this.setTitle("Insert a new table into document");
        this.setMessage("Select your wanted table data and press OK", 1);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(2, false);
        container.setLayout((Layout)layout);
        this.createSpinnerColumns(container);
        this.createSpinnerRows(container);
        return area;
    }

    private void createSpinnerColumns(Composite container) {
        Label lblSpinnerCols = new Label(container, 0);
        lblSpinnerCols.setText("Columns");
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.spinnerColumns = new Spinner(container, 2048);
        this.spinnerColumns.setValues(3, 1, 30, 0, 1, 10);
        this.spinnerColumns.setLayoutData((Object)data);
    }

    private void createSpinnerRows(Composite container) {
        Label lblSpinnerRows = new Label(container, 0);
        lblSpinnerRows.setText("Rows");
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.spinnerRows = new Spinner(container, 2048);
        this.spinnerRows.setValues(3, 1, 100, 0, 1, 10);
        this.spinnerRows.setLayoutData((Object)data);
    }

    protected boolean isResizable() {
        return true;
    }

    private void saveInput() {
        this.rows = this.spinnerRows.getSelection();
        this.columns = this.spinnerColumns.getSelection();
    }

    protected void okPressed() {
        this.saveInput();
        super.okPressed();
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.columns;
    }
}

