/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.toolbar;

import de.jcup.asciidoctoreditor.AsciiDoctorEditor;
import de.jcup.asciidoctoreditor.toolbar.InsertTextAction;
import de.jcup.asciidoctoreditor.toolbar.LinkType;
import de.jcup.asciidoctoreditor.toolbar.NewLinkDialog;
import de.jcup.asciidoctoreditor.util.EclipseUtil;
import de.jcup.eclipse.commons.SimpleStringUtils;
import org.eclipse.jface.resource.ImageDescriptor;

public class NewLinkInsertAction
extends InsertTextAction {
    private static ImageDescriptor IMG_NEW_LINK = NewLinkInsertAction.createToolbarImageDescriptor("link.png");

    public NewLinkInsertAction(AsciiDoctorEditor editor) {
        super(editor, "Insert a link", IMG_NEW_LINK);
    }

    @Override
    protected String getInsertText(InsertTextAction.InsertTextContext context) {
        LinkData data = (LinkData)context.data;
        StringBuilder sb = new StringBuilder();
        switch (data.linkType) {
            case EXTERNAL: {
                sb.append(data.target);
                if (SimpleStringUtils.isEmpty((String)data.linkText)) break;
                sb.append("[");
                sb.append(data.linkText);
                sb.append("]");
                break;
            }
            case INTERNAL_CROSS_REFERENCE: {
                sb.append("<<");
                sb.append(data.target);
                if (!SimpleStringUtils.isEmpty((String)data.linkText)) {
                    sb.append(',');
                    sb.append(data.linkText);
                }
                sb.append(">>");
                break;
            }
            default: {
                sb.append("Unsupported blockType:" + (Object)((Object)data.linkType));
            }
        }
        sb.append(" ");
        context.nextOffset = context.selectedOffset + sb.length();
        return sb.toString();
    }

    @Override
    protected void beforeInsert(InsertTextAction.InsertTextContext context) {
        NewLinkDialog dialog = new NewLinkDialog(EclipseUtil.getActiveWorkbenchShell());
        int result = dialog.open();
        if (result == 1) {
            context.canceled = true;
            return;
        }
        LinkData data = new LinkData();
        data.linkText = dialog.getLinkText();
        data.target = dialog.getTarget();
        data.linkType = dialog.getLinkType();
        context.data = data;
    }

    private class LinkData {
        String linkText;
        String target;
        LinkType linkType;

        private LinkData() {
        }
    }
}

