/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.toolbar;

import de.jcup.asciidoctoreditor.toolbar.LinkType;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewLinkDialog
extends TitleAreaDialog {
    private Text txtLinkText;
    private Text txtTarget;
    private String target;
    private String linkText;
    private Button btnLinkExternal;
    private Button btnLinkInternalCrossReference;
    private LinkType linkType;

    public NewLinkDialog(Shell parentShell) {
        super(parentShell);
    }

    public void create() {
        super.create();
        this.setTitle("Insert a new link into document");
        this.setMessage("Select your wanted link data and press OK", 1);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(2, false);
        container.setLayout((Layout)layout);
        this.createTypeSelection(container);
        this.createLabelTextfields(container);
        this.createTargetTextFields(container);
        return area;
    }

    private void createTypeSelection(Composite container) {
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.horizontalSpan = 2;
        Group linkTypeGroup = new Group(container, 0);
        linkTypeGroup.setText("Link blockType:");
        linkTypeGroup.setLayout((Layout)new RowLayout(512));
        linkTypeGroup.setLayoutData((Object)data);
        this.btnLinkExternal = new Button((Composite)linkTypeGroup, 16);
        this.btnLinkExternal.setText("External");
        this.btnLinkExternal.setSelection(false);
        this.btnLinkInternalCrossReference = new Button((Composite)linkTypeGroup, 16);
        this.btnLinkInternalCrossReference.setText("Internal cross reference");
        this.btnLinkInternalCrossReference.setToolTipText("Internal cross reference, enter 'abc-xyz' when you want to refer '[[abc-xyz]]' inside your document)");
        this.btnLinkInternalCrossReference.setSelection(true);
    }

    private void createLabelTextfields(Composite container) {
        Label lblLinkTextLabel = new Label(container, 0);
        lblLinkTextLabel.setText("Link text");
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.txtLinkText = new Text(container, 2048);
        this.txtLinkText.setLayoutData((Object)data);
    }

    private void createTargetTextFields(Composite container) {
        Label lblTarget = new Label(container, 0);
        lblTarget.setText("Link target");
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.txtTarget = new Text(container, 2048);
        this.txtTarget.setLayoutData((Object)data);
    }

    protected boolean isResizable() {
        return true;
    }

    private void saveInput() {
        this.target = this.txtTarget.getText();
        this.linkText = this.txtLinkText.getText();
        if (this.btnLinkExternal.getSelection()) {
            this.linkType = LinkType.EXTERNAL;
        } else if (this.btnLinkInternalCrossReference.getSelection()) {
            this.linkType = LinkType.INTERNAL_CROSS_REFERENCE;
        }
    }

    protected void okPressed() {
        this.saveInput();
        super.okPressed();
    }

    public String getTarget() {
        return this.target;
    }

    public String getLinkText() {
        return this.linkText;
    }

    public LinkType getLinkType() {
        return this.linkType;
    }
}

