/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.toolbar;

import de.jcup.asciidoctoreditor.AsciiDoctorEditor;
import de.jcup.asciidoctoreditor.toolbar.ToolbarAction;
import de.jcup.asciidoctoreditor.util.AsciiDoctorEditorUtil;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.texteditor.IDocumentProvider;

public abstract class InsertTextAction
extends ToolbarAction {
    protected abstract String getInsertText(InsertTextContext var1);

    protected InsertTextAction(AsciiDoctorEditor editor, String text, ImageDescriptor descriptor) {
        super(editor);
        this.setText(text);
        this.setImageDescriptor(descriptor);
    }

    public void run() {
        InsertTextContext context = new InsertTextContext();
        AsciiDoctorEditor editor = this.asciiDoctorEditor;
        ISelection selection = editor.getSelectionProvider().getSelection();
        if (selection instanceof ITextSelection) {
            ITextSelection ts = (ITextSelection)selection;
            context.selectedText = ts.getText();
            context.selectedLength = ts.getLength();
            context.selectedOffset = ts.getOffset();
        }
        this.beforeInsert(context);
        if (context.canceled) {
            return;
        }
        String toInsert = this.getInsertText(context);
        if (toInsert == null || toInsert.length() == 0) {
            return;
        }
        IDocumentProvider dp = editor.getDocumentProvider();
        IDocument doc = dp.getDocument((Object)editor.getEditorInput());
        try {
            Control control;
            int offsetBefore = context.selectedOffset;
            if (offsetBefore == -1) {
                offsetBefore = this.asciiDoctorEditor.getLastCaretPosition();
            }
            doc.replace(offsetBefore, context.selectedLength, toInsert);
            if (context.nextOffset != -1 && (control = (Control)editor.getAdapter(Control.class)) instanceof StyledText) {
                StyledText text = (StyledText)control;
                text.setCaretOffset(context.nextOffset);
            }
        }
        catch (BadLocationException e) {
            AsciiDoctorEditorUtil.logError("was not able to insert " + toInsert, e);
        }
        this.afterInsert(context);
    }

    protected void afterInsert(InsertTextContext context) {
    }

    protected void beforeInsert(InsertTextContext context) {
    }

    protected class InsertTextContext {
        public int nextOffset = -1;
        public int selectedOffset;
        public int selectedLength;
        public String selectedText;
        protected Object data;
        protected boolean canceled;

        protected InsertTextContext() {
        }
    }
}

