/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.toolbar;

import de.jcup.asciidoctoreditor.AsciiDoctorEditor;
import de.jcup.asciidoctoreditor.document.keywords.AsciiDoctorSectionTitleKeyWords;
import de.jcup.asciidoctoreditor.toolbar.FormatTextAction;
import de.jcup.asciidoctoreditor.toolbar.ToolbarAction;
import java.util.EnumMap;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public class InsertSectionTitleAction
extends ToolbarAction
implements IMenuCreator {
    private Menu menu;
    private HeadlineViewSupport headlineViewSupport = new HeadlineViewSupport();
    private AsciiDoctorSectionTitleKeyWords valueVisibleOnToolbar = AsciiDoctorSectionTitleKeyWords.H1;

    public InsertSectionTitleAction(AsciiDoctorEditor asciiDoctorEditor) {
        super(asciiDoctorEditor);
        this.initUI();
    }

    public void run() {
        this.headlineViewSupport.buildAction(this.valueVisibleOnToolbar).run();
    }

    private void initUI() {
        this.setMenuCreator(this);
        this.initImageAndText();
    }

    private void initImageAndText() {
        this.setImageDescriptor(this.headlineViewSupport.getDescriptor(this.valueVisibleOnToolbar));
        this.setText(this.headlineViewSupport.getText(this.valueVisibleOnToolbar));
    }

    public void dispose() {
        if (this.menu != null) {
            this.menu.dispose();
            this.menu = null;
        }
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public Menu getMenu(Control parent) {
        if (this.menu != null) {
            this.menu.dispose();
        }
        this.menu = new Menu(parent);
        AsciiDoctorSectionTitleKeyWords[] asciiDoctorSectionTitleKeyWordsArray = AsciiDoctorSectionTitleKeyWords.values();
        int n = asciiDoctorSectionTitleKeyWordsArray.length;
        int n2 = 0;
        while (n2 < n) {
            AsciiDoctorSectionTitleKeyWords keyword = asciiDoctorSectionTitleKeyWordsArray[n2];
            this.addActionToMenu(this.menu, this.headlineViewSupport.buildAction(keyword));
            ++n2;
        }
        return this.menu;
    }

    protected void addActionToMenu(Menu parent, Action action) {
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(parent, -1);
    }

    private class HeadlineViewSupport {
        private EnumMap<AsciiDoctorSectionTitleKeyWords, ImageDescriptor> imgMap = new EnumMap(AsciiDoctorSectionTitleKeyWords.class);

        public HeadlineViewSupport() {
            AsciiDoctorSectionTitleKeyWords[] asciiDoctorSectionTitleKeyWordsArray = AsciiDoctorSectionTitleKeyWords.values();
            int n = asciiDoctorSectionTitleKeyWordsArray.length;
            int n2 = 0;
            while (n2 < n) {
                AsciiDoctorSectionTitleKeyWords keyword = asciiDoctorSectionTitleKeyWordsArray[n2];
                String path = "section_" + keyword.name().toLowerCase() + ".png";
                this.imgMap.put(keyword, InsertSectionTitleAction.createToolbarImageDescriptor(path));
                ++n2;
            }
        }

        public ImageDescriptor getDescriptor(AsciiDoctorSectionTitleKeyWords keyword) {
            return this.imgMap.get((Object)keyword);
        }

        public String getText(AsciiDoctorSectionTitleKeyWords keyword) {
            return keyword.getLabel();
        }

        public Action buildAction(final AsciiDoctorSectionTitleKeyWords keyword) {
            FormatTextAction action = new FormatTextAction(InsertSectionTitleAction.this.asciiDoctorEditor, this.getText(keyword), this.getDescriptor(keyword)){

                @Override
                public void run() {
                    super.run();
                    InsertSectionTitleAction.this.valueVisibleOnToolbar = keyword;
                    InsertSectionTitleAction.this.initImageAndText();
                }

                @Override
                protected String formatPrefix() {
                    return String.valueOf(keyword.getText()) + " ";
                }

                @Override
                protected String formatPostfix() {
                    return "\n";
                }
            };
            return action;
        }
    }
}

