/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.toolbar;

import de.jcup.asciidoctoreditor.AsciiDoctorEditor;
import de.jcup.asciidoctoreditor.document.keywords.AsciiDoctorAdmonitionParagraphKeyWords;
import de.jcup.asciidoctoreditor.toolbar.InsertTextAction;
import de.jcup.asciidoctoreditor.toolbar.ToolbarAction;
import java.util.EnumMap;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public class InsertAdmonitionAction
extends ToolbarAction
implements IMenuCreator {
    private Menu menu;
    private AdmonitionViewSupport admonitionViewSupport = new AdmonitionViewSupport();
    private AsciiDoctorAdmonitionParagraphKeyWords valueVisibleOnToolbar = AsciiDoctorAdmonitionParagraphKeyWords.NOTE;

    public InsertAdmonitionAction(AsciiDoctorEditor asciiDoctorEditor) {
        super(asciiDoctorEditor);
        this.initUI();
    }

    public void run() {
        this.admonitionViewSupport.buildAction(this.valueVisibleOnToolbar).run();
    }

    private void initUI() {
        this.setMenuCreator(this);
        this.initImageAndText();
    }

    private void initImageAndText() {
        this.setImageDescriptor(this.admonitionViewSupport.getDescriptor(this.valueVisibleOnToolbar));
        this.setText(this.admonitionViewSupport.getText(this.valueVisibleOnToolbar));
    }

    public void dispose() {
        if (this.menu != null) {
            this.menu.dispose();
            this.menu = null;
        }
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public Menu getMenu(Control parent) {
        if (this.menu != null) {
            this.menu.dispose();
        }
        this.menu = new Menu(parent);
        AsciiDoctorAdmonitionParagraphKeyWords[] asciiDoctorAdmonitionParagraphKeyWordsArray = AsciiDoctorAdmonitionParagraphKeyWords.values();
        int n = asciiDoctorAdmonitionParagraphKeyWordsArray.length;
        int n2 = 0;
        while (n2 < n) {
            AsciiDoctorAdmonitionParagraphKeyWords keyword = asciiDoctorAdmonitionParagraphKeyWordsArray[n2];
            this.addActionToMenu(this.menu, this.admonitionViewSupport.buildAction(keyword));
            ++n2;
        }
        return this.menu;
    }

    protected void addActionToMenu(Menu parent, Action action) {
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(parent, -1);
    }

    private class AdmonitionViewSupport {
        private EnumMap<AsciiDoctorAdmonitionParagraphKeyWords, ImageDescriptor> imgMap = new EnumMap(AsciiDoctorAdmonitionParagraphKeyWords.class);

        public AdmonitionViewSupport() {
            AsciiDoctorAdmonitionParagraphKeyWords[] asciiDoctorAdmonitionParagraphKeyWordsArray = AsciiDoctorAdmonitionParagraphKeyWords.values();
            int n = asciiDoctorAdmonitionParagraphKeyWordsArray.length;
            int n2 = 0;
            while (n2 < n) {
                AsciiDoctorAdmonitionParagraphKeyWords keyword = asciiDoctorAdmonitionParagraphKeyWordsArray[n2];
                String path = "admonition_" + keyword.name().toLowerCase() + ".png";
                this.imgMap.put(keyword, InsertAdmonitionAction.createToolbarImageDescriptor(path));
                ++n2;
            }
        }

        public ImageDescriptor getDescriptor(AsciiDoctorAdmonitionParagraphKeyWords keyword) {
            return this.imgMap.get((Object)keyword);
        }

        public String getText(AsciiDoctorAdmonitionParagraphKeyWords keyword) {
            return keyword.name();
        }

        public Action buildAction(final AsciiDoctorAdmonitionParagraphKeyWords keyword) {
            InsertTextAction action = new InsertTextAction(InsertAdmonitionAction.this.asciiDoctorEditor, this.getText(keyword), this.getDescriptor(keyword)){

                @Override
                public void run() {
                    super.run();
                    InsertAdmonitionAction.this.valueVisibleOnToolbar = keyword;
                    InsertAdmonitionAction.this.initImageAndText();
                }

                @Override
                protected String getInsertText(InsertTextAction.InsertTextContext context) {
                    return "[" + keyword.name() + "]\n" + "====\n" + "An admonition block may contain complex content.\n" + "\n" + "====\n";
                }
            };
            return action;
        }
    }
}

