/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.toolbar;

import de.jcup.asciidoctoreditor.AsciiDoctorEditor;
import de.jcup.asciidoctoreditor.toolbar.ToolbarAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class ChangeLayoutAction
extends ToolbarAction
implements IMenuCreator {
    private static final String SWITCH_TO_VERTICAL_LAYOUT = "Vertical layout";
    private static final String SWITCH_TO_HORIZONTAL_LAYOUT = "Horizontal layout";
    private static final String SWITCH_TO_EXTERNAL_LAYOUT = "Hide preview panel and use external browser";
    private static ImageDescriptor IMG_LAYOUT_VERTICAL = ChangeLayoutAction.createToolbarImageDescriptor("layout_vertical.png");
    private static ImageDescriptor IMG_LAYOUT_HORIZONTAL = ChangeLayoutAction.createToolbarImageDescriptor("layout_horizontal.png");
    private static ImageDescriptor IMG_LAYOUT_EXTERNAL = ChangeLayoutAction.createToolbarImageDescriptor("layout_external.png");
    private Menu menu;

    public ChangeLayoutAction(AsciiDoctorEditor asciiDoctorEditor) {
        super(asciiDoctorEditor);
        this.initUI();
    }

    public void run() {
    }

    private void initUI() {
        this.setMenuCreator(this);
        this.initImageAndText();
    }

    private void initImageAndText() {
        if (this.asciiDoctorEditor.isInternalPreview()) {
            this.setImageDescriptor(this.asciiDoctorEditor.isVerticalSplit() ? IMG_LAYOUT_VERTICAL : IMG_LAYOUT_HORIZONTAL);
            this.setText(this.asciiDoctorEditor.isVerticalSplit() ? SWITCH_TO_VERTICAL_LAYOUT : SWITCH_TO_HORIZONTAL_LAYOUT);
        } else {
            this.setImageDescriptor(IMG_LAYOUT_EXTERNAL);
            this.setText(SWITCH_TO_EXTERNAL_LAYOUT);
        }
    }

    public void dispose() {
        if (this.menu != null) {
            this.menu.dispose();
            this.menu = null;
        }
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public Menu getMenu(Control parent) {
        if (this.menu != null) {
            this.menu.dispose();
        }
        this.menu = new Menu(parent);
        Action switchToHorizontal = new Action(SWITCH_TO_HORIZONTAL_LAYOUT, IMG_LAYOUT_HORIZONTAL){

            public void run() {
                ChangeLayoutAction.this.asciiDoctorEditor.setVerticalSplit(false);
                ChangeLayoutAction.this.asciiDoctorEditor.setInternalPreview(true);
                ChangeLayoutAction.this.initImageAndText();
            }
        };
        Action switchToVertical = new Action(SWITCH_TO_VERTICAL_LAYOUT, IMG_LAYOUT_VERTICAL){

            public void run() {
                ChangeLayoutAction.this.asciiDoctorEditor.setVerticalSplit(true);
                ChangeLayoutAction.this.asciiDoctorEditor.setInternalPreview(true);
                ChangeLayoutAction.this.initImageAndText();
            }
        };
        Action switchToExternal = new Action(SWITCH_TO_EXTERNAL_LAYOUT, IMG_LAYOUT_EXTERNAL){

            public void run() {
                ChangeLayoutAction.this.asciiDoctorEditor.setInternalPreview(false);
                ChangeLayoutAction.this.initImageAndText();
            }
        };
        this.addActionToMenu(this.menu, switchToHorizontal);
        this.addActionToMenu(this.menu, switchToVertical);
        new MenuItem(this.menu, 2);
        this.addActionToMenu(this.menu, switchToExternal);
        return this.menu;
    }

    protected void addActionToMenu(Menu parent, Action action) {
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(parent, -1);
    }
}

