/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.search;

import de.jcup.asciidoctoreditor.search.AsciidocSearchResult;
import de.jcup.asciidoctoreditor.search.AsciidocSearchResultModel;
import de.jcup.asciidoctoreditor.util.AsciiDoctorEditorUtil;
import de.jcup.eclipse.commons.EclipseResourceHelper;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.search.ui.text.Match;

public class SearchOperation
implements IResourceProxyVisitor {
    private File fileBeingReferenced;
    private IProgressMonitor monitor;
    private AsciidocSearchResult result;

    public SearchOperation(File file) {
        this.fileBeingReferenced = file;
    }

    public void execute(AsciidocSearchResult result, IProgressMonitor monitor) throws CoreException {
        this.monitor = monitor;
        this.result = result;
        ResourcesPlugin.getWorkspace().getRoot().accept((IResourceProxyVisitor)this, 2);
    }

    protected void handleFile(IFile file) throws CoreException {
        if (file == null) {
            return;
        }
        if (!AsciiDoctorEditorUtil.isAsciidocFileExtension(file.getFileExtension())) {
            return;
        }
        String p = file.getProjectRelativePath().toString();
        if (p.startsWith("bin/")) {
            return;
        }
        if (p.startsWith("build/")) {
            return;
        }
        if (p.startsWith("target/")) {
            return;
        }
        File inspectFile = EclipseResourceHelper.DEFAULT.toFile((IResource)file);
        if (inspectFile == null) {
            return;
        }
        AsciidocSearchResultModel model = this.result.getModel();
        AsciidocSearchResultModel.ResourceElement resourceElement = null;
        try {
            if (this.isCanceled()) {
                return;
            }
            List lines = FileUtils.readLines((File)inspectFile, (String)"UTF-8");
            int offset = 0;
            int lineNr = 0;
            for (String line : lines) {
                if (this.isCanceled()) {
                    return;
                }
                ++lineNr;
                AsciidocSearchResultModel.ResourceElement.ResourceLineElement lineElement = null;
                int index = -1;
                int pos = 0;
                while (true) {
                    if (this.isCanceled()) {
                        return;
                    }
                    index = line.indexOf(this.fileBeingReferenced.getName(), pos);
                    if (index == -1) break;
                    if (resourceElement == null) {
                        resourceElement = model.addResourceElement((IResource)file);
                    }
                    if (lineElement == null) {
                        lineElement = resourceElement.createNewLine(lineNr);
                    }
                    AsciidocSearchResultModel.ResourceElement.ResourceLineElement.ResourceLineContentElement content = lineElement.addContent(line, offset);
                    Match match = new Match((Object)content, offset + index, this.fileBeingReferenced.getName().length());
                    this.result.addMatch(match);
                    pos = index + 1;
                }
                offset += line.length() + 1;
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "de.jcup.asciidoctoreditor", "Was not able to readlines in file:" + file, (Throwable)e));
        }
    }

    public boolean visit(IResourceProxy proxy) throws CoreException {
        if (proxy.getType() == 1) {
            IFile file = (IFile)proxy.requestResource();
            this.handleFile(file);
        }
        return true;
    }

    public boolean isCanceled() {
        return this.monitor != null && this.monitor.isCanceled();
    }
}

