/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.search;

import de.jcup.asciidoctoreditor.search.AsciidocSearchResultElement;
import de.jcup.asciidoctoreditor.search.AsciidocSearchResultLabelProvider;
import de.jcup.asciidoctoreditor.search.AsciidocSearchResultModel;
import de.jcup.asciidoctoreditor.search.FileTableContentProvider;
import de.jcup.asciidoctoreditor.search.FileTreeContentProvider;
import de.jcup.asciidoctoreditor.util.AsciiDoctorEditorUtil;
import de.jcup.eclipse.commons.ui.EclipseUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.search.ui.ISearchResultPage;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public class AsciidocSearchResultPage
extends AbstractTextSearchViewPage
implements ISearchResultPage {
    protected void elementsChanged(Object[] objects) {
        this.getViewer().refresh();
    }

    protected void clear() {
        this.getViewer().refresh();
    }

    protected StructuredViewer getViewer() {
        return super.getViewer();
    }

    protected void configureTreeViewer(TreeViewer viewer) {
        viewer.setLabelProvider((IBaseLabelProvider)new AsciidocSearchResultLabelProvider());
        viewer.setContentProvider((IContentProvider)new FileTreeContentProvider(this, (AbstractTreeViewer)viewer));
        viewer.addDoubleClickListener((IDoubleClickListener)new AsciidocSearchResultElementDoubleClickListener());
    }

    protected void configureTableViewer(TableViewer viewer) {
        viewer.setLabelProvider((IBaseLabelProvider)new AsciidocSearchResultLabelProvider());
        viewer.setContentProvider((IContentProvider)new FileTableContentProvider(this));
        viewer.addDoubleClickListener((IDoubleClickListener)new AsciidocSearchResultElementDoubleClickListener());
    }

    private class AsciidocSearchResultElementDoubleClickListener
    implements IDoubleClickListener {
        private AsciidocSearchResultElementDoubleClickListener() {
        }

        public void doubleClick(DoubleClickEvent event) {
            ISelection selection = AsciidocSearchResultPage.this.getViewer().getSelection();
            if (!(selection instanceof IStructuredSelection)) {
                return;
            }
            IStructuredSelection iss = (IStructuredSelection)selection;
            Object first = iss.getFirstElement();
            if (!(first instanceof AsciidocSearchResultElement)) {
                return;
            }
            SelectionContext context = new SelectionContext();
            AsciidocSearchResultElement element = (AsciidocSearchResultElement)first;
            if (element instanceof AsciidocSearchResultModel.ResourceElement.ResourceLineElement.ResourceLineContentElement) {
                context.selectClickTarget((AsciidocSearchResultModel.ResourceElement.ResourceLineElement.ResourceLineContentElement)first);
                element = element.getParent();
            }
            if (element instanceof AsciidocSearchResultModel.ResourceElement.ResourceLineElement) {
                context.useFirstLineElementChildWhenNotAlreadySelected((AsciidocSearchResultModel.ResourceElement.ResourceLineElement)element);
                element = element.getParent();
            }
            if (element instanceof AsciidocSearchResultModel.ResourceElement) {
                AsciidocSearchResultModel.ResourceElement re = (AsciidocSearchResultModel.ResourceElement)element;
                context.useFirstResourceElementChildrenWhenNotAlreadySelected(re);
                IResource resource = re.getResource();
                if (resource instanceof IFile) {
                    IFile file = (IFile)resource;
                    try {
                        IWorkbenchPage page = EclipseUtil.getActivePage();
                        IEditorPart editor = IDE.openEditor((IWorkbenchPage)page, (IFile)file);
                        if (editor instanceof AbstractTextEditor) {
                            AbstractTextEditor ae = (AbstractTextEditor)editor;
                            ae.selectAndReveal(context.start, context.length);
                        }
                    }
                    catch (PartInitException e) {
                        AsciiDoctorEditorUtil.logError("Was not able to open editor file of:" + file, e);
                    }
                }
            }
        }

        private class SelectionContext {
            int start = 0;
            int length = 0;
            boolean selectionDone = false;

            private SelectionContext() {
            }

            public void selectClickTarget(AsciidocSearchResultModel.ResourceElement.ResourceLineElement.ResourceLineContentElement rlce) {
                this.selectionDone = true;
                this.start = rlce.getOffset();
                this.length = rlce.getText().length();
            }

            public void useFirstLineElementChildWhenNotAlreadySelected(AsciidocSearchResultModel.ResourceElement.ResourceLineElement element) {
                if (this.selectionDone) {
                    return;
                }
                AsciidocSearchResultModel.ResourceElement.ResourceLineElement line = element;
                Object[] children = line.getChildren();
                if (children == null || children.length == 0) {
                    return;
                }
                Object child = children[0];
                if (child instanceof AsciidocSearchResultModel.ResourceElement.ResourceLineElement.ResourceLineContentElement) {
                    AsciidocSearchResultModel.ResourceElement.ResourceLineElement.ResourceLineContentElement rlce = (AsciidocSearchResultModel.ResourceElement.ResourceLineElement.ResourceLineContentElement)children[0];
                    this.selectClickTarget(rlce);
                }
            }

            public void useFirstResourceElementChildrenWhenNotAlreadySelected(AsciidocSearchResultModel.ResourceElement re) {
                if (this.selectionDone) {
                    return;
                }
                Object[] children = re.getChildren();
                if (children == null || children.length == 0) {
                    return;
                }
                Object child = children[0];
                if (child instanceof AsciidocSearchResultModel.ResourceElement.ResourceLineElement) {
                    this.useFirstLineElementChildWhenNotAlreadySelected((AsciidocSearchResultModel.ResourceElement.ResourceLineElement)child);
                }
            }
        }
    }
}

